/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.UtilLoggingLevel;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class LevelInequalityRule {
    private static List levelList;
    private static List utilLoggingLevelList;

    private LevelInequalityRule() {
    }

    private static void populateLevels() {
        levelList = new LinkedList();
        levelList.add(Level.FATAL.toString());
        levelList.add(Level.ERROR.toString());
        levelList.add(Level.WARN.toString());
        levelList.add(Level.INFO.toString());
        levelList.add(Level.DEBUG.toString());
        Level trace = Level.toLevel(5000, null);
        if (trace != null) {
            levelList.add(trace.toString());
        }
        utilLoggingLevelList = new LinkedList();
        utilLoggingLevelList.add(UtilLoggingLevel.SEVERE.toString());
        utilLoggingLevelList.add(UtilLoggingLevel.WARNING.toString());
        utilLoggingLevelList.add(UtilLoggingLevel.INFO.toString());
        utilLoggingLevelList.add(UtilLoggingLevel.CONFIG.toString());
        utilLoggingLevelList.add(UtilLoggingLevel.FINE.toString());
        utilLoggingLevelList.add(UtilLoggingLevel.FINER.toString());
        utilLoggingLevelList.add(UtilLoggingLevel.FINEST.toString());
    }

    public static Rule getRule(String inequalitySymbol, String value) {
        Level thisLevel;
        if (levelList.contains(value.toUpperCase())) {
            thisLevel = Level.toLevel(value.toUpperCase());
        } else if (utilLoggingLevelList.contains(value.toUpperCase())) {
            thisLevel = UtilLoggingLevel.toLevel(value.toUpperCase());
        } else {
            throw new IllegalArgumentException("Invalid level inequality rule - " + value + " is not a supported level");
        }
        if ("<".equals(inequalitySymbol)) {
            return new LessThanRule(thisLevel);
        }
        if (">".equals(inequalitySymbol)) {
            return new GreaterThanRule(thisLevel);
        }
        if ("<=".equals(inequalitySymbol)) {
            return new LessThanEqualsRule(thisLevel);
        }
        if (">=".equals(inequalitySymbol)) {
            return new GreaterThanEqualsRule(thisLevel);
        }
        return null;
    }

    static {
        LevelInequalityRule.populateLevels();
    }

    private static final class LessThanEqualsRule
    extends AbstractRule {
        private final int newLevelInt;

        public LessThanEqualsRule(Level level) {
            this.newLevelInt = level.toInt();
        }

        public boolean evaluate(LoggingEvent event, Map matches) {
            boolean result;
            Level eventLevel = event.getLevel();
            boolean bl = result = eventLevel.toInt() <= this.newLevelInt;
            if (result && matches != null) {
                HashSet<Level> entries = (HashSet<Level>)matches.get("LEVEL");
                if (entries == null) {
                    entries = new HashSet<Level>();
                    matches.put("LEVEL", entries);
                }
                entries.add(eventLevel);
            }
            return result;
        }
    }

    private static final class GreaterThanEqualsRule
    extends AbstractRule {
        private final int newLevelInt;

        public GreaterThanEqualsRule(Level level) {
            this.newLevelInt = level.toInt();
        }

        public boolean evaluate(LoggingEvent event, Map matches) {
            boolean result;
            Level eventLevel = event.getLevel();
            boolean bl = result = eventLevel.toInt() >= this.newLevelInt;
            if (result && matches != null) {
                HashSet<Level> entries = (HashSet<Level>)matches.get("LEVEL");
                if (entries == null) {
                    entries = new HashSet<Level>();
                    matches.put("LEVEL", entries);
                }
                entries.add(eventLevel);
            }
            return result;
        }
    }

    private static final class GreaterThanRule
    extends AbstractRule {
        private final int newLevelInt;

        public GreaterThanRule(Level level) {
            this.newLevelInt = level.toInt();
        }

        public boolean evaluate(LoggingEvent event, Map matches) {
            boolean result;
            Level eventLevel = event.getLevel();
            boolean bl = result = eventLevel.toInt() > this.newLevelInt;
            if (result && matches != null) {
                HashSet<Level> entries = (HashSet<Level>)matches.get("LEVEL");
                if (entries == null) {
                    entries = new HashSet<Level>();
                    matches.put("LEVEL", entries);
                }
                entries.add(eventLevel);
            }
            return result;
        }
    }

    private static final class LessThanRule
    extends AbstractRule {
        private final int newLevelInt;

        public LessThanRule(Level level) {
            this.newLevelInt = level.toInt();
        }

        public boolean evaluate(LoggingEvent event, Map matches) {
            boolean result;
            Level eventLevel = event.getLevel();
            boolean bl = result = eventLevel.toInt() < this.newLevelInt;
            if (result && matches != null) {
                HashSet<Level> entries = (HashSet<Level>)matches.get("LEVEL");
                if (entries == null) {
                    entries = new HashSet<Level>();
                    matches.put("LEVEL", entries);
                }
                entries.add(eventLevel);
            }
            return result;
        }
    }
}

