/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar;

import java.util.Arrays;
import java.util.Random;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMUtil;

public class MsgCookie {
    private byte[] cookie;
    private int type;
    private Object data;
    private long addTime;

    public MsgCookie() {
    }

    public MsgCookie(AIMConnection conn, byte[] cookie, int type, Object data) {
        if (cookie == null) {
            cookie = new byte[8];
            new Random().nextBytes(cookie);
        }
        this.cookie = cookie;
        this.type = type;
        this.data = data;
        this.addTime = System.currentTimeMillis();
        MsgCookie.cacheCookie(conn, this);
    }

    public MsgCookie(AIMConnection conn, byte[] cookie, int type, Object data, boolean toc) {
        if (cookie == null) {
            cookie = MsgCookie.genCookie(toc);
        }
        this.cookie = cookie;
        this.type = type;
        this.data = data;
        this.addTime = System.currentTimeMillis();
        MsgCookie.cacheCookie(conn, this);
    }

    public static byte[] genCookie(boolean toc) {
        byte[] cookie = new byte[8];
        if (toc) {
            Random random = new Random();
            for (int i = 0; i < cookie.length - 1; ++i) {
                cookie[i] = (byte)(48 + random.nextInt(10));
            }
            cookie[cookie.length - 1] = 0;
        } else {
            new Random().nextBytes(cookie);
        }
        return cookie;
    }

    public byte[] getCookie() {
        return this.cookie;
    }

    public void setCookie(byte[] cookie) {
        this.cookie = cookie;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public long getAddTime() {
        return this.addTime;
    }

    public void setAddTime(long addTime) {
        this.addTime = addTime;
    }

    public static void cacheCookie(AIMConnection conn, MsgCookie cookie) {
        MsgCookie newCookie = MsgCookie.checkCookie(conn, cookie);
        if (newCookie != null && newCookie.equals(cookie)) {
            newCookie.setAddTime(System.currentTimeMillis());
            return;
        }
        cookie.setAddTime(System.currentTimeMillis());
        conn.addCookie(cookie);
    }

    public static MsgCookie uncacheCookie(AIMConnection conn, MsgCookie cookie) {
        MsgCookie newCookie = MsgCookie.checkCookie(conn, cookie);
        if (newCookie != null) {
            conn.remCookie(cookie);
            return newCookie;
        }
        return null;
    }

    public static MsgCookie checkCookie(AIMConnection conn, MsgCookie cookie) {
        MsgCookie cur;
        while ((cur = conn.remCookie(cookie)) != null) {
            if (!cur.equals(cookie)) continue;
            return cur;
        }
        return null;
    }

    public int getType(int reqClass) {
        switch (reqClass) {
            case 1: {
                return 19;
            }
            case 2: {
                return 19;
            }
            case 4: {
                return 20;
            }
            case 8: {
                return 5;
            }
            case 16: {
                return 17;
            }
            case 32: {
                return 0;
            }
        }
        return 0;
    }

    public boolean equals(Object obj) {
        MsgCookie cookie = (MsgCookie)obj;
        return this.type == cookie.getType() && Arrays.equals(this.cookie, cookie.getCookie());
    }

    public int hashCode() {
        return AIMUtil.byteArrayToHexString(this.cookie).hashCode();
    }
}

