/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.util;

import com.google.ical.util.DTBuilder;
import com.google.ical.values.DateTimeValue;
import com.google.ical.values.DateTimeValueImpl;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.TimeValue;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    private static TimeZone ZULU = new SimpleTimeZone(0, "Etc/GMT");
    private static int[] MONTH_START_TO_DOY = new int[12];
    private static final long SECS_PER_DAY = 86400L;
    private static final TimeZone BOGUS_TIMEZONE;
    private static final Pattern UTC_TZID;

    static {
        assert (!TimeUtils.isLeapYear(1970));
        int m = 1;
        while (m < 12) {
            TimeUtils.MONTH_START_TO_DOY[m] = MONTH_START_TO_DOY[m - 1] + TimeUtils.monthLength(1970, m);
            ++m;
        }
        assert (365 == MONTH_START_TO_DOY[11] + TimeUtils.monthLength(1970, 12)) : "" + (MONTH_START_TO_DOY[11] + TimeUtils.monthLength(1970, 12));
        BOGUS_TIMEZONE = TimeZone.getTimeZone("noSuchTimeZone");
        UTC_TZID = Pattern.compile("^GMT([+-]0(:00)?)?$|UTC|Zulu|Etc\\/GMT|Greenwich.*", 2);
    }

    public static TimeZone utcTimezone() {
        return ZULU;
    }

    private static long timetMillisFromEpochSecs(long epochSecs, TimeZone zone) {
        DateTimeValue date = TimeUtils.timeFromSecsSinceEpoch(epochSecs);
        GregorianCalendar cal = new GregorianCalendar(zone);
        cal.clear();
        ((Calendar)cal).setTimeZone(zone);
        cal.set(date.year(), date.month() - 1, date.day(), date.hour(), date.minute(), date.second());
        return cal.getTimeInMillis();
    }

    private static DateTimeValue convert(DateTimeValue time, TimeZone zone, int sense) {
        if (zone == null || zone.hasSameRules(ZULU) || time.year() == 0) {
            return time;
        }
        long timetMillis = 0L;
        timetMillis = sense > 0 ? TimeUtils.timetMillisFromEpochSecs(TimeUtils.secsSinceEpoch(time), ZULU) : TimeUtils.timetMillisFromEpochSecs(TimeUtils.secsSinceEpoch(time), zone);
        int millisecondOffset = zone.getOffset(timetMillis);
        int millisecondRound = millisecondOffset < 0 ? -500 : 500;
        int secondOffset = (millisecondOffset + millisecondRound) / 1000;
        return TimeUtils.addSeconds(time, sense * secondOffset);
    }

    public static DateValue fromUtc(DateValue date, TimeZone zone) {
        return date instanceof DateTimeValue ? TimeUtils.fromUtc((DateTimeValue)date, zone) : date;
    }

    public static DateTimeValue fromUtc(DateTimeValue date, TimeZone zone) {
        return TimeUtils.convert(date, zone, 1);
    }

    public static DateValue toUtc(DateValue date, TimeZone zone) {
        return date instanceof TimeValue ? TimeUtils.convert((DateTimeValue)date, zone, -1) : date;
    }

    private static DateTimeValue addSeconds(DateTimeValue dtime, int seconds) {
        return new DTBuilder(dtime.year(), dtime.month(), dtime.day(), dtime.hour(), dtime.minute(), dtime.second() + seconds).toDateTime();
    }

    public static DateValue add(DateValue d, DateValue dur) {
        DTBuilder db = new DTBuilder(d);
        db.year += dur.year();
        db.month += dur.month();
        db.day += dur.day();
        if (dur instanceof TimeValue) {
            TimeValue tdur = (TimeValue)((Object)dur);
            db.hour += tdur.hour();
            db.minute += tdur.minute();
            db.second += tdur.second();
            return db.toDateTime();
        }
        if (d instanceof TimeValue) {
            return db.toDateTime();
        }
        return db.toDate();
    }

    public static int daysBetween(DateValue dv1, DateValue dv2) {
        return TimeUtils.fixedFromGregorian(dv1) - TimeUtils.fixedFromGregorian(dv2);
    }

    public static int daysBetween(int y1, int m1, int d1, int y2, int m2, int d2) {
        return TimeUtils.fixedFromGregorian(y1, m1, d1) - TimeUtils.fixedFromGregorian(y2, m2, d2);
    }

    private static int fixedFromGregorian(DateValue date) {
        return TimeUtils.fixedFromGregorian(date.year(), date.month(), date.day());
    }

    public static int fixedFromGregorian(int year, int month, int day) {
        int yearM1 = year - 1;
        return 365 * yearM1 + yearM1 / 4 - yearM1 / 100 + yearM1 / 400 + (367 * month - 362) / 12 + (month <= 2 ? 0 : (TimeUtils.isLeapYear(year) ? -1 : -2)) + day;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static int yearLength(int year) {
        return TimeUtils.isLeapYear(year) ? 366 : 365;
    }

    public static int monthLength(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                return TimeUtils.isLeapYear(year) ? 29 : 28;
            }
        }
        throw new AssertionError(month);
    }

    public static int dayOfYear(int year, int month, int date) {
        int leapAdjust = month > 2 && TimeUtils.isLeapYear(year) ? 1 : 0;
        return MONTH_START_TO_DOY[month - 1] + leapAdjust + date - 1;
    }

    public static DateTimeValue timeFromSecsSinceEpoch(long secsSinceEpoch) {
        int secsInDay = (int)(secsSinceEpoch % 86400L);
        int daysSinceEpoch = (int)(secsSinceEpoch / 86400L);
        int approx = (int)((long)(daysSinceEpoch + 10) * 400L / 146097L);
        int year = daysSinceEpoch >= TimeUtils.fixedFromGregorian(approx + 1, 1, 1) ? approx + 1 : approx;
        int jan1 = TimeUtils.fixedFromGregorian(year, 1, 1);
        int priorDays = daysSinceEpoch - jan1;
        int march1 = TimeUtils.fixedFromGregorian(year, 3, 1);
        int correction = daysSinceEpoch < march1 ? 0 : (TimeUtils.isLeapYear(year) ? 1 : 2);
        int month = (12 * (priorDays + correction) + 373) / 367;
        int month1 = TimeUtils.fixedFromGregorian(year, month, 1);
        int day = daysSinceEpoch - month1 + 1;
        int second = secsInDay % 60;
        int minutesInDay = secsInDay / 60;
        int minute = minutesInDay % 60;
        int hour = minutesInDay / 60;
        if (hour < 0 || hour >= 24) {
            throw new AssertionError((Object)("Input was: " + secsSinceEpoch + "to make hour: " + hour));
        }
        DateTimeValueImpl result = new DateTimeValueImpl(year, month, day, hour, minute, second);
        return result;
    }

    public static long secsSinceEpoch(DateValue date) {
        long result = (long)TimeUtils.fixedFromGregorian(date) * 86400L;
        if (date instanceof TimeValue) {
            TimeValue time = (TimeValue)((Object)date);
            result += (long)(time.second() + 60 * (time.minute() + 60 * time.hour()));
        }
        return result;
    }

    public static DateTimeValue dayStart(DateValue dv) {
        return new DateTimeValueImpl(dv.year(), dv.month(), dv.day(), 0, 0, 0);
    }

    public static DateValue toDateValue(DateValue dv) {
        return !(dv instanceof TimeValue) ? dv : new DateValueImpl(dv.year(), dv.month(), dv.day());
    }

    public static TimeZone timeZoneForName(String tzString) {
        TimeZone tz = TimeZone.getTimeZone(tzString);
        if (tz.hasSameRules(BOGUS_TIMEZONE)) {
            Matcher m = UTC_TZID.matcher(tzString);
            if (m.matches()) {
                return TimeUtils.utcTimezone();
            }
            return null;
        }
        return tz;
    }

    private TimeUtils() {
    }
}

