/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

final class MlibCompositeOpImage
extends PointOpImage {
    private RenderedImage alpha;

    public MlibCompositeOpImage(RenderedImage source1, RenderedImage source2, Map config, ImageLayout layout, RenderedImage alpha) {
        super(source1, source2, layout, config, true);
        this.alpha = alpha;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        int formatTag = MediaLibAccessor.findCompatibleTag(sources, dest);
        MediaLibAccessor srcMA1 = new MediaLibAccessor(sources[0], destRect, formatTag);
        MediaLibAccessor srcMA2 = new MediaLibAccessor(sources[1], destRect, formatTag);
        MediaLibAccessor dstMA = new MediaLibAccessor(dest, destRect, formatTag);
        MediaLibAccessor alphaMA = new MediaLibAccessor(this.alpha.getData(destRect), destRect, formatTag);
        mediaLibImage[] srcMLI1 = srcMA1.getMediaLibImages();
        mediaLibImage[] srcMLI2 = srcMA2.getMediaLibImages();
        mediaLibImage[] dstMLI = dstMA.getMediaLibImages();
        mediaLibImage[] alphaMLI = alphaMA.getMediaLibImages();
        switch (dstMA.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                for (int i = 0; i < dstMLI.length; ++i) {
                    Image.Blend((mediaLibImage)dstMLI[i], (mediaLibImage)srcMLI1[i], (mediaLibImage)srcMLI2[i], (mediaLibImage)alphaMLI[0]);
                }
                break;
            }
            case 4: 
            case 5: {
                for (int i = 0; i < dstMLI.length; ++i) {
                    Image.Blend_Fp((mediaLibImage)dstMLI[i], (mediaLibImage)srcMLI1[i], (mediaLibImage)srcMLI2[i], (mediaLibImage)alphaMLI[0]);
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("Generic2"));
            }
        }
        if (dstMA.isDataCopy()) {
            dstMA.clampDataArrays();
            dstMA.copyDataToRaster();
        }
    }
}

