create table Calendar (
	uuid_ nvarchar(75) null,
	calendarId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	resourceBlockId bigint,
	calendarResourceId bigint,
	name nvarchar(2000) null,
	description nvarchar(2000) null,
	timeZoneId nvarchar(75) null,
	color int,
	defaultCalendar bit,
	enableComments bit,
	enableRatings bit
);

create table CalendarBooking (
	uuid_ nvarchar(75) null,
	calendarBookingId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	resourceBlockId bigint,
	calendarId bigint,
	calendarResourceId bigint,
	parentCalendarBookingId bigint,
	vEventUid nvarchar(255) null,
	title nvarchar(2000) null,
	description nvarchar(max) null,
	location nvarchar(2000) null,
	startTime bigint,
	endTime bigint,
	allDay bit,
	recurrence nvarchar(2000) null,
	firstReminder bigint,
	firstReminderType nvarchar(75) null,
	secondReminder bigint,
	secondReminderType nvarchar(75) null,
	status int,
	statusByUserId bigint,
	statusByUserName nvarchar(75) null,
	statusDate datetime null
);

create table CalendarNotificationTemplate (
	uuid_ nvarchar(75) null,
	calendarNotificationTemplateId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	calendarId bigint,
	notificationType nvarchar(75) null,
	notificationTypeSettings nvarchar(75) null,
	notificationTemplateType nvarchar(75) null,
	subject nvarchar(75) null,
	body nvarchar(max) null
);

create table CalendarResource (
	uuid_ nvarchar(75) null,
	calendarResourceId bigint not null primary key,
	groupId bigint,
	companyId bigint,
	userId bigint,
	userName nvarchar(75) null,
	createDate datetime null,
	modifiedDate datetime null,
	resourceBlockId bigint,
	classNameId bigint,
	classPK bigint,
	classUuid nvarchar(75) null,
	code_ nvarchar(75) null,
	name nvarchar(2000) null,
	description nvarchar(2000) null,
	active_ bit
);
