/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.common.security.handlers;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.common.clients.stubs.jaxws.handlers.AbstractHandler;
import org.gcube.soa3.connector.common.security.CredentialManager;
import org.gcube.soa3.connector.common.security.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOA3Handler
extends AbstractHandler {
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void handleRequest(GCoreService<?> target, SOAPHeader header, SOAPMessageContext context) throws Exception {
        this.log.debug("Handling request");
        try {
            this.addCurrentCredentials(header);
        }
        catch (Exception e) {
            this.log.error("cannot configure outgoing message", (Throwable)e);
            throw new RuntimeException("cannot configure outgoing message", e);
        }
    }

    private void addCurrentCredentials(SOAPHeader header) throws Exception {
        Credentials credentials = CredentialManager.instance.get();
        if (credentials != null) {
            this.log.debug("Credentials found");
            if (credentials.getHeaderString() != null) {
                this.log.debug("Message level security: generating new SOAP security header");
                SOAPHeaderElement securityHeader = header.addHeaderElement(new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "BinarySecurityToken", "wsse"));
                securityHeader.setAttribute("ValueType", credentials.getAuthenticationType());
                securityHeader.setAttribute("EncodingType", "wsse:Base64Binary");
                securityHeader.setAttribute("Id", "SecurityToken");
                securityHeader.setValue(credentials.getHeaderString());
                this.log.debug("Security header created");
            } else {
                this.log.debug("No message level security needed");
            }
        } else {
            this.log.debug("No credentials found in the current context");
        }
    }
}

