/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.role.service;

import it.eng.rdlab.um.ldap.LdapModelGenerator;
import it.eng.rdlab.um.ldap.role.bean.LdapRoleModel;
import it.eng.rdlab.um.ldap.role.bean.LdapRoleModelWrapper;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapRoleModelGenerator
implements LdapModelGenerator {
    private Log log = LogFactory.getLog(this.getClass());

    public LdapRoleModel generate(String dn, Attributes attributes, boolean validate) throws NamingException, LdapManagerException {
        this.log.debug((Object)"Creating new role Model");
        LdapRoleModel response = new LdapRoleModel();
        response.setDN(dn);
        NamingEnumeration<? extends Attribute> resultAttributes = attributes.getAll();
        while (resultAttributes.hasMore()) {
            String value;
            Attribute attribute = resultAttributes.next();
            String attributeId = attribute.getID();
            this.log.debug((Object)("Attribute id = " + attributeId));
            NamingEnumeration<?> values = attribute.getAll();
            if (attributeId.equals("objectClass")) {
                this.log.debug((Object)"Generating class object list");
                while (values.hasMore()) {
                    value = (String)values.next();
                    this.log.debug((Object)("Found value " + value));
                    response.addObjectClass(value);
                }
                continue;
            }
            if (attributeId.equals("cn")) {
                response.setRoleName(values.next().toString());
                continue;
            }
            if (attributeId.equals("description")) {
                response.setDescription(values.next().toString());
                continue;
            }
            if (attributeId.equals("roleOccupant")) {
                while (values.hasMore()) {
                    String roleOccupantDn = values.next().toString();
                    this.log.debug((Object)("Adding member " + roleOccupantDn));
                    response.addRoleOccupantDN(roleOccupantDn);
                }
                continue;
            }
            this.log.debug((Object)"Updating attribute map...");
            if (!values.hasMore()) continue;
            value = values.next();
            this.log.debug((Object)("Found value " + value));
            if (value instanceof String) {
                response.addExtraAttribute(attributeId, value);
                continue;
            }
            this.log.warn((Object)("Not string value found in " + attributeId));
        }
        if (validate) {
            this.log.debug((Object)"Validate result...");
            if (!new LdapRoleModelWrapper(response).validateData()) {
                throw new LdapManagerException("Received not valid data");
            }
        }
        this.log.debug((Object)"Model generated");
        return response;
    }
}

