/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.crossoperations;

import it.eng.rdlab.um.crossoperations.UserGroupOperations;
import it.eng.rdlab.um.exceptions.GroupRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.exceptions.UserRetrievalException;
import it.eng.rdlab.um.group.beans.GroupModel;
import it.eng.rdlab.um.ldap.group.bean.LdapGroupModel;
import it.eng.rdlab.um.ldap.group.service.LdapGroupManager;
import it.eng.rdlab.um.ldap.user.service.LdapUserManager;
import it.eng.rdlab.um.user.beans.UserModel;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUserGroupOperations
implements UserGroupOperations {
    private Log log;
    private LdapUserManager userManager;
    private LdapGroupManager groupManager;

    public LdapUserGroupOperations(LdapUserManager userManager, LdapGroupManager groupManager) throws ConfigurationException {
        if (userManager == null || groupManager == null) {
            throw new ConfigurationException("At least one of the default managers is null");
        }
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.log = LogFactory.getLog(this.getClass());
    }

    public boolean assignUserToGroup(String userId, String groupId) throws UserManagementSystemException, GroupRetrievalException, UserRetrievalException {
        this.log.debug((Object)"Assign user to group");
        this.log.debug((Object)"Forcing to find the user in order to verify if exists");
        this.userManager.getUser(userId);
        this.log.debug((Object)"User exists");
        LdapGroupModel groupModel = (LdapGroupModel)this.groupManager.getGroup(groupId);
        if (groupModel == null) {
            this.log.error((Object)("Group " + groupId + " not found"));
            throw new GroupRetrievalException("Group " + groupId + " not found");
        }
        groupModel.addMemberDN(userId);
        boolean response = this.groupManager.updateGroup(groupModel);
        this.log.debug((Object)("Operation complete with response " + response));
        return response;
    }

    public boolean dismissUserFromGroup(String userId, String groupId) throws UserManagementSystemException, GroupRetrievalException, UserRetrievalException {
        this.log.debug((Object)"Removing user from group");
        LdapGroupModel groupModel = (LdapGroupModel)this.groupManager.getGroup(groupId);
        boolean response = false;
        if (groupModel.getMemberDNS().remove(userId)) {
            response = this.groupManager.updateGroup(groupModel);
        } else {
            this.log.warn((Object)("Element " + userId + " not found"));
            response = true;
        }
        this.log.debug((Object)("Operation complete with response " + response));
        return response;
    }

    public List<GroupModel> listGroupsByUser(String userId) throws UserManagementSystemException, GroupRetrievalException, UserRetrievalException {
        this.log.debug((Object)("Listing all groups that contains the user " + userId));
        LdapGroupModel filter = new LdapGroupModel();
        filter.addMemberDN(userId);
        List<GroupModel> groupModels = this.groupManager.listGroups(filter);
        this.log.debug((Object)("response size = " + groupModels.size()));
        return groupModels;
    }

    public List<UserModel> listUsersByGroup(String groupId) throws UserManagementSystemException, GroupRetrievalException, UserRetrievalException {
        return this.listUsersByGroup(groupId, null);
    }

    public List<UserModel> listUsersByGroup(String groupId, List<String> excludedDn) throws UserManagementSystemException, GroupRetrievalException, UserRetrievalException {
        this.log.debug((Object)("Listing all the users contained in the group " + groupId));
        LdapGroupModel groupModel = (LdapGroupModel)this.groupManager.getGroup(groupId);
        List<String> userIds = groupModel.getMemberDNS();
        ArrayList<UserModel> response = new ArrayList<UserModel>();
        for (String dn : userIds) {
            this.log.debug((Object)("Getting user with DN " + dn));
            try {
                UserModel userModel = this.userManager.getUser(dn);
                if (userModel == null) {
                    this.log.error((Object)("User with dn " + dn + " not found!"));
                    continue;
                }
                response.add(userModel);
            }
            catch (Exception e) {
                this.log.warn((Object)("User " + dn + " not found"));
            }
        }
        this.log.debug((Object)("Response size = " + response.size()));
        return response;
    }

    public void close() {
        this.userManager.close();
        this.groupManager.close();
    }
}

