/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.service.jaxrs;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.core.HttpContext;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.Attribute;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.AuthZRequestBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.engine.PolicyDecisionEngine;
import it.eng.rdlab.soa3.pm.connector.service.beans.PolicyRequestBean;
import it.eng.rdlab.soa3.pm.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.pm.connector.service.factory.PolicyDecisionEngineFactory;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/policyquery")
public class PolicyDecisionService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PolicyDecisionEngine engine;

    public PolicyDecisionService() {
        Configuration.init();
        this.engine = PolicyDecisionEngineFactory.getPolicyDecisionEngine();
        if (this.engine == null) {
            this.logger.error("Unable to create a policy decision engine");
        }
    }

    @GET
    @Path(value="/rolequery/{role}/{action}/{resource}")
    @Produces(value={"text/plain"})
    public Response getDecision(@PathParam(value="role") String role, @PathParam(value="action") String action, @PathParam(value="resource") String resource, @Context HttpContext context) {
        this.logger.debug("Get decision");
        if (this.engine != null) {
            this.logger.debug("Asking Policy Decision Engine");
            AuthZRequestBean bean = new AuthZRequestBean();
            bean.getAttributes().add(new Attribute("role", role));
            bean.setAction(action);
            bean.setResource(resource);
            return this.executeQuery(bean);
        }
        this.logger.error("Internal server error");
        return Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)"Service not available").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response getDecision(PolicyRequestBean requestBean) {
        this.logger.debug("Get decision");
        if (this.engine != null) {
            this.logger.debug("Asking Policy Decision Engine");
            return this.executeQuery(this.getRequestBean(requestBean));
        }
        this.logger.error("Internal server error");
        return Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)"Service not available").build();
    }

    private Response executeQuery(AuthZRequestBean authorizationBean) {
        if (this.engine.getDecision(authorizationBean)) {
            this.logger.debug("Authorization grant!");
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)"Authorized").build();
        }
        this.logger.debug("Not authorized");
        return Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).entity((Object)"Not Authorized").build();
    }

    private AuthZRequestBean getRequestBean(PolicyRequestBean policyRequestBean) {
        this.logger.debug("Converting policy request bean...");
        List<String> attributes = policyRequestBean.getAttributes();
        AuthZRequestBean response = new AuthZRequestBean();
        for (String attribute : attributes) {
            try {
                String[] idValue = attribute.split("=");
                this.logger.debug("Id = " + idValue[0] + " value " + idValue[1]);
                response.getAttributes().add(new Attribute(idValue[0], idValue[1]));
            }
            catch (RuntimeException e) {
                this.logger.warn("Invalid attribute");
            }
        }
        response.setAction(policyRequestBean.getAction());
        response.setResource(policyRequestBean.getResource());
        return response;
    }
}

