/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.service.jaxrs;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.util.Base64;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.Attribute;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.ResponseBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.beans.RuleBean;
import it.eng.rdlab.soa3.pm.connector.javaapi.engine.PolicyEngine;
import it.eng.rdlab.soa3.pm.connector.service.beans.RuleJaxBean;
import it.eng.rdlab.soa3.pm.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.pm.connector.service.factory.PolicyEngineFactory;
import it.eng.rdlab.soa3.pm.connector.service.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/policymanager")
public class PolicyManagerService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PolicyEngine engine;

    public PolicyManagerService() {
        Configuration.init();
        this.engine = PolicyEngineFactory.getPolicyEngine();
        this.logger.debug("Policy engine generated");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createRule(RuleJaxBean ruleJaxBean, @Context HttpContext context) {
        this.logger.debug("Calling the policy creation engine...");
        this.logger.debug("Attributes = " + ruleJaxBean.getAttributes());
        ResponseBean response = this.engine.createRule(Utils.fromRuleJaxBean(ruleJaxBean));
        this.logger.debug("Response received " + response);
        switch (response.getStatus()) {
            case -2: {
                return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Rule not created ").build();
            }
            case -1: {
                return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)response.getInfo()).build();
            }
        }
        return Response.status((Response.StatusType)ClientResponse.Status.CREATED).entity((Object)response.getInfo()).build();
    }

    @POST
    @Path(value="/ruleid")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response getRuleId(RuleJaxBean ruleJaxBean, @Context HttpContext context) {
        this.logger.debug("Calling get ruleid method");
        String ruleID = this.engine.getRuleId(Utils.fromRuleJaxBean(ruleJaxBean));
        this.logger.debug("Response " + ruleID);
        if (ruleID != null) {
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)ruleID).build();
        }
        return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"Policy not found").build();
    }

    @GET
    @Path(value="/{ruleId}")
    @Produces(value={"application/json"})
    public Response getRule(@PathParam(value="ruleId") String ruleId, @Context HttpContext context) {
        this.logger.debug("Calling the policy reading engine...");
        this.logger.debug("Rule ID " + ruleId);
        RuleBean ruleBean = this.engine.getRule(ruleId);
        this.logger.debug("Response received");
        if (ruleBean != null) {
            String value = null;
            try {
                value = Utils.getMapper().writeValueAsString((Object)Utils.fromRuleBean(ruleBean));
                this.logger.debug("Policy response " + value);
                return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
            }
            catch (JsonGenerationException e) {
                this.logger.error("get user unsuccessful due to json parse error  ");
                value = "json parser error";
            }
            catch (JsonMappingException e) {
                this.logger.error("get user unsuccessful due to json parse error  ");
                value = "json mapping error";
            }
            catch (IOException e) {
                this.logger.error("get user unsuccessful due to json parse error  ");
                value = "json parser error";
            }
            throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
        }
        this.logger.debug("Policy not found");
        return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"Policy not found").build();
    }

    @PUT
    @Path(value="/{ruleId}")
    @Produces(value={"application/json"})
    public Response updateRule(@PathParam(value="ruleId") String ruleId, RuleJaxBean ruleJaxBean, @Context HttpContext context) {
        this.logger.debug("Calling the policy updating engine...");
        this.logger.debug("Rule ID " + ruleId);
        ResponseBean response = this.engine.updateRule(ruleId, Utils.fromRuleJaxBean(ruleJaxBean));
        this.logger.debug("Response received " + response.getStatus());
        switch (response.getStatus()) {
            case -3: {
                return Response.status((Response.StatusType)ClientResponse.Status.NOT_FOUND).entity((Object)"Policy not updated: the policy is not present ").build();
            }
            case -2: {
                return Response.status((Response.StatusType)ClientResponse.Status.NOT_MODIFIED).entity((Object)"Policy not updated: unable to modify the policy").build();
            }
            case -1: {
                return Response.status((Response.StatusType)ClientResponse.Status.CONFLICT).entity((Object)response.getInfo()).build();
            }
        }
        return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)response.getInfo()).build();
    }

    @DELETE
    @Path(value="/{ruleId}")
    @Produces(value={"text/plain"})
    public Response deleteRule(@PathParam(value="ruleId") String ruleId, @Context HttpContext context) {
        this.logger.debug("Calling the policy deletion engine...");
        boolean response = this.engine.deleteRule(ruleId);
        this.logger.debug("Response received " + response);
        if (response) {
            this.logger.debug("Policy deleted");
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)"Policy has been deleted successfully ").build();
        }
        this.logger.debug("Policy not deleted");
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)"Policy not deleted ").build();
    }

    @GET
    @Path(value="/subject/{subjectid}/{subjectvalue}")
    @Produces(value={"application/json"})
    public Response listRulesBySubjects(@PathParam(value="subjectid") String subjectid, @PathParam(value="subjectvalue") String subjectvalue, @Context HttpContext context) {
        this.logger.debug("Calling the rule retrieving engine...");
        this.logger.debug("Subject id " + subjectid);
        this.logger.debug("Subject value " + subjectvalue);
        ArrayList<Attribute> attributesList = new ArrayList<Attribute>();
        attributesList.add(new Attribute(subjectid, subjectvalue));
        return this.internalListRulesBySubject(attributesList);
    }

    @GET
    @Path(value="/subjects/{subjects}")
    @Produces(value={"application/json"})
    public Response listRulesBySubjects(@PathParam(value="subjects") String subjects, @Context HttpContext context) {
        this.logger.debug("Calling the rule retrieving engine...");
        this.logger.debug("Subject attributes " + subjects);
        List<Attribute> attributesList = this.getAttributes(subjects);
        return this.internalListRulesBySubject(attributesList);
    }

    @GET
    @Path(value="/rules")
    @Produces(value={"application/json"})
    public Response listRules(@Context HttpContext context) {
        this.logger.debug("Calling the rule retrieving engine...");
        List ruleBeans = this.engine.listRules();
        this.logger.debug("Policy beans retrieved");
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString((Object)Utils.fromRuleBeanList(ruleBeans));
            this.logger.debug("Policy response " + value);
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }

    private Response internalListRulesBySubject(List<Attribute> attributesList) {
        List ruleBeans = this.engine.listRulesBySubjects(attributesList);
        this.logger.debug("Policy beans retrieved");
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString((Object)Utils.fromRuleBeanList(ruleBeans));
            this.logger.debug("Policy response " + value);
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }

    private List<Attribute> getAttributes(String subjects) {
        this.logger.debug("Generating subjects map");
        ArrayList<Attribute> response = new ArrayList<Attribute>();
        if (subjects != null) {
            String[] keyValues;
            String decodedSubjects = new String(Base64.decode((String)subjects));
            this.logger.debug("Decoded subjects = " + decodedSubjects);
            for (String keyvalue : keyValues = decodedSubjects.split(":")) {
                this.logger.debug("KeyValue " + keyvalue);
                String[] kv = keyvalue.split("=");
                try {
                    response.add(new Attribute(kv[0].trim(), kv[1].trim()));
                }
                catch (RuntimeException e) {
                    this.logger.error("Unable to add a value in the attribute table", (Throwable)e);
                }
            }
        } else {
            this.logger.debug("No attributes found");
        }
        return response;
    }

    @GET
    @Path(value="/action/{action}")
    @Produces(value={"application/json"})
    public Response listRulesByAction(@PathParam(value="action") String action, @Context HttpContext context) {
        this.logger.debug("Calling the policy retrieving engine...");
        this.logger.debug("Action " + action);
        List ruleBeans = this.engine.listRulesByAction(action);
        this.logger.debug("Policy beans retrieved");
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString((Object)Utils.fromRuleBeanList(ruleBeans));
            this.logger.debug("Policy response " + value);
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }

    @GET
    @Path(value="/resource/{resource}")
    @Produces(value={"application/json"})
    public Response listRulesByResource(@PathParam(value="resource") String respurce, @Context HttpContext context) {
        this.logger.debug("Calling the policy retrieving engine...");
        this.logger.debug("Resource " + respurce);
        List ruleBeans = this.engine.listRulesByResource(respurce);
        this.logger.debug("Policy beans retrieved");
        String value = null;
        try {
            value = Utils.getMapper().writeValueAsString((Object)Utils.fromRuleBeanList(ruleBeans));
            this.logger.debug("Rule response " + value);
            return Response.status((Response.StatusType)ClientResponse.Status.OK).entity((Object)value).build();
        }
        catch (JsonGenerationException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        catch (JsonMappingException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json mapping error";
        }
        catch (IOException e) {
            this.logger.error("get user unsuccessful due to json parse error  ");
            value = "json parser error";
        }
        throw new WebApplicationException(Response.status((Response.StatusType)ClientResponse.Status.INTERNAL_SERVER_ERROR).entity((Object)value).build());
    }

    public static void main(String[] args) throws Exception {
        RuleBean bean = new RuleBean();
        bean.setAction("ciao");
        bean.setResource(".*");
        bean.getAttributes().put("role", "ciao");
        System.out.println(Utils.getMapper().writeValueAsString((Object)bean));
    }
}

