/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.reporting;

import gr.uoa.di.madgik.environment.exception.EnvironmentReportingException;
import gr.uoa.di.madgik.environment.exception.EnvironmentValidationException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.reporting.IReportingFrameworkProvider;
import gr.uoa.di.madgik.environment.reporting.NoReportingFrameworkProvider;
import java.util.Map;

public class ReportingFrameworkProvider
implements IReportingFrameworkProvider {
    private static IReportingFrameworkProvider StaticProvider = null;
    private static final Object lockMe = new Object();
    private IReportingFrameworkProvider Provider = null;
    private EnvHintCollection InitHints = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IReportingFrameworkProvider Init(String ProviderName, EnvHintCollection Hints) throws EnvironmentValidationException {
        try {
            Object object = lockMe;
            synchronized (object) {
                if (StaticProvider == null) {
                    NoReportingFrameworkProvider o;
                    if (ProviderName.equals(ReportingFrameworkProvider.class.getName())) {
                        throw new EnvironmentValidationException("Class " + ReportingFrameworkProvider.class.getName() + " cannot be defined as reporting provider");
                    }
                    if (ProviderName == null || ProviderName.trim().equals("")) {
                        o = new NoReportingFrameworkProvider();
                    } else {
                        Class<?> c = Class.forName(ProviderName);
                        o = c.newInstance();
                    }
                    if (!(o instanceof IReportingFrameworkProvider)) {
                        throw new EnvironmentValidationException("Class" + ProviderName + " is not a reporting provider");
                    }
                    ReportingFrameworkProvider prov = new ReportingFrameworkProvider();
                    prov.Provider = o;
                    prov.InitHints = Hints;
                    prov.SessionInit(Hints);
                    StaticProvider = prov;
                }
            }
            return StaticProvider;
        }
        catch (Exception ex) {
            throw new EnvironmentValidationException("Could not initialize Reporting Provider", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean IsInit() {
        Object object = lockMe;
        synchronized (object) {
            return StaticProvider != null;
        }
    }

    @Override
    public void SessionInit(EnvHintCollection Hints) throws EnvironmentReportingException {
        if (this.Provider == null) {
            throw new EnvironmentReportingException("Reporting Provider not initialized");
        }
        this.Provider.SessionInit(this.MergeHints(Hints));
    }

    @Override
    public void Send(String messageType, Map<String, Object> messageParameters, EnvHintCollection hints) throws EnvironmentReportingException {
        if (this.Provider == null) {
            throw new EnvironmentReportingException("Reporting Provider not initialized");
        }
        this.Provider.Send(messageType, messageParameters, this.MergeHints(hints));
    }

    private EnvHintCollection MergeHints(EnvHintCollection Hints) {
        if (this.InitHints == null && Hints == null) {
            return new EnvHintCollection();
        }
        if (this.InitHints == null) {
            return Hints;
        }
        if (Hints == null) {
            return this.InitHints;
        }
        return this.InitHints.Merge(Hints);
    }
}

