/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StringFieldDefinition
extends FieldDefinition
implements Serializable {
    public static final String DefaultMimeType = "text/plain";
    public static final IBuffer.TransportDirective DefaultDirective = IBuffer.TransportDirective.Full;
    public static final String DefaultCharset = "UTF-8";
    private String charset = "UTF-8";

    public StringFieldDefinition() {
        this.setMimeType(DefaultMimeType);
        this.setTransportDirective(DefaultDirective);
    }

    public StringFieldDefinition(String name) {
        this.setMimeType(DefaultMimeType);
        this.setTransportDirective(DefaultDirective);
        this.setName(name);
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setTransportDirective(IBuffer.TransportDirective directive) {
    }

    @Override
    public IBuffer.TransportDirective getTransportDirective() {
        return DefaultDirective;
    }

    @Override
    public boolean extendEquals(Object obj) {
        if (!(obj instanceof StringFieldDefinition)) {
            return false;
        }
        return this.charset.equals(((StringFieldDefinition)obj).charset);
    }

    @Override
    public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException {
        try {
            out.writeUTF(this.charset);
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete marshalling of definition", ex);
        }
    }

    @Override
    public void extendInflate(DataInput in) throws GRS2RecordSerializationException {
        try {
            this.charset = in.readUTF();
        }
        catch (Exception ex) {
            throw new GRS2RecordSerializationException("Could not complete unmarshalling of definition", ex);
        }
    }

    @Override
    public void extendToXML(Document doc, Element element) throws GRS2RecordSerializationException {
        Element el = doc.createElement("charset");
        el.setTextContent(this.charset);
        element.appendChild(el);
    }

    @Override
    public void extendFromXML(Element element) throws GRS2RecordSerializationException {
        this.charset = element.getElementsByTagName("charset").item(0).getTextContent();
    }
}

