/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.IReaderProxy;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.tcp.mirror.TCPReaderMirror;
import java.net.URI;

public class TCPReaderProxy
implements IReaderProxy {
    private String key = null;
    private URI locator = null;
    private String hostname = null;
    private int port = -1;
    private IMirror mirror = null;
    private boolean overrideBufferCapacity = false;
    private int bufferCapacity = -1;

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void fromLocator(URI locator) throws GRS2ProxyInvalidOperationException, GRS2ProxyInvalidArgumentException {
        if (this.locator != null) {
            throw new GRS2ProxyInvalidOperationException("Proxy already initialized with locator");
        }
        if (locator == null) {
            throw new GRS2ProxyInvalidArgumentException("Locator cannot be null");
        }
        if (!TCPReaderProxy.isOfType(locator)) {
            throw new GRS2ProxyInvalidArgumentException("Locator is not of appropriate type " + locator.toString());
        }
        if (locator.getQuery() == null) {
            throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
        }
        String[] qs = locator.getQuery().trim().split("=");
        if (qs.length != 2) {
            throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
        }
        if (qs[1].trim().length() == 0) {
            throw new GRS2ProxyInvalidArgumentException("Invalid key in locator " + locator.toString());
        }
        this.hostname = locator.getHost();
        this.port = locator.getPort();
        this.key = qs[1];
        this.locator = locator;
    }

    @Override
    public void overrideBufferCapacity(int capacity) throws GRS2ProxyInvalidOperationException {
        if (this.mirror != null) {
            throw new GRS2ProxyInvalidOperationException("Cannot override buffer capacity after buffer initialization");
        }
        this.overrideBufferCapacity = true;
        this.bufferCapacity = capacity;
    }

    @Override
    public IBuffer getBuffer() throws GRS2ProxyInvalidOperationException {
        if (this.key == null || this.key.trim().length() == 0 || this.locator == null) {
            throw new GRS2ProxyInvalidOperationException("Proxy not correctly initialized");
        }
        if (this.mirror == null) {
            try {
                TCPReaderMirror mr = new TCPReaderMirror();
                mr.setKey(this.key);
                mr.setPort(this.port);
                mr.setHostname(this.hostname);
                if (this.overrideBufferCapacity) {
                    mr.overrideBufferCapacity(this.bufferCapacity);
                }
                mr.handle();
                if (!mr.waitInitialization()) {
                    throw mr.getInitializationError();
                }
                IBuffer buf = mr.getBuffer();
                this.mirror = mr;
                buf.setMirror(this.mirror);
            }
            catch (GRS2ProxyMirrorException ex) {
                throw new GRS2ProxyInvalidOperationException("Could not initialize mirror process", ex);
            }
        }
        return this.mirror.getBuffer();
    }

    public static boolean isOfType(URI locator) {
        if (!locator.getScheme().equalsIgnoreCase("grs2-proxy".toString())) {
            return false;
        }
        return locator.getFragment().equalsIgnoreCase(IProxy.ProxyType.TCP.toString());
    }
}

