/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.postprocessing.remove;

import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.QueryParameter;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.contexts.ServiceContext;
import org.gcube.informationsystem.registry.impl.porttypes.LocalResourceRegistration;
import org.gcube.informationsystem.registry.impl.porttypes.RegistryFactory;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.Purger;
import org.gcube.informationsystem.registry.stubs.RemoveResourceMessage;

public class GHNPurger
implements Purger<GCUBEHostingNode> {
    protected static final GCUBELog logger = new GCUBELog(GHNPurger.class);

    public void unregisterHostedRIs(RegistryFactory service, String ghnid) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        RemoveResourceMessage message = null;
        GCUBEGenericQuery query = client.getQuery("RIOnGHN");
        query.addParameters(new QueryParameter[]{new QueryParameter("ID", ghnid)});
        List resources = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
        if (resources.size() != 0) {
            for (XMLResult resource : resources) {
                try {
                    message = new RemoveResourceMessage();
                    message.setType("RunningInstance");
                    message.setUniqueID((String)resource.evaluate("/Resource/ID/text()").get(0));
                    service.removeResource(message);
                }
                catch (RemoteException rme) {}
            }
        }
    }

    @Override
    public Set<String> purge(String ghnid, GCUBEScope scope) throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericQuery query = client.getQuery("RIOnGHN");
        query.addParameters(new QueryParameter[]{new QueryParameter("ID", ghnid)});
        List resources = client.execute((ISQuery)query, scope);
        HashSet<String> removed = new HashSet<String>();
        if (resources.size() != 0) {
            for (XMLResult ri : resources) {
                try {
                    String id = (String)ri.evaluate("/Resource/ID/text()").get(0);
                    logger.debug((Object)("Removing Running Instance " + id));
                    new LocalResourceRegistration().remove(id, "RunningInstance");
                    logger.debug((Object)("Resource " + id + " successfully removed"));
                    removed.add(id);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to remove a hosted RI from ghn " + ghnid), (Throwable)e);
                }
            }
        }
        return removed;
    }

    @Override
    public String getName() {
        return "GHN";
    }
}

