/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.registry.impl.porttypes;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.publisher.ISResourcePublisher;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.registry.impl.contexts.ServiceContext;
import org.gcube.informationsystem.registry.impl.local.LocalNotifier;
import org.gcube.informationsystem.registry.impl.porttypes.RegistryFactory;
import org.gcube.informationsystem.registry.impl.porttypes.ResourceRegistration;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.AvailablePurgers;
import org.gcube.informationsystem.registry.impl.postprocessing.remove.Purger;
import org.gcube.informationsystem.registry.impl.postprocessing.update.AvailableUpdaters;
import org.gcube.informationsystem.registry.impl.postprocessing.update.Updater;
import org.gcube.informationsystem.registry.impl.state.Definitions;

public class LocalResourceRegistration {
    protected final GCUBELog logger = new GCUBELog(ResourceRegistration.class);

    public void create(GCUBEResource resource) throws Exception {
        ISResourcePublisher publisher = (ISResourcePublisher)GHNContext.getImplementation(ISResourcePublisher.class);
        publisher.register(resource, ServiceContext.getContext().getScope(), (GCUBESecurityManager)ServiceContext.getContext());
        this.logger.debug((Object)("Resource " + resource.getID() + " successfully created"));
        this.logger.trace((Object)("Looking for updater for " + resource.getType()));
        Updater<?> updater = AvailableUpdaters.getPurger(resource.getType());
        if (updater != null) {
            try {
                this.logger.debug((Object)("Applying updater for " + resource.getType()));
                updater.update((GCUBEResource)resource.getClass().cast(resource), ServiceContext.getContext().getScope());
            }
            catch (Exception e) {
                this.logger.error((Object)"Error while updating the profiles related to the resource", (Throwable)e);
            }
        } else {
            this.logger.trace((Object)"No updater found");
        }
        LocalNotifier.notifyEvent(resource, ServiceContext.RegistryTopic.CREATE);
        StringWriter writer = new StringWriter();
        resource.store((Writer)writer);
        RegistryFactory.updateCounterInfo(resource.getID(), Definitions.ResourceMappings.valueOf(resource.getType()), Definitions.OperationType.create, Calendar.getInstance(), writer.toString(), ServiceContext.getContext().getScope());
    }

    public void remove(String id, String type) throws Exception {
        ISResourcePublisher publisher = (ISResourcePublisher)GHNContext.getImplementation(ISResourcePublisher.class);
        publisher.remove(id, type, ServiceContext.getContext().getScope(), (GCUBESecurityManager)ServiceContext.getContext());
        this.logger.debug((Object)("Resource " + id + " successfully removed"));
        this.logger.trace((Object)("Looking for purger for " + type));
        Purger<?> purger = AvailablePurgers.getPurger(type);
        if (purger != null) {
            try {
                this.logger.debug((Object)("Applying purger for " + type));
                purger.purge(id, ServiceContext.getContext().getScope());
            }
            catch (Exception e) {
                this.logger.error((Object)"Error while removing the profiles related to the resource", (Throwable)e);
            }
        } else {
            this.logger.trace((Object)"No purger found");
        }
        GCUBEResource resource = Definitions.ResourceMappings.valueOf(type).getResourceImplementation();
        resource.setID(id);
        LocalNotifier.notifyEvent(resource, ServiceContext.RegistryTopic.REMOVE);
        RegistryFactory.updateCounterInfo(id, Definitions.ResourceMappings.valueOf(type), Definitions.OperationType.destroy, Calendar.getInstance(), null, ServiceContext.getContext().getScope());
    }

    public void update(GCUBEResource resource) throws Exception {
        ISResourcePublisher publisher = (ISResourcePublisher)GHNContext.getImplementation(ISResourcePublisher.class);
        publisher.register(resource, ServiceContext.getContext().getScope(), (GCUBESecurityManager)ServiceContext.getContext());
        this.logger.debug((Object)("Resource " + resource.getID() + " successfully updated"));
        this.logger.trace((Object)("Looking for updater for " + resource.getType()));
        Updater<?> updater = AvailableUpdaters.getPurger(resource.getType());
        if (updater != null) {
            try {
                this.logger.debug((Object)("Applying updater for " + resource.getType()));
                updater.update((GCUBEResource)resource.getClass().cast(resource), ServiceContext.getContext().getScope());
            }
            catch (Exception e) {
                this.logger.error((Object)"Error while updating the profiles related to the resource", (Throwable)e);
            }
        } else {
            this.logger.trace((Object)"No updater found");
        }
        LocalNotifier.notifyEvent(resource, ServiceContext.RegistryTopic.UPDATE);
        StringWriter writer = new StringWriter();
        resource.store((Writer)writer);
        RegistryFactory.updateCounterInfo(resource.getID(), Definitions.ResourceMappings.valueOf(resource.getType()), Definitions.OperationType.update, Calendar.getInstance(), writer.toString(), ServiceContext.getContext().getScope());
    }
}

