/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache.consistency.manager.poll;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReference;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.cache.Srv;
import org.gcube.informationsystem.cache.SrvRegistry;
import org.gcube.informationsystem.cache.consistency.manager.poll.CacheRefreshUtil;

public class CacheRefresher
extends Thread {
    private boolean isRefreshing;
    private long ttr;
    private long refreshCycleTime;
    private Date lastRefreshDate;
    private static GCUBELog log = new GCUBELog(CacheRefresher.class);
    private SrvRegistry registry = null;

    public CacheRefresher(long ttr, SrvRegistry registry) throws Exception {
        try {
            this.setTtr(ttr);
            this.setRefreshCycleTime(0L);
            this.setRegistry(registry);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @Override
    public void run() {
        while (true) {
            log.info((Object)"Initiate Cache Refresh.");
            long start = System.currentTimeMillis();
            Set<Srv> srvSet = this.getRegistry().getSrvs();
            Iterator<Srv> srvIt = srvSet.iterator();
            log.info((Object)("Refreshing " + srvSet.size() + " services"));
            while (srvIt.hasNext()) {
                Srv srv = srvIt.next();
                try {
                    CacheRefreshUtil.refreshService(srv);
                    if (!log.isDebugEnabled()) continue;
                    EndpointReference[] EPRs = this.getRegistry().getEPRsFor(srv);
                    for (int i = 0; i < EPRs.length; ++i) {
                        log.debug((Object)EPRs[i].toString());
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error in retrieving the EPRs of service {" + srv.toString() + "}"));
                    log.error((Object)e);
                }
            }
            long end = System.currentTimeMillis();
            this.setRefreshCycleTime(end - start);
            this.setLastRefreshDate(Calendar.getInstance().getTime());
            try {
                log.info((Object)("Hibernate for " + this.getTtr() + " millis"));
                Thread.sleep(this.getTtr());
                log.info((Object)"Woken Up! This means that I should initiate the refresh procedure.");
                continue;
            }
            catch (InterruptedException e) {
                log.warn((Object)"Got an interrupt. This means that I should initiate the refresh procedure.");
                continue;
            }
            break;
        }
    }

    protected void setRefreshing(boolean isRefreshing) {
        this.isRefreshing = isRefreshing;
    }

    protected boolean isRefreshing() {
        return this.isRefreshing;
    }

    protected void setTtr(long ttr) {
        this.ttr = ttr;
    }

    protected long getTtr() {
        return this.ttr;
    }

    private void setRefreshCycleTime(long refreshCycleTime) {
        this.refreshCycleTime = refreshCycleTime;
    }

    protected long getRefreshCycleTime() {
        return this.refreshCycleTime;
    }

    private void setLastRefreshDate(Date lastRefreshDate) {
        this.lastRefreshDate = lastRefreshDate;
    }

    protected Date getLastRefreshDate() {
        return this.lastRefreshDate;
    }

    private void setRegistry(SrvRegistry registry) {
        this.registry = registry;
    }

    private SrvRegistry getRegistry() {
        return this.registry;
    }
}

