/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.cache.consistency.manager.poll;

import java.util.Date;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReference;
import org.gcube.informationsystem.cache.Srv;
import org.gcube.informationsystem.cache.SrvRegistry;
import org.gcube.informationsystem.cache.consistency.manager.poll.CacheRefreshUtil;
import org.gcube.informationsystem.cache.consistency.manager.poll.CacheRefresher;
import org.gcube.informationsystem.cache.consistency.manager.poll.PollManagerMBean;

public class PollManager
implements PollManagerMBean {
    CacheRefresher cr = null;
    long ttr = 600000L;

    @Override
    public Date getLastRefreshTimestamp() {
        return this.cr.getLastRefreshDate();
    }

    @Override
    public long getRefreshTimeInMillis() {
        return this.cr.getTtr();
    }

    @Override
    public void refresh() {
        this.cr.interrupt();
    }

    @Override
    public long refreshCycleTime() {
        return this.cr.getRefreshCycleTime();
    }

    @Override
    public void setRefreshTimeInMillis(long refreshTimeInMillis) {
        this.cr.setTtr(refreshTimeInMillis);
    }

    @Override
    public boolean isRefreshing() {
        return this.cr.isRefreshing();
    }

    @Override
    public void initialize(SrvRegistry registry) throws Exception {
        this.cr = new CacheRefresher(this.ttr, registry);
        this.cr.start();
    }

    @Override
    public Set<EndpointReference> getEPRs(Srv service) throws Exception {
        return CacheRefreshUtil.getEPRs(service);
    }

    @Override
    public Set<EndpointReference> getEPRs(Srv service, String serviceType) throws Exception {
        return CacheRefreshUtil.getEPRs(service, serviceType);
    }

    protected static void refreshService(Srv service) throws Exception {
        CacheRefreshUtil.refreshService(service);
    }
}

