/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.notifier.thread;

import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.notifier.impl.NotifierContext;
import org.gcube.informationsystem.notifier.impl.NotifierResource;
import org.gcube.informationsystem.notifier.impl.ServiceContext;
import org.gcube.informationsystem.notifier.impl.entities.Producer;
import org.gcube.informationsystem.notifier.util.RegistrationEventHandlerImpl;
import org.gcube.informationsystem.notifier.util.TopicMapping;
import org.globus.wsrf.ResourceKey;

public class RegisterTopicThread
extends Thread {
    protected final GCUBELog logger = new GCUBELog((Object)this);
    private EndpointReferenceType notifierEpr;
    private String[] topicVector;

    public RegisterTopicThread(String[] topicVector, EndpointReferenceType notifierEpr) {
        this.notifierEpr = notifierEpr;
        this.topicVector = topicVector;
    }

    @Override
    public void run() {
        GCUBEWSResource resource = null;
        try {
            resource = NotifierContext.getPortTypeContext().getWSHome().find((ResourceKey)NotifierContext.getContext().makeKey("NotifierResource_" + ServiceContext.getContext().getScope().toString().replace("/", "_")));
        }
        catch (Exception e) {
            this.logger.error((Object)" Unable to access resource", (Throwable)e);
            return;
        }
        Producer producer = new Producer(this.notifierEpr);
        NotifierResource notifierResource = (NotifierResource)resource;
        for (String topicString : this.topicVector) {
            try {
                TopicMapping<Object, Object, Object> topicMapping;
                QName topic = QName.valueOf(topicString);
                this.logger.debug((Object)("the topic to register is " + topic));
                if (notifierResource.isTopicPresent(topic)) {
                    this.logger.debug((Object)("the topic " + topicString + " already exists"));
                    topicMapping = notifierResource.getTopicMappingByQName(topic);
                    topicMapping.addProducer(producer);
                } else {
                    this.logger.debug((Object)("creating new topicMapping " + topicString));
                    topicMapping = new TopicMapping(topic);
                    topicMapping.setRegistrationEventHandler(new RegistrationEventHandlerImpl(topic));
                    topicMapping.addProducer(producer);
                    notifierResource.addTopicMapping(topicMapping);
                }
                this.logger.trace((Object)"adding the producer to the topic mapping");
                this.logger.info((Object)("topic " + topicString + " registered "));
            }
            catch (Exception e) {
                this.logger.error((Object)"error registering topic", (Throwable)e);
            }
        }
        producer.setSubscriptionFinished();
        notifierResource.store();
    }
}

