/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.oauth;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.oauth.cache.CacheBean;
import org.gcube.portal.oauth.cache.CacheCleaner;
import org.gcube.portal.oauth.input.PushCodeBean;
import org.gcube.portal.oauth.output.AccessTokenBeanResponse;
import org.gcube.portal.oauth.output.AccessTokenErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v2")
@Singleton
public class OauthService {
    public static final String OAUTH_TOKEN_GET_METHOD_NAME_REQUEST = "access-token";
    private static final String GRANT_TYPE_VALUE = "authorization_code";
    private static final Logger logger = LoggerFactory.getLogger(OauthService.class);
    private Map<String, CacheBean> entries;
    CacheCleaner cleaner;

    public OauthService() {
        logger.info("Singleton gcube-oauth service built.");
        this.entries = new ConcurrentHashMap();
        this.cleaner = new CacheCleaner(this.entries);
        this.cleaner.start();
    }

    protected void finalize() {
        if (this.cleaner != null) {
            this.cleaner.interrupt();
        }
    }

    private boolean checkIsQualifierTokenType(ClientType clientType) {
        return clientType.equals((Object)ClientType.USER);
    }

    private boolean checkIsapplicationTokenType(ClientType clientType) {
        return clientType.equals((Object)ClientType.EXTERNALSERVICE);
    }

    @GET
    @Path(value="check")
    @Produces(value={"text/plain"})
    public Response checkService() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Ready!").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="push-authentication-code")
    public Response pushAuthCode(PushCodeBean bean) {
        logger.info("Request to push ");
        Caller caller = AuthorizationProvider.instance.get();
        String token = SecurityTokenProvider.instance.get();
        Response.Status status = Response.Status.CREATED;
        if (!this.checkIsQualifierTokenType(caller.getClient().getType())) {
            status = Response.Status.FORBIDDEN;
            logger.warn("Trying to access users method via a token different than USER is not allowed");
            return Response.status((Response.Status)status).entity((Object)"{\"error\"=\"Trying to access push-authentication-code method via a token different than USER is not allowed\"").build();
        }
        String code = bean.getCode();
        String clientId = bean.getClientId();
        String redirectUri = bean.getRedirectUri();
        if (code == null || code.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\"=\"'code' cannot be null or missing\"").build();
        }
        if (clientId == null || clientId.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\"=\"'client_id' cannot be null or missing\"").build();
        }
        if (redirectUri == null || redirectUri.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{\"error\"=\"'redirect_uri' cannot be null or missing\"").build();
        }
        logger.info("Saving entry defined by " + bean + " in cache, token is " + token.substring(0, 10) + "***************");
        this.entries.put(code, new CacheBean(token, ScopeProvider.instance.get(), redirectUri, clientId, Long.valueOf(System.currentTimeMillis())));
        return Response.status((Response.Status)status).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Path(value="access-token")
    public Response tokenRequest(@FormParam(value="client_id") String clientId, @FormParam(value="client_secret") String clientSecret, @FormParam(value="redirect_uri") String redirectUri, @FormParam(value="code") String code, @FormParam(value="grant_type") String grantType) {
        Response.Status status = Response.Status.BAD_REQUEST;
        logger.info("Request to exchange code for token");
        logger.info("Params are client_id = " + clientId + ", client_secret = " + clientSecret + "*******************, redirect_uri = " + redirectUri + ", code = " + code + "*******************, grant_type = " + grantType);
        try {
            String errorMessage = this.checkRequest(clientId, clientSecret, redirectUri, code, grantType);
            if (errorMessage != null) {
                logger.error("The request fails because of " + errorMessage);
                return Response.status((Response.Status)status).entity((Object)new AccessTokenErrorResponse(errorMessage, null)).build();
            }
            logger.info("The request is ok");
            String tokenToReturn = ((CacheBean)this.entries.get(code)).getToken();
            String scope = ((CacheBean)this.entries.get(code)).getScope();
            status = Response.Status.OK;
            return Response.status((Response.Status)status).entity((Object)new AccessTokenBeanResponse(tokenToReturn, scope)).build();
        }
        catch (Exception e) {
            logger.error("Failed to perform this operation", (Throwable)e);
            status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)new AccessTokenErrorResponse("invalid_request", null)).build();
        }
    }

    private String checkRequest(String clientId, String clientSecret, String redirectUri, String code, String grantType) {
        try {
            if (clientId == null || clientSecret == null || redirectUri == null || code == null || grantType == null) {
                return "invalid_request";
            }
            if (clientId.isEmpty() || clientSecret.isEmpty() || redirectUri.isEmpty() || code.isEmpty() || grantType.isEmpty()) {
                return "invalid_request";
            }
            if (!this.checkIsapplicationTokenType(Constants.authorizationService().get(clientSecret).getClientInfo().getType())) {
                return "invalid_client";
            }
            if (!this.entries.containsKey(code) || CacheBean.isExpired((CacheBean)((CacheBean)this.entries.get(code)))) {
                return "invalid_grant";
            }
            CacheBean entry = (CacheBean)this.entries.get(code);
            if (!entry.getRedirectUri().equals(redirectUri) || !entry.getClientId().equals(clientId)) {
                return "invalid_grant";
            }
            if (!grantType.equals(GRANT_TYPE_VALUE)) {
                return "unsupported_grant_type";
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to check the correctness of the request", (Throwable)e);
            return "invalid_request";
        }
    }
}

