/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins.thread;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CheckShareLatexUserThread
implements Runnable {
    private static Log _log = LogFactoryUtil.getLog(CheckShareLatexUserThread.class);
    private static final String SERVICE_NAME = "ShareLatex";
    private static final String SERVICE_CLASS = "DataAccess";
    private static final String ENTRY_NAME = "org.gcube.data.access.sharelatex.connector.Connector";
    private static final String USER_AGENT = "Mozilla/5.0";
    private String username;
    private String scope;

    public CheckShareLatexUserThread(String username, String scope) {
        this.username = username;
        this.scope = scope;
    }

    @Override
    public void run() {
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(this.scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceName/text() eq 'ShareLatex'");
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'DataAccess'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List conf = client.submit((Query)query);
        if (conf == null || conf.isEmpty()) {
            _log.info((Object)("Not creating user in ShareLatex as no gcore endpoint named <b>ShareLatex</b> is present in the scope <b>" + this.scope + "</b>"));
            ScopeProvider.instance.set(currScope);
        } else {
            _log.debug((Object)("Getting token for " + this.username + " in " + this.scope));
            String token = "";
            try {
                ArrayList<String> userRoles = new ArrayList<String>();
                String DEFAULT_ROLE = "OrganizationMember";
                userRoles.add(DEFAULT_ROLE);
                token = Constants.authorizationService().generateUserToken(new UserInfo(this.username, userRoles), this.scope);
            }
            catch (Exception e) {
                e.printStackTrace();
                ScopeProvider.instance.set(currScope);
            }
            ScopeProvider.instance.set(currScope);
            GCoreEndpoint re2s = (GCoreEndpoint)conf.get(0);
            Iterator it = re2s.profile().endpoints().iterator();
            String uriService = "";
            while (it.hasNext()) {
                GCoreEndpoint.Profile.Endpoint ep = (GCoreEndpoint.Profile.Endpoint)it.next();
                if (ep.name().compareTo("org.gcube.data.access.sharelatex.connector.Connector") != 0) continue;
                uriService = ep.uri().toString();
                _log.debug((Object)(" ** Found uriService for org.gcube.data.access.sharelatex.connector.Connector=" + uriService));
                break;
            }
            this.createUserInShareLatex(uriService, token);
        }
    }

    private void createUserInShareLatex(String uriService, String token) {
        String connectURL = uriService + "/connect?gcube-token=" + token;
        String disconnectURL = uriService + "/disconnect?gcube-token=" + token;
        try {
            CheckShareLatexUserThread.sendGet((String)connectURL);
            Thread.sleep(1000L);
            CheckShareLatexUserThread.sendGet((String)disconnectURL);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void sendGet(String url) throws Exception {
        String inputLine;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestProperty("User-Agent", "Mozilla/5.0");
        int responseCode = con.getResponseCode();
        _log.debug((Object)("\nSending 'GET' request to URL : " + url));
        _log.debug((Object)("Response Code : " + responseCode));
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        _log.debug((Object)response.toString());
    }
}

