/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.plugins.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.security.Key;
import java.util.List;
import java.util.Random;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portal.plugins.bean.LDAPInfo;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;

/*
 * Exception performing whole class analysis ignored.
 */
public class LDAPUtil {
    private static Log _log = LogFactoryUtil.getLog(LDAPUtil.class);
    public static final String LDAP_SERVER_NAME = "LDAPServer";
    public static final String LDAP_SERVER_FILTER_NAME = "filter";
    public static final String LDAP_SERVER_PRINCPAL_NAME = "ldapPrincipal";
    public static final String LDAP_ORG_FILTER = "(objectClass=organizationalUnit)";
    public static final String LDAP_GROUP_FILTER = "(objectClass=posixGroup)";
    public static final String USER_CONTEXT = ",ou=People,o=D4Science,ou=Organizations,dc=d4science,dc=org";
    public static final String DEFAULT_GID_NUMBER = "1000";

    public static boolean checkIfLDAPGroupExists(DirContext ctx, String groupSubctx) {
        NamingEnumeration<SearchResult> answer;
        SearchControls ctls = new SearchControls();
        ctls.setSearchScope(2);
        try {
            answer = ctx.search(groupSubctx, "(objectClass=posixGroup)", ctls);
        }
        catch (NamingException e) {
            _log.debug((Object)("not found in LDAP (will add it): Group: " + groupSubctx));
            return false;
        }
        boolean toReturn = answer.hasMoreElements();
        _log.debug((Object)("Group: " + groupSubctx + " exists? " + toReturn));
        return toReturn;
    }

    public static void createGroupVRE(DirContext ctx, String subContext, String vreName) throws NamingException {
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("posixGroup");
        attributes.put(objectClass);
        BasicAttribute cn = new BasicAttribute("cn");
        cn.add(vreName);
        attributes.put(cn);
        BasicAttribute gidNumber = new BasicAttribute("gidNumber");
        gidNumber.add(String.valueOf(LDAPUtil.getRandomPOSIXidentifier()));
        attributes.put(gidNumber);
        ctx.createSubcontext(subContext, (Attributes)attributes);
        _log.info((Object)("createGroupVRE Added " + subContext));
    }

    public static LDAPInfo getLDAPCoordinates() {
        LDAPInfo toReturn = new LDAPInfo();
        String portalName = PortalContext.getPortalInstanceName();
        PortalContext context = PortalContext.getConfiguration();
        String scope = "/" + context.getInfrastructureName();
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Portal'");
        query.addCondition("$resource/Profile/Name/text() eq '" + portalName + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List list = client.submit((Query)query);
        if (list == null || list.isEmpty()) {
            _log.error((Object)("Could not find any Service endpoint registred in the infrastructure for this portal: " + portalName));
        } else if (list.size() > 1) {
            _log.warn((Object)("Found more than one Service endpoint registred in the infrastructure for this portal: " + portalName));
        } else {
            for (ServiceEndpoint res : list) {
                Group apGroup = res.profile().accessPoints();
                ServiceEndpoint.AccessPoint[] accessPoints = (ServiceEndpoint.AccessPoint[])apGroup.toArray((Object[])new ServiceEndpoint.AccessPoint[apGroup.size()]);
                for (int i = 0; i < accessPoints.length; ++i) {
                    if (accessPoints[i].name().compareTo("LDAPServer") != 0) continue;
                    _log.debug((Object)"Found credentials for LDAPServer");
                    ServiceEndpoint.AccessPoint found = accessPoints[i];
                    String ldapUrl = found.address();
                    toReturn.setLdapUrl(ldapUrl);
                    String encrPassword = found.password();
                    try {
                        String ldapPassword = StringEncrypter.getEncrypter().decrypt(encrPassword, new Key[0]);
                        toReturn.setLdapPassword(ldapPassword);
                    }
                    catch (Exception e) {
                        _log.error((Object)"Something went wrong while decrypting password for LDAPServer");
                        e.printStackTrace();
                    }
                    Group propGroup = found.properties();
                    ServiceEndpoint.Property[] props = (ServiceEndpoint.Property[])propGroup.toArray((Object[])new ServiceEndpoint.Property[propGroup.size()]);
                    for (int j = 0; j < props.length; ++j) {
                        String encrValue;
                        if (props[j].name().compareTo("filter") == 0) {
                            _log.debug((Object)"\tFound properties of filter");
                            encrValue = props[j].value();
                            System.out.println("Filter encrypted = " + encrValue);
                            try {
                                String filter = StringEncrypter.getEncrypter().decrypt(encrValue, new Key[0]);
                                toReturn.setFilter(filter);
                            }
                            catch (Exception e) {
                                _log.error((Object)"Something went wrong while decrypting value for filter");
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (props[j].name().compareTo("ldapPrincipal") != 0) continue;
                        _log.debug((Object)"\tFound properties of ldapPrincipal");
                        encrValue = props[j].value();
                        try {
                            String principal = StringEncrypter.getEncrypter().decrypt(encrValue, new Key[0]);
                            toReturn.setPrincipal(principal);
                            continue;
                        }
                        catch (Exception e) {
                            _log.error((Object)"Something went wrong while decrypting value for ldapPrincipal");
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        return toReturn;
    }

    public static GCubeGroup getRootVO() {
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            String rootVoName = gm.getRootVOName();
            _log.debug((Object)("Root organization name found: " + rootVoName));
            return gm.getGroup(gm.getGroupIdFromInfrastructureScope("/" + rootVoName));
        }
        catch (Exception e) {
            _log.error((Object)"There were problems retrieving root VO group", (Throwable)e);
            _log.error((Object)"Could not find any root organization");
            return null;
        }
    }

    public static String getOrgSubContext(String orgName) {
        return "ou=" + orgName + ",dc=d4science,dc=org";
    }

    public static int getRandomPOSIXidentifier() {
        int Low = 1000;
        int High = Integer.MAX_VALUE;
        Random r = new Random();
        int toReturn = r.nextInt(2147482647) + 1000;
        return toReturn;
    }
}

