/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portal.threadlocalexec;

import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.UmaJWTProvider;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.oidc.rest.JWTToken;
import org.gcube.oidc.rest.OpenIdConnectRESTHelper;
import org.gcube.oidc.rest.OpenIdConnectRESTHelperException;
import org.gcube.portal.oidc.lr62.JWTCacheProxy;
import org.gcube.portal.oidc.lr62.LiferayOpenIdConnectConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartGearsPortalValve
extends ValveBase {
    private static final Logger _log = LoggerFactory.getLogger(SmartGearsPortalValve.class);
    private static final String DEFAULT_ROLE = "OrganizationMember";
    private static final String LIFERAY_POLLER_CONTEXT = "poller/receive";
    private static boolean REFRESH_UMA_TOKEN = false;
    private static String LOGOUT_URI = "/c/portal/logout";
    private static boolean FORCE_LOGOUT_ON_INVALID_OIDC = true;
    private static boolean FORCE_LOGOUT_ON_MISSING_OIDC = true;
    private static boolean FORCE_LOGOUT_ON_OIDC_REFRESH_ERROR = true;
    private static final int MAX_AUTHORIZATION_RETRY_ATTEMPTS = 4;
    private static final int AUTHORIZATION_RETRY_ATTEMPTS_DELAY = 4000;

    public void invoke(Request req, Response resp) throws IOException, ServletException {
        SecurityTokenProvider.instance.reset();
        ScopeProvider.instance.reset();
        AuthorizationProvider.instance.reset();
        UmaJWTProvider.instance.reset();
        if (req instanceof HttpServletRequest) {
            Request request = req;
            if (!req.getRequestURL().toString().endsWith(LIFERAY_POLLER_CONTEXT)) {
                PortalContext context = PortalContext.getConfiguration();
                String scope = context.getCurrentScope((HttpServletRequest)request);
                String username = SmartGearsPortalValve.getCurrentUsername((HttpServletRequest)request);
                if (scope != null && username != null && SmartGearsPortalValve.validateContext(scope)) {
                    String userToken = null;
                    try {
                        ScopeProvider.instance.set(scope);
                        userToken = Constants.authorizationService().resolveTokenByUserAndContext(username, scope);
                        SecurityTokenProvider.instance.set(userToken);
                    }
                    catch (ObjectNotFound ex) {
                        userToken = SmartGearsPortalValve.generateAuthorizationToken(username, scope);
                        SecurityTokenProvider.instance.set(userToken);
                        _log.debug("generateAuthorizationToken OK for " + username + " in scope " + scope);
                    }
                    catch (Exception e) {
                        _log.error("Something went wrong in generating token for " + username + " in scope " + scope);
                        e.printStackTrace();
                    }
                    this.checkUMATicket((HttpServletRequest)request, (HttpServletResponse)resp, scope);
                }
            }
        }
        this.getNext().invoke(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUMATicket(HttpServletRequest request, HttpServletResponse response, String scope) {
        _log.debug("Getting current user");
        User user = SmartGearsPortalValve.getCurrentUser(request);
        if (user == null) {
            _log.error("Current user not found, cannot continue");
            return;
        }
        _log.debug("Current user is: {} [{}]", (Object)user.getScreenName(), (Object)user.getEmailAddress());
        HttpSession session = request.getSession(false);
        if (session == null) {
            _log.debug("Session is null, cannot continue");
            return;
        }
        String sessionId = session.getId();
        _log.debug("Current session ID is {}", (Object)sessionId);
        String urlEncodedScope = null;
        try {
            urlEncodedScope = URLEncoder.encode(scope, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            _log.error("Cannot URL encode scope", (Throwable)e);
            return;
        }
        _log.debug("URL encoded scope is: {}", (Object)urlEncodedScope);
        JWTToken umaToken = null;
        Map map = JWTCacheProxy.getInstance().getMutexFor(user);
        synchronized (map) {
            _log.trace("Getting UMA token for user {}, and session {}", (Object)user.getScreenName(), (Object)sessionId);
            umaToken = JWTCacheProxy.getInstance().getUMAToken(user, sessionId);
            if (umaToken != null && !umaToken.isExpired() && umaToken.getAud().contains(urlEncodedScope)) {
                _log.trace("Current UMA token is OK {}", (Object)umaToken.getTokenEssentials());
            } else {
                if (umaToken != null && umaToken.getAud().contains(urlEncodedScope) && umaToken.isExpired()) {
                    if (REFRESH_UMA_TOKEN) {
                        _log.debug("Suitable UMA token found but is expired, trying to refresh it {}", (Object)umaToken.getTokenEssentials());
                        LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration((HttpServletRequest)request);
                        try {
                            umaToken = OpenIdConnectRESTHelper.refreshToken((URL)configuration.getTokenURL(), (JWTToken)umaToken);
                            _log.debug("Got a refreshed UMA token {}", (Object)umaToken.getTokenEssentials());
                            _log.debug("Setting the refreshed UMA token in cache proxy for user {}, and session]", (Object)user.getScreenName(), (Object)sessionId);
                            JWTCacheProxy.getInstance().setUMAToken(user, sessionId, umaToken);
                        }
                        catch (OpenIdConnectRESTHelperException e) {
                            if (e.hasJSONPayload()) {
                                if (OpenIdConnectRESTHelper.isInvalidBearerTokenError((String)e.getResponseString())) {
                                    if (FORCE_LOGOUT_ON_INVALID_OIDC) {
                                        _log.warn("OIDC token is become invalid, forcing redirect to logout URI");
                                        this.forceLogout(response);
                                    } else {
                                        _log.warn("OIDC token is become invalid, cannot continue");
                                    }
                                    return;
                                }
                                if (OpenIdConnectRESTHelper.isTokenNotActiveError((String)e.getResponseString())) {
                                    _log.info("UMA token is no more active, get new one");
                                } else {
                                    _log.error("Other UMA token refresh error", (Throwable)e);
                                }
                            } else {
                                _log.error("Refreshing UMA token on server " + umaToken.getTokenEssentials(), (Throwable)e);
                            }
                            umaToken = null;
                            _log.debug("Removing inactive UMA token from cache proxy if present for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                            JWTCacheProxy.getInstance().removeUMAToken(user, sessionId);
                        }
                    } else {
                        _log.debug("Suitable UMA token found but it is expired.It will be replaced with new one according to settings {}", (Object)umaToken.getTokenEssentials());
                        umaToken = null;
                        _log.debug("Removing inactive UMA token from cache proxy if present for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                        JWTCacheProxy.getInstance().removeUMAToken(user, sessionId);
                    }
                }
                if (umaToken == null || !umaToken.getAud().contains(urlEncodedScope)) {
                    boolean scopeIsChanged = false;
                    if (umaToken == null) {
                        _log.debug("Getting new UMA token for scope {}", (Object)urlEncodedScope);
                    } else if (!umaToken.getAud().contains(urlEncodedScope)) {
                        scopeIsChanged = true;
                        _log.info("Getting new UMA token for scope {} since it has been issued for another scope {}", (Object)urlEncodedScope, (Object)umaToken.getTokenEssentials());
                    }
                    _log.debug("Getting OIDC token from cache proxy for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                    JWTToken authToken = JWTCacheProxy.getInstance().getOIDCToken(user, sessionId);
                    if (authToken == null) {
                        if (FORCE_LOGOUT_ON_MISSING_OIDC) {
                            _log.trace("OIDC token is null in cache proxy, force redirecting to logut URI");
                            this.forceLogout(response);
                        } else {
                            _log.error("OIDC token is null in cache proxy, cannot continue!");
                        }
                        return;
                    }
                    _log.debug("OIDC token is {}", (Object)authToken.getTokenEssentials());
                    LiferayOpenIdConnectConfiguration configuration = LiferayOpenIdConnectConfiguration.getConfiguration((HttpServletRequest)request);
                    boolean isNotAuthorized = false;
                    int authorizationAttempts = 0;
                    do {
                        try {
                            if (isNotAuthorized || scopeIsChanged || authToken.isExpired()) {
                                if (isNotAuthorized) {
                                    _log.info("UMA token is not authorized with current OIDC token, refreshing it to be sure that new grants are present. [attempts: {}]", (Object)authorizationAttempts);
                                    isNotAuthorized = false;
                                } else if (scopeIsChanged) {
                                    _log.info("Scope is changed, refreshing token to be sure that new grants are present");
                                } else if (authToken.isExpired()) {
                                    _log.debug("OIDC token is expired, trying to refresh it {}", (Object)authToken.getTokenEssentials());
                                }
                                try {
                                    authToken = OpenIdConnectRESTHelper.refreshToken((URL)configuration.getTokenURL(), (JWTToken)authToken);
                                }
                                catch (OpenIdConnectRESTHelperException e) {
                                    if (FORCE_LOGOUT_ON_OIDC_REFRESH_ERROR) {
                                        _log.warn("Error refreshing OIDC token, force redirecting to logut URI");
                                        this.forceLogout(response);
                                    } else {
                                        _log.error("Refreshing OIDC token on server", (Throwable)e);
                                    }
                                    return;
                                }
                                _log.debug("Setting refreshed OIDC token in cache proxy");
                                JWTCacheProxy.getInstance().setOIDCToken(user, sessionId, authToken);
                            }
                            _log.info("Getting UMA token from OIDC endpoint for scope: " + urlEncodedScope);
                            umaToken = OpenIdConnectRESTHelper.queryUMAToken((URL)configuration.getTokenURL(), (String)authToken.getAccessTokenAsBearer(), (String)urlEncodedScope, null);
                            _log.debug("Got new UMA token {}", (Object)umaToken.getTokenEssentials());
                        }
                        catch (OpenIdConnectRESTHelperException e) {
                            if (e.hasJSONPayload()) {
                                if (OpenIdConnectRESTHelper.isInvalidBearerTokenError((String)e.getResponseString())) {
                                    if (FORCE_LOGOUT_ON_INVALID_OIDC) {
                                        _log.warn("OIDC token is become invalid, forcing redirect to logout URI");
                                        this.forceLogout(response);
                                    } else {
                                        _log.error("OIDC token is become invalid, cannot continue");
                                    }
                                    return;
                                }
                                if (!OpenIdConnectRESTHelper.isAccessDeniedNotAuthorizedError((String)e.getResponseString())) continue;
                                _log.info("UMA token is" + (isNotAuthorized ? " still" : "") + " not authorized with actual OIDC token");
                                isNotAuthorized = true;
                                if (++authorizationAttempts <= 4) {
                                    _log.debug("Sleeping 4000 ms and looping refreshing the OIDC");
                                    try {
                                        Thread.sleep(4000L);
                                    }
                                    catch (InterruptedException ie) {
                                        ie.printStackTrace();
                                    }
                                    continue;
                                }
                                _log.warn("OIDC token refresh attempts exhausted");
                                return;
                            }
                            _log.error("Getting UMA token from server", (Throwable)e);
                            return;
                        }
                    } while (isNotAuthorized);
                }
                _log.debug("Setting UMA token in cache proxy for user {} and session {}", (Object)user.getScreenName(), (Object)sessionId);
                JWTCacheProxy.getInstance().setUMAToken(user, sessionId, umaToken);
            }
        }
        _log.trace("Current UMA token in use is: {}", (Object)umaToken.getTokenEssentials());
        _log.debug("Setting UMA token with jti {} in UMA JWT provider", (Object)umaToken.getJti());
        UmaJWTProvider.instance.set(umaToken.getRaw());
    }

    protected void forceLogout(HttpServletResponse response) {
        try {
            if (!response.isCommitted()) {
                response.sendRedirect(LOGOUT_URI);
            } else {
                _log.warn("Cannot redirect to logout URI since the response is already commited");
            }
        }
        catch (IOException e) {
            _log.error("Cannot redirect to logout URI: " + LOGOUT_URI, (Throwable)e);
        }
    }

    private static boolean validateContext(String context) {
        String separator = "/";
        if (!context.matches("\\S+")) {
            return false;
        }
        String[] components = context.split(separator);
        return components.length >= 2 && components.length <= 4;
    }

    private static String generateAuthorizationToken(String username, String scope) {
        String token;
        ArrayList<String> userRoles = new ArrayList<String>();
        userRoles.add(DEFAULT_ROLE);
        try {
            token = Constants.authorizationService().generateUserToken(new UserInfo(username, userRoles), scope);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return token;
    }

    public static String getCurrentUsername(HttpServletRequest httpServletRequest) {
        User user = SmartGearsPortalValve.getCurrentUser(httpServletRequest);
        return user != null ? user.getScreenName() : null;
    }

    public static User getCurrentUser(HttpServletRequest httpServletRequest) {
        String userIdNo = httpServletRequest.getHeader("gcube-userId");
        if (userIdNo != null && userIdNo.compareTo("undefined") != 0) {
            long userId = -1L;
            try {
                userId = Long.parseLong(userIdNo);
                return UserLocalServiceUtil.getUser((long)userId);
            }
            catch (NumberFormatException e) {
                _log.error("The userId is not a number -> " + userIdNo);
                return null;
            }
            catch (Exception e) {
                _log.error("The userId does not belong to any user -> " + userIdNo);
                return null;
            }
        }
        return null;
    }
}

