/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portets.user.message_conversations.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.Widget;
import gwt.material.design.client.constants.Color;
import gwt.material.design.client.constants.IconType;
import gwt.material.design.client.ui.MaterialButton;
import gwt.material.design.client.ui.MaterialChip;
import gwt.material.design.client.ui.MaterialLabel;
import gwt.material.design.client.ui.MaterialPanel;
import gwt.material.design.client.ui.MaterialPreLoader;
import gwt.material.design.client.ui.MaterialTextArea;
import gwt.material.design.client.ui.MaterialTextBox;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portal.clientcontext.client.GCubeClientContext;
import org.gcube.portets.user.message_conversations.client.MessageServiceAsync;
import org.gcube.portets.user.message_conversations.client.Utils;
import org.gcube.portets.user.message_conversations.client.autocomplete.MaterialAutoComplete;
import org.gcube.portets.user.message_conversations.client.oracle.UserOracle;
import org.gcube.portets.user.message_conversations.client.oracle.UserSuggestion;
import org.gcube.portets.user.message_conversations.client.ui.ApplicationView;
import org.gcube.portets.user.message_conversations.client.ui.WriteMessage;
import org.gcube.portets.user.message_conversations.shared.ConvMessage;
import org.gcube.portets.user.message_conversations.shared.MessageUserModel;
import org.gcube.portets.user.message_conversations.shared.WSUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class WriteMessage
extends Composite {
    private static MessageWindowUiBinder uiBinder = (MessageWindowUiBinder)GWT.create(MessageWindowUiBinder.class);
    @UiField
    MaterialPanel mainPanel;
    @UiField
    MaterialTextBox txtBoxSubject;
    @UiField
    MaterialAutoComplete acModal;
    @UiField
    MaterialButton btnSendModal;
    @UiField
    MaterialButton btnCloseModal;
    @UiField
    MaterialPanel modalContent;
    @UiField
    MaterialPanel sendingLoader;
    @UiField
    MaterialLabel sendingFeedback;
    @UiField
    MaterialPreLoader sendingSpinner;
    @UiField
    MaterialTextArea txtArea;
    private ApplicationView ap;
    private MessageServiceAsync convService;

    public WriteMessage(MessageServiceAsync convService, ApplicationView ap) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.convService = convService;
        this.ap = ap;
        UserOracle oracle = new UserOracle();
        oracle.addContacts(this.getAllUsers());
        this.acModal.setSuggestions((SuggestOracle)oracle);
        this.btnSendModal.getElement().getStyle().setBackgroundImage("none");
    }

    MaterialPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setNewMessageForSendTo(String[] usernames) {
        GWT.log((String)"her add the users");
        this.convService.getUsersInfo(usernames, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setIsReply(ConvMessage msg) {
        this.acModal.addItem((SuggestOracle.Suggestion)new UserSuggestion(new WSUser(msg.getOwner().getUsername(), msg.getOwner().getUsername(), msg.getOwner().getFullName(), msg.getOwner().getEmail())));
        String subject = this.getReplySubject(msg.getSubject());
        this.txtBoxSubject.setText(subject);
        this.txtBoxSubject.setReadOnly(true);
        this.txtArea.setText(this.getReplyHeaderMessage(msg));
        this.focusOnBody();
    }

    public void setIsReplyAll(ConvMessage msg) {
        this.setIsReply(msg);
        long currUserId = 0L;
        try {
            currUserId = Long.parseLong(GCubeClientContext.getCurrentUserId());
        }
        catch (Exception e) {
            WriteMessage.log((String)"Could not read userId client context");
            return;
        }
        for (MessageUserModel u : msg.getRecipients()) {
            if (u.getUserId() == currUserId) continue;
            this.acModal.addItem((SuggestOracle.Suggestion)new UserSuggestion(new WSUser(u.getUserId() + "", u.getUsername(), u.getFullName(), u.getEmail())));
        }
        this.focusOnBody();
    }

    public void setIsForward(ConvMessage msg) {
        String subject = "Fwd: " + msg.getSubject();
        this.txtBoxSubject.setText(subject);
        this.txtBoxSubject.setReadOnly(true);
        this.txtArea.setText(this.getForwardHeaderMessage(msg));
    }

    private void focusOnBody() {
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(1000);
    }

    private String getReplySubject(String subject) {
        if (subject != null) {
            return subject.startsWith("Re:") ? subject : "Re: " + subject;
        }
        return "No subject";
    }

    private String getReplyHeaderMessage(ConvMessage msg) {
        String toReturn = "\n\n---\n on " + msg.getDate() + " " + msg.getOwner().getFullName() + " wrote:";
        toReturn = toReturn + "\n\n" + msg.getContent();
        return toReturn;
    }

    private static native void log(String var0);

    private String getForwardHeaderMessage(ConvMessage msg) {
        String toReturn = "\n\n---\nBegin forwarded message:";
        toReturn = toReturn + "\nFrom: " + msg.getOwner().getFullName();
        toReturn = toReturn + "\nDate: " + msg.getDate();
        toReturn = toReturn + "\nTo: ";
        if (msg.getRecipients() != null) {
            for (MessageUserModel recipient : msg.getRecipients()) {
                toReturn = toReturn + recipient.getFullName() + " ";
            }
        }
        toReturn = toReturn + "\nSubject: " + msg.getSubject();
        toReturn = toReturn + "\n\n" + msg.getContent();
        return toReturn;
    }

    public WriteMessage setFocusOnUsersInput() {
        if (!Utils.isMobile()) {
            this.acModal.setFocus(true);
        }
        return this;
    }

    private List<WSUser> getAllUsers() {
        ArrayList<WSUser> toReturn = new ArrayList<WSUser>();
        toReturn.add(new WSUser("testing", "username testing", "Andrea testing", "@gmail.com"));
        return toReturn;
    }

    private MaterialChip getChip(String itemId, String itemName, boolean isFolder, boolean deletable) {
        MaterialChip chip = new MaterialChip(itemName);
        if (deletable) {
            chip.setIconType(IconType.CLOSE);
        }
        chip.setMargin(5.0);
        chip.setId(itemId);
        if (isFolder) {
            chip.setLetter("F");
            chip.setLetterBackgroundColor(Color.AMBER);
            chip.setBackgroundColor(Color.YELLOW);
            chip.setTextColor(Color.GREY_DARKEN_2);
        } else {
            chip.setLetter("D");
            chip.setLetterBackgroundColor(Color.RED);
            chip.setTextColor(Color.GREY_DARKEN_2);
        }
        return chip;
    }

    private ArrayList<String> getSelectedFilesAndFoldersId() {
        ArrayList<String> toReturn = new ArrayList<String>();
        return toReturn;
    }

    @UiHandler(value={"btnSendModal"})
    void onSendMessage(ClickEvent e) {
        if (this.getSelectedUsers().isEmpty()) {
            this.acModal.setError("Look empty to me");
            return;
        }
        this.acModal.reset();
        if (this.txtBoxSubject.getText().isEmpty()) {
            this.txtBoxSubject.setError("Subject is mandatory");
            return;
        }
        this.txtBoxSubject.reset();
        if (this.txtArea.getText().isEmpty()) {
            this.txtArea.setError("The body of the message is mandatory");
            return;
        }
        this.txtArea.reset();
        GWT.log((String)(this.getSelectedUsers() + ""));
        ArrayList<String> recipientIds = new ArrayList<String>();
        for (WSUser u : this.getSelectedUsers()) {
            recipientIds.add(u.getScreenname());
        }
        this.modalContent.setVisible(false);
        this.sendingLoader.setVisible(true);
        this.btnSendModal.setEnabled(false);
        ApplicationView.WRITING_MESSAGE = false;
        this.convService.sendToById(recipientIds, this.getSelectedFilesAndFoldersId(), this.txtBoxSubject.getText(), this.txtArea.getText(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    @UiHandler(value={"btnCloseModal"})
    void onClose(ClickEvent e) {
        if (Utils.isMobile()) {
            this.ap.showSidePanel();
        }
        this.mainPanel.clear();
        ApplicationView.WRITING_MESSAGE = false;
    }

    public List<WSUser> getSelectedUsers() {
        List values = this.acModal.getValue();
        ArrayList<WSUser> users = new ArrayList<WSUser>(values.size());
        for (SuggestOracle.Suggestion value : values) {
            if (!(value instanceof UserSuggestion)) continue;
            UserSuggestion us = (UserSuggestion)value;
            WSUser user = us.getUser();
            users.add(user);
        }
        return users;
    }
}

