/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portets.user.message_conversations.server;

import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.client.plugins.AbstractPlugin;
import org.gcube.common.storagehub.client.proxies.MessageManagerClient;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.messages.Message;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MessageNotificationsThread;
import org.gcube.portets.user.message_conversations.client.MessageService;
import org.gcube.portets.user.message_conversations.server.HttpServletRetriever;
import org.gcube.portets.user.message_conversations.shared.ConvMessage;
import org.gcube.portets.user.message_conversations.shared.CurrUserAndPortalUsersWrapper;
import org.gcube.portets.user.message_conversations.shared.FileModel;
import org.gcube.portets.user.message_conversations.shared.MessageUserModel;
import org.gcube.portets.user.message_conversations.shared.WSUser;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvServiceImpl
implements MessageService {
    private static final Logger _log = LoggerFactory.getLogger(ConvServiceImpl.class);
    private final int MESSAGE_BODY_CHAR_LIMIT = 79;
    private PortalContext pContext;
    private UserManager um = new LiferayUserManager();
    private HttpServletRetriever requestRetriever;

    ConvServiceImpl(HttpServletRetriever servletRetriever) {
        this.pContext = PortalContext.getConfiguration();
        this.requestRetriever = servletRetriever;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    private GCubeUser getCurrentUser(HttpServletRequest httpServletRequest) {
        if (this.isWithinPortal()) {
            try {
                long userId = PortalUtil.getUser((HttpServletRequest)httpServletRequest).getUserId();
                long groupId = this.pContext.getCurrentGroupId(httpServletRequest);
                if (GroupLocalServiceUtil.hasUserGroup((long)userId, (long)groupId)) {
                    return this.um.getUserById(userId);
                }
                _log.error("User not authorised in Group, the logged user id=" + userId + " does not belong to group " + groupId);
                return null;
            }
            catch (Exception e) {
                _log.warn("Could not read user from LR PortalUtil in delegate servlet");
                return null;
            }
        }
        return this.pContext.getCurrentUser(this.requestRetriever.getRequest());
    }

    public ArrayList<ConvMessage> getMessages(boolean sent) {
        ArrayList<ConvMessage> toReturn = new ArrayList<ConvMessage>();
        try {
            List listMessages;
            GCubeUser user = this.getCurrentUser(this.requestRetriever.getRequest());
            this.pContext = PortalContext.getConfiguration();
            _log.debug("*** Reading user = " + user.getFullname());
            String scope = this.pContext.getCurrentScope(this.requestRetriever.getRequest());
            ScopeProvider.instance.set(scope);
            String token = this.pContext.getCurrentUserToken(scope, user.getUserId());
            SecurityTokenProvider.instance.set(token);
            MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
            long start = System.currentTimeMillis();
            List list = listMessages = sent ? client.getSentMessages(79) : client.getReceivedMessages(79);
            if (listMessages == null) {
                _log.error("listMessages is null, Could not read messages of {}", (Object)user.getFullname());
                return null;
            }
            _log.debug("Got messages of {} how many? {}  in {} ms", new Object[]{user.getFullname(), listMessages.size(), System.currentTimeMillis() - start});
            LiferayUserManager um = new LiferayUserManager();
            for (Message m : listMessages) {
                String previewBody = m.getBody() + " ...";
                MessageUserModel mu = null;
                GCubeUser sender = null;
                try {
                    if (sent) {
                        if (m.getAddresses().length < 2) {
                            GCubeUser recipient = um.getUserByUsername(m.getAddresses()[0]);
                            mu = new MessageUserModel(recipient.getUserId(), recipient.getUsername(), recipient.getFullname(), recipient.getUserAvatarURL(), "", "");
                        } else {
                            GCubeUser recipient1 = um.getUserByUsername(m.getAddresses()[0]);
                            GCubeUser recipient2 = um.getUserByUsername(m.getAddresses()[1]);
                            String label2Display = recipient1.getFirstName() + " & " + recipient2.getFirstName();
                            if (m.getAddresses().length > 2) {
                                label2Display = label2Display + " & ...";
                            }
                            mu = new MessageUserModel(recipient1.getUserId(), recipient1.getUsername(), label2Display, null, "", "");
                        }
                    } else {
                        sender = um.getUserByUsername(m.getSender().getUserName());
                        mu = new MessageUserModel(sender.getUserId(), sender.getUsername(), sender.getFullname(), sender.getUserAvatarURL(), "", "");
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    mu = !sent ? new MessageUserModel(m.getSender().getUserName()) : new MessageUserModel(m.getAddresses()[0]);
                }
                boolean hasAttachments = m.isWithAttachments();
                if (!sent) {
                    toReturn.add(new ConvMessage(m.getId(), m.getSubject(), mu, new Date(m.getCreationTime().getTimeInMillis()), previewBody, m.isRead(), hasAttachments));
                    continue;
                }
                ArrayList<MessageUserModel> recipients = new ArrayList<MessageUserModel>();
                for (String rec : m.getAddresses()) {
                    recipients.add(new MessageUserModel(rec));
                }
                toReturn.add(new ConvMessage(m.getId(), m.getSubject(), mu, recipients, new Date(m.getCreationTime().getTimeInMillis()), previewBody, m.isRead(), hasAttachments));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        _log.trace("get All Messages Received ");
        return toReturn;
    }

    public boolean markMessageUnread(String messageId, boolean sent) {
        GCubeUser user = this.getCurrentUser(this.requestRetriever.getRequest());
        String scope = this.pContext.getCurrentScope(this.requestRetriever.getRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        try {
            MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
            client.setRead(messageId, Boolean.valueOf(false));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public ConvMessage getMessageById(String messageId, boolean sent) {
        ConvMessage toReturn = null;
        try {
            GCubeUser user = this.getCurrentUser(this.requestRetriever.getRequest());
            _log.debug("*** Reading user from liferay session = " + user.getFullname());
            String scope = this.pContext.getCurrentScope(this.requestRetriever.getRequest());
            SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
            LiferayUserManager um = new LiferayUserManager();
            MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
            Message m = client.get(messageId);
            MessageUserModel mu = null;
            GCubeUser sender = null;
            try {
                sender = um.getUserByUsername(m.getSender().getUserName());
                mu = new MessageUserModel(sender.getUserId(), sender.getUsername(), sender.getFullname(), this.extractDomainFromEmail(sender.getEmail()));
            }
            catch (Exception ex) {
                mu = new MessageUserModel(m.getSender().getUserName());
            }
            ArrayList<MessageUserModel> recipients = new ArrayList<MessageUserModel>();
            for (String recipient : m.getAddresses()) {
                try {
                    GCubeUser toAdd = um.getUserByUsername(recipient);
                    recipients.add(new MessageUserModel(toAdd.getUserId(), toAdd.getUsername(), toAdd.getFullname(), this.extractDomainFromEmail(toAdd.getEmail())));
                }
                catch (Exception ex) {
                    recipients.add(new MessageUserModel(recipient));
                }
            }
            ArrayList<FileModel> attachments = new ArrayList<FileModel>();
            List attachItems = client.getAttachments(messageId);
            for (Item item : attachItems) {
                String downloadURL = null;
                attachments.add(new FileModel(item.getId(), item.getName(), null, item instanceof FolderItem, downloadURL));
            }
            boolean hasAttachments = !attachItems.isEmpty();
            toReturn = new ConvMessage(m.getId(), m.getSubject(), mu, recipients, new Date(m.getCreationTime().getTimeInMillis()), m.getBody(), m.isRead(), attachments, hasAttachments);
            if (!sent) {
                m.setRead(true);
                client.setRead(messageId, Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public String getAttachmentDownloadURL(String itemId) {
        GCubeUser user = this.getCurrentUser(this.requestRetriever.getRequest());
        String scope = this.pContext.getCurrentScope(this.requestRetriever.getRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        _log.info("getAttachmentDownloadURL for user " + user.getUsername() + " file id=" + itemId);
        try {
            StorageHubClient shc = new StorageHubClient();
            String downladURL = shc.open(itemId).asFile().getPublicLink().toString();
            downladURL = downladURL.startsWith("https") ? downladURL : downladURL.replace("http", "https");
            return downladURL;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveAttachmentToWorkspaceFolder(String itemId, String destinationFolderId) {
        GCubeUser user = this.getCurrentUser(this.requestRetriever.getRequest());
        String scope = this.pContext.getCurrentScope(this.requestRetriever.getRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        try {
            StorageHubClient shc = new StorageHubClient();
            FileContainer fileContainer = shc.open(itemId).asFile();
            FileContainer copiedFile = fileContainer.copy(shc.open(destinationFolderId).asFolder(), ((AbstractFileItem)fileContainer.get()).getTitle());
            return copiedFile.get() != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean deleteMessageById(String messageId, boolean sent) {
        GCubeUser user = this.getCurrentUser(this.requestRetriever.getRequest());
        _log.debug("deleteMessageById reading user from liferay session = " + user.getFullname() + " m id = " + messageId);
        String scope = this.pContext.getCurrentScope(this.requestRetriever.getRequest());
        SecurityTokenProvider.instance.set(this.pContext.getCurrentUserToken(scope, user.getUserId()));
        try {
            MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
            client.delete(messageId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public ArrayList<WSUser> searchUsers(String keyword) {
        ArrayList<WSUser> toReturn = new ArrayList<WSUser>();
        if (this.isWithinPortal()) {
            long gatewayGroupId = this.pContext.getCurrentGroupId(this.requestRetriever.getRequest());
            try {
                _log.debug("Searching " + keyword);
                List users = this.um.searchUsersByGroup(keyword, gatewayGroupId);
                for (GCubeUser user : users) {
                    toReturn.add(new WSUser("" + user.getUserId(), user.getUsername(), user.getFullname(), this.extractDomainFromEmail(user.getEmail())));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                toReturn.add(new WSUser("andrea.rossi", "andrea.rossi", "Andrea Rossi", "m.assante@gmail.com"));
                if (i % 2 == 0) {
                    toReturn.add(new WSUser("" + i, "username" + i, "userGetFullname()" + i, "user.getEmail()" + i));
                    continue;
                }
                toReturn.add(new WSUser("" + i, "ciccio" + i, "ciccioNome" + i, "ciccioEMail" + i));
            }
        }
        return toReturn;
    }

    public ArrayList<WSUser> getUsersInfo(String[] usernames) {
        ArrayList<WSUser> toReturn = new ArrayList<WSUser>();
        if (this.isWithinPortal()) {
            try {
                for (String username : usernames) {
                    User user = UserLocalServiceUtil.getUserByScreenName((long)ManagementUtils.getCompany().getCompanyId(), (String)username);
                    toReturn.add(new WSUser("" + user.getUserId(), user.getScreenName(), user.getFullName(), this.extractDomainFromEmail(user.getEmailAddress())));
                }
            }
            catch (PortalException | SystemException e) {
                e.printStackTrace();
            }
        } else {
            toReturn.add(new WSUser("andrea.rossi", "andrea.rossi", "Andrea Rossi", "rossi@gmail.com"));
            toReturn.add(new WSUser("ginoi", "gino", "Gino Pino", "gino@hotmail.com"));
        }
        return toReturn;
    }

    public boolean sendToById(ArrayList<String> recipientIds, ArrayList<String> listAttachmentsId, String subject, String body) {
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currentUser = pContext.getCurrentUser(this.requestRetriever.getRequest());
        MessageManagerClient client = (MessageManagerClient)AbstractPlugin.messages().build();
        try {
            _log.info("Sending message to: " + recipientIds.toString());
            String checkedSubject = subject;
            String checkedBody = body;
            String messageId = client.sendMessage(recipientIds, checkedSubject, checkedBody, listAttachmentsId);
            _log.debug("Sending message notification to: " + recipientIds.toString());
            List recipients = this.getUsersbyUserId(recipientIds);
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.requestRetriever.getRequest()), pContext.getCurrentScope(this.requestRetriever.getRequest()), new SocialNetworkingUser(currentUser.getUsername(), currentUser.getEmail(), currentUser.getFullname(), currentUser.getUserAvatarURL()));
            Thread thread = new Thread((Runnable)new MessageNotificationsThread(recipients, messageId, checkedSubject, body, (NotificationsManager)nm));
            thread.start();
            return true;
        }
        catch (Exception e) {
            _log.error("While Sending message to: " + recipientIds.toString());
            e.printStackTrace();
            return false;
        }
    }

    private String extractDomainFromEmail(String email) {
        int index = email.indexOf(64);
        if (index > 0) {
            return email.substring(index);
        }
        return "@unknown-domain";
    }

    private List<GenericItemBean> getUsersbyUserId(List<String> recipientIds) {
        ArrayList<GenericItemBean> recipients = new ArrayList<GenericItemBean>();
        for (String userid : recipientIds) {
            GCubeUser user = null;
            try {
                user = new LiferayUserManager().getUserByUsername(userid);
                recipients.add(new GenericItemBean("" + user.getUserId(), user.getUsername(), user.getFullname(), ""));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return recipients;
    }

    public CurrUserAndPortalUsersWrapper getWorkspaceUsers() {
        PortalContext pContext = PortalContext.getConfiguration();
        GCubeUser currentUser = pContext.getCurrentUser(this.requestRetriever.getRequest());
        _log.debug("trying to get WorkspaceUsers ..");
        WSUser currUser = null;
        ArrayList<WSUser> portalUsers = new ArrayList<WSUser>();
        try {
            if (this.isWithinPortal()) {
                LiferayUserManager um = new LiferayUserManager();
                LiferayGroupManager gm = new LiferayGroupManager();
                List users = um.listUsersByGroup(gm.getRootVO().getGroupId());
                for (GCubeUser user : users) {
                    _log.trace("Trying to get additional info for " + user.getUsername());
                    portalUsers.add(new WSUser(user.getUserId() + "", user.getUsername(), user.getFullname(), user.getEmail()));
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    portalUsers.add(new WSUser("" + i, "username" + i, "userGetFullname()" + i, "user.getEmail()" + i));
                }
            }
            currUser = new WSUser(currentUser.getUsername(), currentUser.getUsername(), currentUser.getFullname(), currentUser.getEmail());
        }
        catch (Exception e) {
            _log.error("Error in server get all contacts ", (Throwable)e);
        }
        CurrUserAndPortalUsersWrapper toReturn = new CurrUserAndPortalUsersWrapper(currUser, portalUsers);
        return toReturn;
    }
}

