package org.gcube.portets.user.message_conversations.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;

public interface MessageServiceAsync
{

    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void getMessages( boolean sent, AsyncCallback<java.util.ArrayList<org.gcube.portets.user.message_conversations.shared.ConvMessage>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void getMessageById( java.lang.String messageId, boolean sent, AsyncCallback<org.gcube.portets.user.message_conversations.shared.ConvMessage> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void getWorkspaceUsers( AsyncCallback<org.gcube.portets.user.message_conversations.shared.CurrUserAndPortalUsersWrapper> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void getUsersInfo( java.lang.String[] usernames, AsyncCallback<java.util.ArrayList<org.gcube.portets.user.message_conversations.shared.WSUser>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void searchUsers( java.lang.String keyword, AsyncCallback<java.util.ArrayList<org.gcube.portets.user.message_conversations.shared.WSUser>> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void sendToById( java.util.ArrayList<java.lang.String> recipientIds, java.util.ArrayList<java.lang.String> listAttachmentsId, java.lang.String subject, java.lang.String body, AsyncCallback<java.lang.Boolean> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void deleteMessageById( java.lang.String messageId, boolean sent, AsyncCallback<java.lang.Boolean> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void getAttachmentDownloadURL( java.lang.String itemId, AsyncCallback<java.lang.String> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void saveAttachmentToWorkspaceFolder( java.lang.String itemId, java.lang.String destinationFolderId, AsyncCallback<java.lang.Boolean> callback );


    /**
     * GWT-RPC service  asynchronous (client-side) interface
     * @see org.gcube.portets.user.message_conversations.client.MessageService
     */
    void markMessageUnread( java.lang.String messageId, boolean sent, AsyncCallback<java.lang.Boolean> callback );


    /**
     * Utility class to get the RPC Async interface from client-side code
     */
    public static final class Util 
    { 
        private static MessageServiceAsync instance;

        public static final MessageServiceAsync getInstance()
        {
            if ( instance == null )
            {
                instance = (MessageServiceAsync) GWT.create( MessageService.class );
                ServiceDefTarget target = (ServiceDefTarget) instance;
                target.setServiceEntryPoint( GWT.getModuleBaseURL() + "MessageService" );
            }
            return instance;
        }

        private Util()
        {
            // Utility class should not be instantiated
        }
    }
}
