/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portets.user.message_conversations.client.autocomplete;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.TextResource;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import gwt.material.design.addins.client.MaterialAddins;
import gwt.material.design.addins.client.autocomplete.constants.AutocompleteType;
import gwt.material.design.client.MaterialDesignBase;
import gwt.material.design.client.base.AbstractValueWidget;
import gwt.material.design.client.base.HasPlaceholder;
import gwt.material.design.client.base.HasProgress;
import gwt.material.design.client.base.HasReadOnly;
import gwt.material.design.client.base.HasType;
import gwt.material.design.client.base.MaterialWidget;
import gwt.material.design.client.base.Suggestion;
import gwt.material.design.client.base.mixin.CssTypeMixin;
import gwt.material.design.client.base.mixin.ErrorMixin;
import gwt.material.design.client.base.mixin.FocusableMixin;
import gwt.material.design.client.base.mixin.ProgressMixin;
import gwt.material.design.client.base.mixin.ReadOnlyMixin;
import gwt.material.design.client.constants.CssType;
import gwt.material.design.client.constants.ProgressType;
import gwt.material.design.client.ui.MaterialChip;
import gwt.material.design.client.ui.MaterialLabel;
import gwt.material.design.client.ui.MaterialProgress;
import gwt.material.design.client.ui.html.Label;
import gwt.material.design.client.ui.html.ListItem;
import gwt.material.design.client.ui.html.UnorderedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.portets.user.message_conversations.client.autocomplete.MaterialAutoComplete;
import org.gcube.portets.user.message_conversations.client.autocomplete.MaterialAutocompleteClientBundle;
import org.gcube.portets.user.message_conversations.client.autocomplete.MaterialAutocompleteDebugClientBundle;

public class MaterialAutoComplete
extends AbstractValueWidget<List<? extends SuggestOracle.Suggestion>>
implements HasPlaceholder,
HasProgress,
HasType<AutocompleteType>,
HasSelectionHandlers<SuggestOracle.Suggestion>,
HasReadOnly {
    private Map<SuggestOracle.Suggestion, Widget> suggestionMap = new LinkedHashMap();
    private Label placeholderLabel = new Label();
    private List<ListItem> itemsHighlighted = new ArrayList();
    private FlowPanel panel = new FlowPanel();
    private UnorderedList list = new UnorderedList();
    private SuggestOracle suggestions;
    private TextBox itemBox = new TextBox();
    private SuggestBox suggestBox;
    private int limit = 0;
    private MaterialLabel errorLabel = new MaterialLabel();
    private final ProgressMixin<MaterialAutoComplete> progressMixin = new ProgressMixin((UIObject)this);
    private String selectedChipStyle = "blue white-text";
    private boolean directInputAllowed = true;
    private MaterialChipProvider chipProvider = new DefaultMaterialChipProvider();
    private final ErrorMixin<AbstractValueWidget, MaterialLabel> errorMixin = new ErrorMixin((UIObject)this, (UIObject)this.errorLabel, (UIObject)this.list, (UIObject)this.placeholderLabel);
    private FocusableMixin<MaterialWidget> focusableMixin;
    private ReadOnlyMixin<MaterialAutoComplete, TextBox> readOnlyMixin;
    public final CssTypeMixin<AutocompleteType, MaterialAutoComplete> typeMixin = new CssTypeMixin((UIObject)this, (UIObject)this);

    public MaterialAutoComplete() {
        super((Element)Document.get().createDivElement(), new String[]{"autocomplete", "input-field"});
        this.add((Widget)this.panel);
    }

    public MaterialAutoComplete(AutocompleteType type) {
        this();
        this.setType(type);
    }

    public MaterialAutoComplete(String placeholder) {
        this();
        this.setPlaceholder(placeholder);
    }

    public MaterialAutoComplete(SuggestOracle suggestions) {
        this();
        this.build(suggestions);
    }

    protected void build(SuggestOracle suggestions) {
        this.list.setStyleName("multiValueSuggestBox-list");
        this.suggestions = suggestions;
        ListItem item = new ListItem();
        item.setStyleName("multiValueSuggestBox-input-token");
        this.suggestBox = new SuggestBox(suggestions, (ValueBoxBase)this.itemBox);
        this.setLimit(this.limit);
        String autocompleteId = DOM.createUniqueId();
        this.itemBox.getElement().setId(autocompleteId);
        item.add((Widget)this.suggestBox);
        item.add((Widget)this.placeholderLabel);
        this.list.add((Widget)item);
        this.list.addDomHandler((EventHandler)((ClickHandler)event -> this.suggestBox.showSuggestionList()), ClickEvent.getType());
        this.itemBox.addBlurHandler(blurEvent -> {
            if (this.getValue().size() > 0) {
                this.placeholderLabel.addStyleName("active");
            }
        });
        this.itemBox.addKeyDownHandler(event -> {
            boolean changed = false;
            switch (event.getNativeKeyCode()) {
                case 13: {
                    String value;
                    if (!this.directInputAllowed || (value = this.itemBox.getValue()) == null || (value = value.trim()).isEmpty()) break;
                    Suggestion directInput = new Suggestion();
                    directInput.setDisplay(value);
                    directInput.setSuggestion(value);
                    changed = this.addItem((SuggestOracle.Suggestion)directInput);
                    if (this.getType() == AutocompleteType.TEXT) {
                        this.itemBox.setText(value);
                    } else {
                        this.itemBox.setValue((Object)"");
                    }
                    this.itemBox.setFocus(true);
                    break;
                }
                case 8: {
                    ListItem li;
                    if (this.itemBox.getValue().trim().isEmpty() && this.itemsHighlighted.isEmpty() && this.suggestionMap.size() > 0 && this.tryRemoveSuggestion((li = (ListItem)this.list.getWidget(this.list.getWidgetCount() - 2)).getWidget(0))) {
                        li.removeFromParent();
                        changed = true;
                    }
                }
                case 46: {
                    if (this.itemBox.getValue().trim().isEmpty()) {
                        for (ListItem li : this.itemsHighlighted) {
                            if (!this.tryRemoveSuggestion(li.getWidget(0))) continue;
                            li.removeFromParent();
                            changed = true;
                        }
                        this.itemsHighlighted.clear();
                    }
                    this.itemBox.setFocus(true);
                }
            }
            if (changed) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
            }
        });
        this.itemBox.addClickHandler(event -> this.suggestBox.showSuggestionList());
        this.suggestBox.addSelectionHandler(selectionEvent -> {
            SuggestOracle.Suggestion selectedItem = (SuggestOracle.Suggestion)selectionEvent.getSelectedItem();
            this.itemBox.setValue((Object)"");
            if (this.addItem(selectedItem)) {
                ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
            }
            this.itemBox.setFocus(true);
        });
        this.panel.add((Widget)this.list);
        this.panel.getElement().setAttribute("onclick", "document.getElementById('" + autocompleteId + "').focus()");
        this.panel.add((Widget)this.errorLabel);
        this.suggestBox.setFocus(true);
    }

    protected boolean tryRemoveSuggestion(Widget widget) {
        Set entrySet = this.suggestionMap.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!widget.equals(entry.getValue())) continue;
            if (this.chipProvider.isChipRemovable((SuggestOracle.Suggestion)entry.getKey())) {
                this.suggestionMap.remove(entry.getKey());
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean addItem(SuggestOracle.Suggestion suggestion) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)suggestion);
        if (this.getLimit() > 0 && this.suggestionMap.size() >= this.getLimit()) {
            return false;
        }
        if (this.suggestionMap.containsKey(suggestion)) {
            return false;
        }
        ListItem displayItem = new ListItem();
        displayItem.setStyleName("multiValueSuggestBox-token");
        if (this.getType() == AutocompleteType.TEXT) {
            this.suggestionMap.clear();
            this.itemBox.setText(suggestion.getDisplayString());
        } else {
            MaterialChip chip = this.chipProvider.getChip(suggestion);
            if (chip == null) {
                return false;
            }
            chip.addClickHandler(event -> {
                if (this.chipProvider.isChipSelectable(suggestion)) {
                    if (this.itemsHighlighted.contains(displayItem)) {
                        chip.removeStyleName(this.selectedChipStyle);
                        this.itemsHighlighted.remove(displayItem);
                    } else {
                        chip.addStyleName(this.selectedChipStyle);
                        this.itemsHighlighted.add(displayItem);
                    }
                }
            });
            if (chip.getIcon() != null) {
                chip.getIcon().addClickHandler(event -> {
                    if (this.chipProvider.isChipRemovable(suggestion)) {
                        this.suggestionMap.remove(suggestion);
                        this.list.remove((Widget)displayItem);
                        this.itemsHighlighted.remove(displayItem);
                        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
                        this.suggestBox.showSuggestionList();
                    }
                });
            }
            this.suggestionMap.put(suggestion, chip);
            displayItem.add((Widget)chip);
            this.list.insert((Widget)displayItem, this.list.getWidgetCount() - 1);
        }
        return true;
    }

    public void clear() {
        this.itemBox.setValue((Object)"");
        this.placeholderLabel.removeStyleName("active");
        Collection values = this.suggestionMap.values();
        for (Widget widget : values) {
            Widget parent = widget.getParent();
            if (!(parent instanceof ListItem)) continue;
            parent.removeFromParent();
        }
        this.suggestionMap.clear();
        this.clearErrorOrSuccess();
    }

    protected FocusableMixin<MaterialWidget> getFocusableMixin() {
        if (this.focusableMixin == null) {
            this.focusableMixin = new FocusableMixin((UIObject)new MaterialWidget((Element)this.itemBox.getElement()));
        }
        return this.focusableMixin;
    }

    public List<String> getItemValues() {
        Set keySet = this.suggestionMap.keySet();
        ArrayList<String> values = new ArrayList<String>(keySet.size());
        for (SuggestOracle.Suggestion suggestion : keySet) {
            values.add(suggestion.getReplacementString());
        }
        return values;
    }

    public void setItemValues(List<String> itemValues) {
        this.setItemValues(itemValues, false);
    }

    public void setItemValues(List<String> itemValues, boolean fireEvents) {
        if (itemValues == null) {
            this.clear();
            return;
        }
        ArrayList<Suggestion> list = new ArrayList<Suggestion>(itemValues.size());
        for (String value : itemValues) {
            Suggestion suggestion = new Suggestion(value, value);
            list.add(suggestion);
        }
        this.setValue(list, fireEvents);
        if (itemValues.size() > 0) {
            this.placeholderLabel.addStyleName("active");
        }
    }

    public List<ListItem> getItemsHighlighted() {
        return this.itemsHighlighted;
    }

    public void setItemsHighlighted(List<ListItem> itemsHighlighted) {
        this.itemsHighlighted = itemsHighlighted;
    }

    public SuggestOracle getSuggestions() {
        return this.suggestions;
    }

    public void setSuggestions(SuggestOracle suggestions) {
        this.suggestions = suggestions;
        this.build(suggestions);
    }

    public void setSuggestions(SuggestOracle suggestions, AutocompleteType type) {
        this.setType(type);
        this.setSuggestions(suggestions);
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
        if (this.suggestBox != null) {
            this.suggestBox.setLimit(limit);
        }
    }

    public void setAutoSuggestLimit(int limit) {
        if (this.suggestBox != null) {
            this.suggestBox.setLimit(limit);
        }
    }

    public String getPlaceholder() {
        return this.placeholderLabel.getText();
    }

    public void setPlaceholder(String placeholder) {
        this.placeholderLabel.setText(placeholder);
    }

    public MaterialChipProvider getChipProvider() {
        return this.chipProvider;
    }

    public void setChipProvider(MaterialChipProvider chipProvider) {
        this.chipProvider = chipProvider;
    }

    public void setDirectInputAllowed(boolean directInputAllowed) {
        this.directInputAllowed = directInputAllowed;
    }

    public boolean isDirectInputAllowed() {
        return this.directInputAllowed;
    }

    public void setSelectedChipStyle(String selectedChipStyle) {
        this.selectedChipStyle = selectedChipStyle;
    }

    public String getSelectedChipStyle() {
        return this.selectedChipStyle;
    }

    public void showProgress(ProgressType type) {
        this.progressMixin.showProgress(ProgressType.INDETERMINATE);
    }

    public void setPercent(double percent) {
        this.progressMixin.setPercent(percent);
    }

    public void hideProgress() {
        this.progressMixin.hideProgress();
    }

    public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
        return this.itemBox.addKeyUpHandler(event -> {
            if (this.isEnabled()) {
                handler.onKeyUp(event);
            }
        });
    }

    public void setType(AutocompleteType type) {
        this.typeMixin.setType((CssType)type);
    }

    public AutocompleteType getType() {
        return (AutocompleteType)this.typeMixin.getType();
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<SuggestOracle.Suggestion> handler) {
        return this.addHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, SelectionEvent.getType());
    }

    public ReadOnlyMixin<MaterialAutoComplete, TextBox> getReadOnlyMixin() {
        if (this.readOnlyMixin == null) {
            this.readOnlyMixin = new ReadOnlyMixin((UIObject)this, (UIObject)this.itemBox);
        }
        return this.readOnlyMixin;
    }

    public void setReadOnly(boolean value) {
        this.getReadOnlyMixin().setReadOnly(value);
        if (value) {
            this.setEnabled(false);
        }
    }

    public boolean isReadOnly() {
        return this.getReadOnlyMixin().isReadOnly();
    }

    public void setToggleReadOnly(boolean toggle) {
        this.getReadOnlyMixin().setToggleReadOnly(toggle);
    }

    public boolean isToggleReadOnly() {
        return this.getReadOnlyMixin().isToggleReadOnly();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<List<? extends SuggestOracle.Suggestion>> handler) {
        return this.addHandler((EventHandler)new /* Unavailable Anonymous Inner Class!! */, ValueChangeEvent.getType());
    }

    public HandlerRegistration addBlurHandler(BlurHandler handler) {
        return this.itemBox.addHandler((EventHandler)((BlurHandler)blurEvent -> {
            if (this.isEnabled()) {
                handler.onBlur(blurEvent);
            }
        }), (GwtEvent.Type)BlurEvent.getType());
    }

    public HandlerRegistration addFocusHandler(FocusHandler handler) {
        return this.itemBox.addHandler((EventHandler)((FocusHandler)focusEvent -> {
            if (this.isEnabled()) {
                handler.onFocus(focusEvent);
            }
        }), (GwtEvent.Type)FocusEvent.getType());
    }

    public List<? extends SuggestOracle.Suggestion> getValue() {
        return new ArrayList(this.suggestionMap.keySet());
    }

    public void setValue(List<? extends SuggestOracle.Suggestion> value, boolean fireEvents) {
        this.clear();
        if (value != null) {
            this.placeholderLabel.addStyleName("active");
            for (SuggestOracle.Suggestion suggestion : value) {
                this.addItem(suggestion);
            }
        }
        super.setValue(value, fireEvents);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.itemBox.setEnabled(enabled);
    }

    public ErrorMixin<AbstractValueWidget, MaterialLabel> getErrorMixin() {
        return this.errorMixin;
    }

    public Label getPlaceholderLabel() {
        return this.placeholderLabel;
    }

    public TextBox getItemBox() {
        return this.itemBox;
    }

    public MaterialLabel getErrorLabel() {
        return this.errorLabel;
    }

    public SuggestBox getSuggestBox() {
        return this.suggestBox;
    }

    public MaterialProgress getProgress() {
        return null;
    }

    static {
        if (MaterialAddins.isDebug()) {
            MaterialDesignBase.injectCss((TextResource)MaterialAutocompleteDebugClientBundle.INSTANCE.autocompleteCssDebug());
        } else {
            MaterialDesignBase.injectCss((TextResource)MaterialAutocompleteClientBundle.INSTANCE.autocompleteCss());
        }
    }
}

