/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.createusers.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.mail.service.MailServiceUtil;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.mail.MailMessage;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.model.Company;
import com.liferay.portal.service.CompanyLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.internet.InternetAddress;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.portlets.admin.createusers.client.HandleUsersService;
import org.gcube.portlets.admin.createusers.shared.VreUserBean;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CreateUsersImpl
extends RemoteServiceServlet
implements HandleUsersService {
    private static final Logger logger = LoggerFactory.getLogger(CreateUsersImpl.class);
    private static final long serialVersionUID = -3124676000683430170L;
    private static final String REGISTERED_USERS_TABLE = "registered_users";
    public static final String userid = "test.user";
    private static final String vreID = "/gcube/devsec/devVRE";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SURNAME = "surname";
    private static final String FIELD_INSTITUTION = "institution_organization";
    private static final String FIELD_REGISTRATION_DATE = "registration_date";
    private static final String FIELD_VRE = "vre";
    public static final String DEFAULT_COMPANY_WEB_ID = "liferay.com";

    public void init() {
        logger.debug("Trying to get connect to liferay's DB from API");
        try {
            Connection con = DataAccess.getConnection();
            logger.debug("Connected!");
            boolean exists = this.tableExists(con);
            if (exists) {
                logger.debug("Table registered_users already exists.");
            } else {
                this.initializeTable(con);
            }
        }
        catch (Exception e) {
            logger.error("Failed to connect to liferay's DB");
            return;
        }
    }

    private boolean tableExists(Connection con) throws SQLException {
        logger.debug("Looking for registered_users table");
        Statement s = con.createStatement();
        ResultSet rs = s.executeQuery("SELECT * FROM  pg_tables where schemaname='public' and  tablename = 'registered_users' ");
        boolean toReturn = rs.next();
        if (toReturn) {
            logger.debug("Auxiliary Table Found! Returning ... ");
        }
        return toReturn;
    }

    private void initializeTable(Connection con) {
        try {
            logger.debug("Creating table registered_users");
            Statement s = con.createStatement();
            s.execute("CREATE TABLE registered_users (id serial primary key, email  varchar(255)  NOT NULL, name varchar(255)  NOT NULL, surname varchar(255)  NOT NULL, institution_organization varchar(255)  DEFAULT NULL, vre varchar(255)  NOT NULL, registration_date TIMESTAMP NOT NULL)");
            logger.debug("registered_users created");
        }
        catch (SQLException e) {
            logger.error("Error while creating table", (Throwable)e);
        }
        try {
            con.close();
        }
        catch (SQLException e1) {
            logger.error("Error while closing connection", (Throwable)e1);
        }
    }

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            logger.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube/devsec/devVRE");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            logger.trace("Development Mode ON");
            return false;
        }
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    public boolean deleteInvitedUser(String email) {
        if (!this.isWithinPortal()) {
            logger.debug("In dev mode.");
            return false;
        }
        try {
            Connection con = DataAccess.getConnection();
            boolean deletedLiferay = this.deleteUserFromLiferay(email);
            boolean deletedTable = this.deleteUserFromTable(email, con);
            return deletedLiferay && deletedTable;
        }
        catch (SQLException e) {
            logger.debug("Error while trying to delete user with email = " + email, (Throwable)e);
            return false;
        }
    }

    public void sendEmailToUser(String email) {
        logger.debug("Sending welcome message to user with email " + email);
        try {
            PortalContext context = PortalContext.getConfiguration();
            String gatewayName = context.getGatewayName(this.getThreadLocalRequest());
            String emailSender = context.getSenderEmail(this.getThreadLocalRequest());
            InternetAddress to = new InternetAddress(email);
            InternetAddress from = new InternetAddress(emailSender);
            LiferayUserManager userManager = new LiferayUserManager();
            String portalUrl = PortalUtil.getPortalURL((String)CreateUsersImpl.getCompany().getVirtualHostname(), (int)443, (boolean)true);
            String username = userManager.getFullNameFromEmail(email);
            MailMessage mailMessage = new MailMessage();
            mailMessage.setFrom(from);
            mailMessage.setTo(to);
            String body = "<p>Dear " + username + ",<br />" + "<br />" + "Welcome! You recently created an account at " + portalUrl + ". Your password is not sent by email for security purposes.<br />" + "<br />" + "Sincerely,<br />" + gatewayName + "<br />" + emailSender + "<br />" + portalUrl;
            String subject = portalUrl + ": Your New Account was created successfully!";
            mailMessage.setBody(body);
            mailMessage.setSubject(subject);
            mailMessage.setHTMLFormat(true);
            MailServiceUtil.sendEmail((MailMessage)mailMessage);
        }
        catch (Exception e) {
            logger.error("Error while sending email to user " + email, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VreUserBean register(String name, String surname, String institution, String email, boolean sendEmail, boolean isMale) {
        long timestamp;
        block24: {
            if (!this.isWithinPortal()) {
                logger.debug("In dev mode.");
                return new VreUserBean(name, surname, institution, email, false, System.currentTimeMillis(), isMale);
            }
            ASLSession session = this.getASLSession();
            String userName = session.getUsername();
            if (userName.compareTo("test.user") == 0) {
                logger.debug("Found " + userName + " returning nothing");
                return null;
            }
            String vre = session.getScopeName();
            timestamp = System.currentTimeMillis();
            LiferayUserManager userManager = new LiferayUserManager();
            boolean exists = userManager.userExistsByEmail(email);
            if (exists) {
                logger.debug("User with this email already present in the portal.");
                return null;
            }
            logger.debug("Trying to add user: " + name + ", " + surname + ", " + email + ", " + institution);
            Connection con = null;
            try {
                con = DataAccess.getConnection();
                String insert = "INSERT into registered_users(email,name,surname,institution_organization,registration_date,vre) values(?, ?, ?, ?, ?, ?)";
                PreparedStatement statement = con.prepareStatement(insert);
                statement.setString(1, email);
                statement.setString(2, name);
                statement.setString(3, surname);
                statement.setString(4, institution);
                statement.setTimestamp(5, new Timestamp(timestamp));
                statement.setString(6, vre);
                int res = statement.executeUpdate();
                if (res != 0) {
                    logger.debug("User added in registered_users");
                    try {
                        GCubeUser user = userManager.createUser(true, "", email, name, "", surname, institution, "", "", isMale, null, null, sendEmail, true);
                        userManager.assignUserToGroup(this.getCurrentGroupID().longValue(), userManager.getUserId(user.getUsername()));
                        this.addUserToHLGroup(user.getUsername(), session.getScope());
                        break block24;
                    }
                    catch (Exception e) {
                        logger.error("Unable to create the user " + email + " in liferay. Removing he/she from the table " + "registered_users", (Throwable)e);
                        this.deleteUserFromTable(email, con);
                        VreUserBean vreUserBean = null;
                        try {
                            if (con != null) {
                                con.close();
                            }
                        }
                        catch (SQLException e2) {
                            logger.error("Unable to close connection to the DB");
                        }
                        return vreUserBean;
                    }
                }
                logger.debug("User NOT added in registered_users");
                VreUserBean vreUserBean = null;
                return vreUserBean;
            }
            catch (Exception e) {
                logger.error("Unable to add user, sorry..", (Throwable)e);
                VreUserBean vreUserBean = null;
                return vreUserBean;
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    logger.error("Unable to close connection to the DB");
                }
            }
        }
        return new VreUserBean(name, surname, institution, email, false, timestamp, isMale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VreUserBean> getAlreadyRegisterdUsers() {
        ArrayList<VreUserBean> toReturn = new ArrayList<VreUserBean>();
        if (!this.isWithinPortal()) {
            logger.debug("In dev mode.");
            toReturn.add(new VreUserBean("Dylan", "Dog", "ISTI-CNR", "dylan.dog@gmail.com", true, System.currentTimeMillis(), true));
            toReturn.add(new VreUserBean("Costantino", "Perciante", "ISTI-CNR", "costantino8@gmail.com", false, System.currentTimeMillis(), true));
            return toReturn;
        }
        LiferayUserManager userManager = new LiferayUserManager();
        ASLSession session = this.getASLSession();
        String userName = session.getUsername();
        if (userName.compareTo("test.user") == 0) {
            logger.debug("Found " + userName + " returning nothing");
            return null;
        }
        String vre = session.getScopeName();
        Connection con = null;
        try {
            con = DataAccess.getConnection();
            Statement stmt = con.createStatement();
            String sql = "SELECT * FROM registered_users WHERE vre='" + vre + "';";
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String name = rs.getString("name");
                String surname = rs.getString("surname");
                String institution = rs.getString("institution_organization");
                String email = rs.getString("email");
                long registrationDate = rs.getTimestamp("registration_date").getTime();
                boolean passwordChanged = userManager.isPasswordChanged(email);
                toReturn.add(new VreUserBean(name, surname, institution, email, passwordChanged, registrationDate, false));
            }
            Iterator iterator = toReturn.iterator();
            while (iterator.hasNext()) {
                VreUserBean user = (VreUserBean)iterator.next();
                if (userManager.userExistsByEmail(user.getEmail())) continue;
                this.deleteUserFromTable(user.getEmail(), con);
                iterator.remove();
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve users list, sorry...", (Throwable)e);
            List<VreUserBean> list = null;
            return list;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                logger.error("Unable to close connection to the DB");
            }
        }
        return toReturn;
    }

    private boolean deleteUserFromTable(String email, Connection con) {
        try {
            logger.debug("Going to delete user with email " + email + " from the table of registered users");
            String remove = "DELETE FROM registered_users WHERE email=  ?";
            PreparedStatement statementDelete = con.prepareStatement(remove);
            statementDelete.setString(1, email);
            int res = statementDelete.executeUpdate();
            if (res == 1) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("Error while deleting user=" + email + "from the table");
        }
        return false;
    }

    private boolean deleteUserFromLiferay(String email) {
        LiferayUserManager userManager = new LiferayUserManager();
        try {
            userManager.deleteUserByEMail(email);
            return true;
        }
        catch (PortalException | SystemException | UserManagementPortalException | UserManagementSystemException e) {
            logger.error("Unable to delete user from liferay", e);
            return false;
        }
    }

    private void addUserToHLGroup(String username, String group) {
        try {
            UserManager um = HomeLibrary.getHomeManagerFactory().getUserManager();
            um.associateUserToGroup(group, username);
        }
        catch (Exception e) {
            logger.error("Failed to get the usermanager from HL. Could not add user to the HL group");
        }
    }

    private Long getCurrentGroupID() {
        ASLSession session = this.getASLSession();
        logger.debug("The current group NAME is --> " + session.getGroupName());
        Long toReturn = null;
        try {
            toReturn = new LiferayGroupManager().getGroupId(session.getGroupName());
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            logger.error("Unable to retrieve id for group " + session.getGroupName());
        }
        return toReturn;
    }

    public static Company getCompany() throws PortalException, SystemException {
        return CompanyLocalServiceUtil.getCompanyByWebId((String)CreateUsersImpl.getDefaultCompanyWebId());
    }

    public static String getDefaultCompanyWebId() {
        String defaultWebId = "";
        try {
            defaultWebId = GetterUtil.getString((String)PropsUtil.get((String)"company.default.web.id"));
        }
        catch (NullPointerException e) {
            logger.error("Cound not find property company.default.web.id in portal.ext file returning default web id: liferay.com");
            return "liferay.com";
        }
        return defaultWebId;
    }
}

