/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredeployer.client.model;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.gcube.portlets.admin.vredeployer.client.VredeployerService;
import org.gcube.portlets.admin.vredeployer.client.VredeployerServiceAsync;
import org.gcube.portlets.admin.vredeployer.client.view.panels.MainContainer;
import org.gcube.portlets.admin.vredeployer.shared.GHNBean;
import org.gcube.portlets.admin.vredeployer.shared.VREDescrBean;

public class Model {
    private VREDescrBean vreDesc;
    private GHNBean[] selectedGHNs;
    private boolean isCloudSelected = false;
    private boolean isCloudAvailable = true;
    private final VredeployerServiceAsync deployerService = (VredeployerServiceAsync)GWT.create(VredeployerService.class);
    private MainContainer mainContainer;

    public Model(MainContainer mainContainer) {
        this.mainContainer = mainContainer;
    }

    public void checkApproveModeEnabled() {
        this.deployerService.isApprovingModeEnabled((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getVREInitialInfo() {
        this.deployerService.getVRE((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getFunctionality() {
        this.deployerService.getFunctionality((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getAvailableGhnList() {
        this.deployerService.getAvailableGHNs((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setGHNsSelected(GHNBean[] selectedGHNs) {
        this.selectedGHNs = selectedGHNs;
        this.isCloudSelected = false;
        String[] selectedIds = new String[selectedGHNs.length];
        for (int i = 0; i < selectedGHNs.length; ++i) {
            selectedIds[i] = selectedGHNs[i].getId();
        }
        this.deployerService.setGHNsSelected(selectedIds, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void checkCloudSelected() {
        this.deployerService.isCloudSelected((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getSummary() {
        this.mainContainer.getCenterPanel().showFinalize(this.vreDesc, this.selectedGHNs, this.isCloudSelected());
        this.mainContainer.getCenterPanel().layout();
    }

    private void applyActionsOnException(Throwable caught) {
        this.mainContainer.getCenterPanel().addText("There was an error on server: " + caught.getMessage());
        this.mainContainer.getCenterPanel().layout();
        this.mainContainer.getCenterPanel().unmask();
    }

    private void applyActionsOnException(String message) {
        this.mainContainer.getCenterPanel().addText("There was an error on server, please try again ina ashort while.");
        this.mainContainer.getCenterPanel().layout();
        this.mainContainer.getCenterPanel().unmask();
    }

    public boolean isCloudSelected() {
        return this.isCloudSelected;
    }

    public void setCloudSelected(boolean isCloudSelected, int virtualMachines) {
        this.isCloudSelected = isCloudSelected;
        this.mainContainer.getEastPanel().mask("Applying settings, please hold", "loading-indicator");
        this.deployerService.setCloudDeploy(virtualMachines, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public VREDescrBean getVreDesc() {
        return this.vreDesc;
    }

    public GHNBean[] getSelectedGHNs() {
        return this.selectedGHNs;
    }

    public void startVREDeploymentStatus() {
        this.mainContainer.getCenterPanel().mask("VRE Deploying, please hold", "loading-indicator");
        this.deployerService.deployVRE((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ MainContainer access$000(Model x0) {
        return x0.mainContainer;
    }

    static /* synthetic */ void access$100(Model x0, Throwable x1) {
        x0.applyActionsOnException(x1);
    }

    static /* synthetic */ VREDescrBean access$202(Model x0, VREDescrBean x1) {
        x0.vreDesc = x1;
        return x0.vreDesc;
    }

    static /* synthetic */ void access$300(Model x0, String x1) {
        x0.applyActionsOnException(x1);
    }

    static /* synthetic */ boolean access$400(Model x0) {
        return x0.isCloudSelected;
    }

    static /* synthetic */ boolean access$402(Model x0, boolean x1) {
        x0.isCloudSelected = x1;
        return x0.isCloudSelected;
    }
}

