/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.vredeployer.server;

import com.extjs.gxt.ui.client.data.ModelData;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.Theme;
import com.liferay.portal.model.User;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.service.ThemeLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.application.framework.vremanagement.vremanagement.impl.VREGeneratorEvo;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.accessmanager.ACLType;
import org.gcube.common.homelibrary.home.workspace.usermanager.UserManager;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.portal.custom.communitymanager.SiteManagerUtil;
import org.gcube.portal.custom.communitymanager.components.GCUBESiteLayout;
import org.gcube.portal.custom.communitymanager.impl.GCubeSiteManagerImpl;
import org.gcube.portlets.admin.vredeployer.client.VredeployerService;
import org.gcube.portlets.admin.vredeployer.client.model.VREFunctionalityModel;
import org.gcube.portlets.admin.vredeployer.server.AdditionalFuncInfo;
import org.gcube.portlets.admin.vredeployer.server.VREDeployerServiceImpl;
import org.gcube.portlets.admin.vredeployer.shared.GHNMemory;
import org.gcube.portlets.admin.vredeployer.shared.GHNProfile;
import org.gcube.portlets.admin.vredeployer.shared.GHNSite;
import org.gcube.portlets.admin.vredeployer.shared.ResourceCategory;
import org.gcube.portlets.admin.vredeployer.shared.ResourceCategoryItem;
import org.gcube.portlets.admin.vredeployer.shared.RunningInstance;
import org.gcube.portlets.admin.vredeployer.shared.VREDeployerStatusType;
import org.gcube.portlets.admin.vredeployer.shared.VREDescrBean;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientCloudReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientDeployReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientFunctionalityDeployReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientFunctionalityReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientResource;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientResourceManagerDeployingReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientResourcesDeployReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.ClientServiceReport;
import org.gcube.portlets.admin.vredeployer.shared.deployreport.DeployStatus;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.gcube.vremanagement.vremodel.cl.stubs.types.FunctionalityItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.GHN;
import org.gcube.vremanagement.vremodel.cl.stubs.types.GHNsPerFunctionality;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceDescriptionItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.ResourceItem;
import org.gcube.vremanagement.vremodel.cl.stubs.types.RunningInstanceMessage;
import org.gcube.vremanagement.vremodel.cl.stubs.types.VREDescription;
import org.gcube.vremanagement.vremodeler.utils.Utils;
import org.gcube.vremanagement.vremodeler.utils.reports.DeployReport;
import org.gcube.vremanagement.vremodeler.utils.reports.FunctionalityReport;
import org.gcube.vremanagement.vremodeler.utils.reports.GHNonCloudReport;
import org.gcube.vremanagement.vremodeler.utils.reports.ServiceReport;
import org.gcube.vremanagement.vremodeler.utils.reports.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class VREDeployerServiceImpl
extends RemoteServiceServlet
implements VredeployerService {
    private static final Logger log = LoggerFactory.getLogger(VREDeployerServiceImpl.class);
    private static final String CALENDAR_APPID = "org.gcube.portal.calendarwrapper.GCubeCalendarHandler";
    private static final String NEWS_FEED_APPID = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";
    protected static final String ORGANIZATION_DEFAULT_LOGO = "/org/gcube/portal/custom/communitymanager/resources/default_logo.png";
    protected static final String ORGANIZATION_DEFAULT_LOGO_URL = "http://ftp.d4science.org/apps/profiles/d4slogo.png";
    private static final int LIFERAY_REGULAR_ROLE_ID = 1;
    private static final String VRE_GENERATOR_ATTRIBUTE = "VREGenerator";
    private static final String GHN_PER_FUNC_ATTRIBUTE = "GHN_PER_FUNC_ATTRIBUTE";
    private static final String HARD_CODED_VO_NAME = "/gcube/devsec";
    private static final String APPROVING_VRE = "approvingVRE";
    public static final String APPROVE_MODE = "approve";
    public static final String EDIT_MODE = "edit";
    public static final String REEDIT_TYPE_ATTRIBUTE = "reeditType";
    public static final String MODE_ATTRIBUTE = "mode";
    private static final String DESCRIPTION = "DESCRIPTION";
    private static final String DEPLOYING = "DEPLOYING";
    private static final String DESIGNER = "Designer";
    private static final String MANAGER = "Manager";
    private static final String VRE_MANAGER = "VRE-Manager";
    private static final String VRE_DESIGNER = "VRE-Designer";
    private boolean isTesting = true;
    String customEPR = "1d648460-2d05-11e3-9f6f-a17a856bd44f";

    private VREGeneratorEvo getVREGeneratorEvo(ASLSession aslSession) {
        log.info("getVREGeneratorEvo called with scope: " + aslSession.getScopeName());
        String vreid = (String)aslSession.getAttribute("VREGenerator");
        if (vreid == null) {
            return null;
        }
        return new VREGeneratorEvo(aslSession, vreid);
    }

    private void setDeployingStatusOn() {
        this.getASLSession().setAttribute("DEPLOYING", (Object)"ON");
    }

    private void setDeployingStatusOff() {
        this.getASLSession().setAttribute("DEPLOYING", null);
    }

    private boolean isDeploying() {
        return this.getASLSession().getAttribute("DEPLOYING") != null;
    }

    private ASLSession getASLSession() {
        log.info("getVREGeneratorEvo  getASLSession() : ");
        HttpSession session = this.getThreadLocalRequest().getSession();
        String username = (String)session.getAttribute("username");
        if (username == null) {
            username = "massimiliano.assante";
            SessionManager.getInstance().getASLSession(session.getId(), username).setScope("/gcube/devsec");
            SessionManager.getInstance().getASLSession(session.getId(), username).setAttribute("reeditType", (Object)"approve");
        } else {
            this.isTesting = false;
        }
        return SessionManager.getInstance().getASLSession(session.getId(), username);
    }

    public VREDeployerStatusType isApprovingModeEnabled() {
        if (this.isTesting) {
            this.setDeployingStatusOff();
            return VREDeployerStatusType.APPROVE;
        }
        if (this.isDeploying()) {
            return VREDeployerStatusType.DEPLOYING;
        }
        log.debug("---  isApprovingModeEnabled in Log   ---");
        ASLSession aslSession = this.getASLSession();
        aslSession.setAttribute("mode", null);
        String reeditType = (String)aslSession.getAttribute("reeditType");
        log.debug("REEDIT_TYPE_ATTRIBUTE = " + reeditType);
        aslSession.setAttribute("reeditType", null);
        if (reeditType != null && reeditType.compareTo("approve") == 0) {
            System.out.println("approvingVRE = true");
            aslSession.setAttribute("mode", (Object)"approvingVRE");
            return VREDeployerStatusType.APPROVE;
        }
        aslSession.setAttribute("VREGenerator", null);
        aslSession.setAttribute("reeditType", null);
        return VREDeployerStatusType.NON_APPROVE;
    }

    public VREDescrBean getVRE() throws NullPointerException {
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
            log.info("VRE EPR: " + vreGenerator.getVREepr());
        }
        VREDescrBean vreDescBean = null;
        log.debug("---   Getting VRE Model   ---");
        try {
            VREDescription sd = vreGenerator.getVREModel();
            vreDescBean = new VREDescrBean(sd.name(), sd.description(), sd.designer(), sd.manager(), sd.startTime().getTime(), sd.endTime().getTime());
            this.getASLSession().setAttribute("Designer", (Object)sd.designer());
            this.getASLSession().setAttribute("Manager", (Object)sd.manager());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        log.debug("Model: " + vreDescBean.getName());
        log.debug("--- END Getting VRE Model ---");
        return vreDescBean;
    }

    private String getFullname(String screenName) {
        LiferayUserManager um = new LiferayUserManager();
        GCubeUser user = null;
        try {
            user = um.getUserByScreenName(screenName);
        }
        catch (UserManagementSystemException e) {
            e.printStackTrace();
        }
        catch (UserRetrievalFault e) {
            e.printStackTrace();
        }
        return user.getFullname();
    }

    public VREFunctionalityModel getFunctionality() {
        VREFunctionalityModel toReturn = new VREFunctionalityModel("", "selected functionality", "", "", false);
        HashMap funCategories = new HashMap();
        List list = null;
        VREGeneratorEvo vreGenerator = null;
        try {
            if (this.isTesting) {
                vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
            } else {
                ASLSession aslSession = this.getASLSession();
                vreGenerator = this.getVREGeneratorEvo(aslSession);
                log.info("VRE EPR: " + vreGenerator.getVREepr());
            }
            list = vreGenerator.getFunctionality();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (list == null) {
            log.warn("FunctionalityList NULL");
            return null;
        }
        for (FunctionalityItem fi : list) {
            log.info(fi.id() + "-" + fi.name());
            VREFunctionalityModel toAdd = new VREFunctionalityModel(Integer.toString(fi.id()), fi.name(), fi.description(), "", fi.selected());
            if (fi.children() == null) continue;
            List children = fi.children();
            ArrayList<VREFunctionalityModel> newchildrens = new ArrayList<VREFunctionalityModel>();
            for (FunctionalityItem child : children) {
                AdditionalFuncInfo addInfo;
                log.info(child.name() + " is " + child.selected());
                if (!child.selected()) continue;
                VREFunctionalityModel subFunc = new VREFunctionalityModel(Integer.toString(child.id()), child.name(), child.description(), "functionality-add-icon", child.selected());
                newchildrens.add(subFunc);
                ArrayList<VREFunctionalityModel> resourceChildren = new ArrayList<VREFunctionalityModel>();
                if (child.selectableResourcesDescription() != null) {
                    for (ResourceDescriptionItem category : child.selectableResourcesDescription()) {
                        if (category.resources() == null) continue;
                        for (ResourceItem resource : category.resources()) {
                            if (!resource.selected()) continue;
                            resourceChildren.add(new VREFunctionalityModel(resource.id(), resource.name(), resource.description(), "extres-icon", resource.selected()));
                        }
                    }
                }
                if ((addInfo = this.getServicesAndGHNs(subFunc.getId())) != null) {
                    RunningInstanceMessage ri;
                    int j;
                    RunningInstanceMessage[] ris = addInfo.getMissingServices();
                    for (j = 0; j < ris.length; ++j) {
                        ri = ris[j];
                        resourceChildren.add(new VREFunctionalityModel("", ri.serviceName() + " (" + ri.serviceClass() + ")", "", "missing-ri", true));
                    }
                    ris = addInfo.getFoundServices();
                    for (j = 0; j < ris.length; ++j) {
                        ri = ris[j];
                        resourceChildren.add(new VREFunctionalityModel("", ri.serviceName() + " (" + ri.serviceClass() + ")", "", "runninginstance-icon", true));
                    }
                    GHN[] relGHNs = addInfo.getGhns();
                    for (int j2 = 0; j2 < relGHNs.length; ++j2) {
                        GHN ghn = relGHNs[j2];
                        resourceChildren.add(new VREFunctionalityModel("", ghn.host() + " (" + ghn.site().domain() + ")", "", "architecture-icon", true));
                    }
                } else {
                    log.error("getServicesAndGHNs per subfunctionality returns NULL");
                }
                subFunc.addChildren(resourceChildren.toArray(new VREFunctionalityModel[resourceChildren.size()]));
            }
            if (newchildrens.size() <= 0) continue;
            toAdd.addChildren(newchildrens.toArray(new VREFunctionalityModel[newchildrens.size()]));
            toReturn.add((ModelData)toAdd);
        }
        for (String func : funCategories.keySet()) {
            System.out.println("-" + func);
            for (ResourceCategory category : (ArrayList)funCategories.get(func)) {
                System.out.println("--" + category.getName());
                for (ResourceCategoryItem rc : category.getItems()) {
                    System.out.println("----" + rc.getName() + " : " + rc.isSelected());
                }
            }
        }
        return toReturn;
    }

    public void getGHNPerFunctionality(String funcId) {
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        int funcToLookFor = Integer.parseInt(funcId);
        try {
            GHNsPerFunctionality[] ghnsPerFunc = vreGenerator.getGHNsPerFunctionality();
            GHNsPerFunctionality toWorkWith = null;
            for (int i = 0; i < ghnsPerFunc.length; ++i) {
                if (funcToLookFor != ghnsPerFunc[i].id()) continue;
                toWorkWith = ghnsPerFunc[i];
                break;
            }
            if (toWorkWith == null) {
                return;
            }
            List services = toWorkWith.foundServices();
            if (services != null) {
                for (RunningInstanceMessage se : services) {
                    System.out.println(se.serviceName() + " - " + se.serviceClass());
                }
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private void setGHNsPerFunctionalityInSession(GHNsPerFunctionality[] ghnsPerFunc) {
        this.getASLSession().setAttribute("GHN_PER_FUNC_ATTRIBUTE", (Object)ghnsPerFunc);
    }

    private GHNsPerFunctionality[] getGHNsPerFunctionalityFromSession() {
        return (GHNsPerFunctionality[])this.getASLSession().getAttribute("GHN_PER_FUNC_ATTRIBUTE");
    }

    private AdditionalFuncInfo getServicesAndGHNs(String funcId) {
        AdditionalFuncInfo toReturn = new AdditionalFuncInfo();
        try {
            GHNsPerFunctionality[] ghnsPerFunc = null;
            if (this.getGHNsPerFunctionalityFromSession() == null) {
                VREGeneratorEvo vreGenerator = null;
                if (this.isTesting) {
                    vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
                } else {
                    ASLSession aslSession = this.getASLSession();
                    vreGenerator = this.getVREGeneratorEvo(aslSession);
                }
                ghnsPerFunc = vreGenerator.getGHNsPerFunctionality();
                this.setGHNsPerFunctionalityInSession(ghnsPerFunc);
            } else {
                ghnsPerFunc = this.getGHNsPerFunctionalityFromSession();
            }
            int funcToLookFor = Integer.parseInt(funcId);
            GHNsPerFunctionality ghnPF = null;
            for (int i = 0; i < ghnsPerFunc.length; ++i) {
                if (funcToLookFor != ghnsPerFunc[i].id()) continue;
                ghnPF = ghnsPerFunc[i];
                break;
            }
            if (ghnPF == null || ghnPF.missingServices() == null) {
                toReturn.setMissingServices(new RunningInstanceMessage[0]);
            } else {
                toReturn.setMissingServices(ghnPF.missingServices().toArray(new RunningInstanceMessage[0]));
            }
            if (ghnPF == null || ghnPF.foundServices() == null) {
                toReturn.setFoundServices(new RunningInstanceMessage[0]);
            } else {
                toReturn.setFoundServices(ghnPF.foundServices().toArray(new RunningInstanceMessage[0]));
            }
            if (ghnPF == null || ghnPF.ghns() == null) {
                toReturn.setGhns(new GHN[0]);
            } else {
                toReturn.setGhns(ghnPF.ghns().toArray(new GHN[0]));
            }
            return toReturn;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<GHNProfile> getAvailableGHNs() {
        ArrayList<GHNProfile> toReturn = new ArrayList<GHNProfile>();
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        List ghns = null;
        try {
            log.debug("Asking gHN list");
            ghns = vreGenerator.getGHNs();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (ghns == null) {
            return toReturn;
        }
        log.debug("got gHN list, menbers: " + ghns.size());
        for (GHN ghn : ghns) {
            ArrayList<RunningInstance> ris = new ArrayList<RunningInstance>();
            if (ghn.relatedRIs() != null) {
                for (int i = 0; i < ghn.relatedRIs().size(); ++i) {
                    ris.add(new RunningInstance(((RunningInstanceMessage)ghn.relatedRIs().get(i)).serviceName(), ((RunningInstanceMessage)ghn.relatedRIs().get(i)).serviceClass()));
                }
            }
            toReturn.add(new GHNProfile(ghn.id(), ghn.host(), ris, ghn.securityEnabled(), new GHNMemory(ghn.memory().memorySize() + "", ghn.memory().diskSpace() + ""), new GHNSite(ghn.site().location(), ghn.site().country(), ghn.site().domain()), null, ghn.selected()));
        }
        return toReturn;
    }

    public boolean setGHNsSelected(String[] selectedGHNIds) {
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        try {
            log.debug(" selectedIDs");
            for (int i = 0; i < selectedGHNIds.length; ++i) {
                System.out.println(" id: " + selectedGHNIds[i].toString());
            }
            vreGenerator.setGHNs(selectedGHNIds);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int isCloudSelected() {
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        if (vreGenerator.isCloudSelected()) {
            return vreGenerator.getCloudVMSelected();
        }
        return -1;
    }

    public int getCloudVMSelected() {
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        return vreGenerator.getCloudVMSelected();
    }

    public boolean setCloudDeploy(int virtualMachines) {
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        return vreGenerator.setCloudDeploy(virtualMachines);
    }

    public boolean deployVRE() {
        log.info("--- deployVRE started ---");
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        try {
            vreGenerator.deployVRE();
            log.info("--- SLEEP 2 seconds ---");
            Thread.sleep(2500L);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public ClientDeployReport checkCreateVRE() {
        log.info("--- check Create VRE started ---");
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            try {
                vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
            }
            catch (NullPointerException e) {
                log.error("Error while trying to contact VRE Modeler service with TEST ID: " + this.customEPR + " Probly does not exist anymore, request from " + this.getThreadLocalRequest().getRemoteHost() + "(" + this.getThreadLocalRequest().getRemoteAddr() + ")");
                return new ClientDeployReport();
            }
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        DeployReport report = null;
        try {
            report = vreGenerator.checkVREStatus();
        }
        catch (Exception e) {
            log.error("Error while trying to retrieve VRE Status, return Empty Report" + e.getMessage() + "\n, " + "request from " + this.getThreadLocalRequest().getRemoteHost() + "(" + this.getThreadLocalRequest().getRemoteAddr() + ")");
            return new ClientDeployReport();
        }
        if (report == null || report.getStatus() == null) {
            log.error("--- DeployReport is NULL or Status is null, return Empty Report, request from " + this.getThreadLocalRequest().getRemoteHost() + "(" + this.getThreadLocalRequest().getRemoteAddr() + ")");
            return new ClientDeployReport();
        }
        if (report.getStatus() == Status.Finished) {
            log.info("--- Create VRE COMPLETED, CREATING LAYOUTS AND COMMUNITY ... ");
            String name = "";
            String description = "";
            try {
                VREDescription de = vreGenerator.getVREModel();
                name = de.name();
                description = de.description();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            String designer = (String)this.getASLSession().getAttribute("Designer");
            String manager = (String)this.getASLSession().getAttribute("Manager");
            log.info("ADDING user designer and manager, found designer: " + designer + " found manager: " + manager);
            long vreCreatedId = this.createCommunityAndLayoutAndHLFolder(name, description);
            log.info("---  createCommunityAndLayout COMPLETED, vreCreatedId=" + vreCreatedId);
            if (vreCreatedId > 0L) {
                try {
                    GCubeGroup vreCreated = new LiferayGroupManager().getGroup(vreCreatedId);
                    log.info("---  CREATED LAYOUTS AND COMMUNITY OK, updating Calendar Application Profile.");
                    String vreScope = new LiferayGroupManager().getInfrastructureScope(vreCreatedId);
                    String vreUrl = "/group/" + vreCreated.getGroupName().toLowerCase();
                    boolean calandarAppProfileUpdated = false;
                    try {
                        calandarAppProfileUpdated = this.updateApplicationProfile("org.gcube.portal.calendarwrapper.GCubeCalendarHandler", vreScope, vreUrl + "/calendar");
                    }
                    catch (Exception e) {
                        log.error("Something wrong in updateApplicationProfile for org.gcube.portal.calendarwrapper.GCubeCalendarHandler");
                    }
                    boolean newsFeedAppProfileUpdated = false;
                    try {
                        newsFeedAppProfileUpdated = this.updateApplicationProfile("org.gcube.portlets.user.newsfeed.server.NewsServiceImpl", vreScope, vreUrl);
                    }
                    catch (Exception e) {
                        log.error("Something wrong in updateApplicationProfile for org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
                    }
                    log.info("updateApplicationProfile for org.gcube.portal.calendarwrapper.GCubeCalendarHandler=" + calandarAppProfileUpdated);
                    log.info("updateApplicationProfile for org.gcube.portlets.user.newsfeed.server.NewsServiceImpl=" + newsFeedAppProfileUpdated);
                    LiferayUserManager um = new LiferayUserManager();
                    GCubeUser userDesigner = um.getUserByUsername(designer);
                    GCubeUser userManager = um.getUserByUsername(manager);
                    Workspace workspace = HomeLibrary.getUserWorkspace((String)this.getASLSession().getUsername());
                    ArrayList<String> toSend = new ArrayList<String>();
                    toSend.add(designer);
                    String subject = "Definition approved and deployed";
                    String body = "Dear " + userDesigner.getFirstName() + ", \n\n" + userManager.getFullname() + " has approved the deployment of the group you requested: " + name + ".";
                    body = body + ".\n\nThis group has been deployed successfully and is already available for you on this portal. Please, check your list.";
                    String messageId = workspace.getWorkspaceMessageManager().sendMessageToPortalLogins(subject, body, new ArrayList(), toSend);
                    ApplicationNotificationsManager nnm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), this.getASLSession().getScope(), new SocialNetworkingUser(this.getASLSession().getUsername(), this.getASLSession().getUserEmailAddress(), this.getASLSession().getUserFullName(), ""));
                    if (nnm.notifyMessageReceived(designer, messageId, subject, body, new String[0])) {
                        log.trace("Sending Definition create notification: " + subject + " OK");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                log.error("---  DANGER DANGER DANGER!!!!! -> CREATED LAYOUTS AND COMMUNITY WITH ERRORS");
            }
        } else {
            this.setDeployingStatusOn();
        }
        log.debug("---Sending Report, globalState --- " + report.getStatus());
        return this.convertServiceDeployReport(report);
    }

    private boolean updateApplicationProfile(String appId, String vreScope, String vreURL) {
        String currScope = ScopeProvider.instance.get();
        String scopeToQuery = PortalContext.getConfiguration().getInfrastructureName();
        ScopeProvider.instance.set("/" + scopeToQuery);
        String endpoint2Add = "<EndPoint><Scope>" + vreScope + "</Scope><URL>" + vreURL + "</URL></EndPoint>";
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'ApplicationProfile'");
        query.addCondition("$resource/Profile/Body/AppId/text() eq '" + appId + "'");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List list = client.submit((Query)query);
        if (list == null || list.isEmpty()) {
            log.warn("Cannot retrieve the ApplicationProfile from IS for generic resource having  <Body><AppId> = " + appId);
            log.info("Triggering Creation of ApplicationProfile for " + appId);
            GenericResource toCreate = new GenericResource();
            toCreate.newProfile().name("Application Profile for " + appId);
            toCreate.profile().type("ApplicationProfile");
            toCreate.profile().description("Application Profile description for " + appId);
            toCreate.profile().newBody("<AppId>" + appId + "</AppId><ThumbnailURL>No thumbnail</ThumbnailURL>" + endpoint2Add);
            RegistryPublisher rp = RegistryPublisherFactory.create();
            rp.create((Resource)toCreate);
            log.info("Creation of ApplicationProfile for " + appId + " OK!");
            return false;
        }
        GenericResource gr = (GenericResource)list.get(0);
        log.debug("updating ApplicationProfile for " + gr.profile().name());
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Element elem = gr.profile().body();
            Node fragmentNode = docBuilder.parse(new InputSource(new StringReader(endpoint2Add))).getDocumentElement();
            fragmentNode = elem.getOwnerDocument().importNode(fragmentNode, true);
            elem.appendChild(fragmentNode);
        }
        catch (Exception e) {
            log.error("error");
        }
        RegistryPublisher rp = RegistryPublisherFactory.create();
        rp.update((Resource)gr);
        ScopeProvider.instance.set(currScope);
        return true;
    }

    private void createVRESharedGroupFolder(GCubeGroup vreCreated, String designer, String manager, String description) throws Exception {
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set("/" + VREDeployerServiceImpl.getRootOrganizationName());
        LiferayGroupManager gm = new LiferayGroupManager();
        LiferayUserManager um = new LiferayUserManager();
        GCubeGroup group = vreCreated;
        long groupId = group.getGroupId();
        String vreName = group.getGroupName();
        String vreScope = gm.getInfrastructureScope(groupId);
        List users = um.listUsersByGroup(group.getGroupId());
        String vreDesignerUserName = designer;
        if (vreDesignerUserName != null) {
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome(vreDesignerUserName).getWorkspace();
            org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup gGroup = VREDeployerServiceImpl.createGroup((String)vreScope, (List)users);
            String groupid = gGroup == null ? vreScope : gGroup.getName();
            WorkspaceSharedFolder wSharedFolder = VREDeployerServiceImpl.createVREFolder((String)vreScope, (String)vreName, (String)groupid, (Workspace)ws);
            ArrayList<String> groups = new ArrayList<String>();
            groups.add(gGroup.getName());
            wSharedFolder.setACL(groups, ACLType.WRITE_OWNER);
        } else {
            log.error("NO VRE-MANAGER FOUND IN THIS VRE");
        }
        ScopeProvider.instance.set(currScope);
    }

    private static String getRootOrganizationName() {
        return PortalContext.getConfiguration().getInfrastructureName();
    }

    private static WorkspaceSharedFolder createVREFolder(String vreScope, String vreName, String groupId, Workspace ws) throws Exception {
        WorkspaceSharedFolder folder = ws.createSharedFolder(vreScope, "Special Shared folder for VRE " + vreName, groupId, ws.getRoot().getId(), vreName, true);
        System.out.println(folder.getPath());
        return folder;
    }

    private static org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup createGroup(String vreScope, List<GCubeUser> usersToAdd) throws InternalErrorException {
        UserManager gm = HomeLibrary.getHomeManagerFactory().getUserManager();
        org.gcube.common.homelibrary.home.workspace.usermanager.GCubeGroup group = gm.createGroup(vreScope);
        for (GCubeUser user : usersToAdd) {
            group.addMember(user.getUsername());
        }
        return group;
    }

    public String getHTMLReport() {
        log.info("--- getHTMLReport VRE  ---");
        VREGeneratorEvo vreGenerator = null;
        if (this.isTesting) {
            vreGenerator = new VREGeneratorEvo(this.getASLSession(), this.customEPR);
        } else {
            ASLSession aslSession = this.getASLSession();
            vreGenerator = this.getVREGeneratorEvo(aslSession);
        }
        String report = null;
        try {
            report = Utils.toXML((DeployReport)vreGenerator.checkVREStatus());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        String startDirectory = this.getServletContext().getRealPath("");
        String xslFileLocation = startDirectory + "/styles/report.xsl";
        String transformed = "";
        if (this.isTesting) {
            String pathXML = startDirectory + "/xml/report.xml";
            log.info("--- pathXML: " + pathXML);
            log.info("--- xsl: " + xslFileLocation);
            transformed = this.transformToHtml(this.fileToString(pathXML), xslFileLocation);
        } else {
            transformed = this.transformToHtml(report, xslFileLocation);
        }
        return transformed;
    }

    private ClientDeployReport convertServiceDeployReport(DeployReport toConvert) {
        ClientDeployReport toReturn = new ClientDeployReport();
        toReturn.setGlobalStatus(this.convStatus(toConvert.getStatus()));
        GHNonCloudReport cDeploy = toConvert.getCloudDeployingReport();
        if (this.isCloudSelected() != -1) {
            System.out.println("***** GHNonCloudReportSelected ******");
            LinkedList<DeployStatus> singleCloudStatus = new LinkedList<DeployStatus>();
            for (int i = 0; i < cDeploy.getDeployingState().length; ++i) {
                singleCloudStatus.add(this.convStatus(cDeploy.getDeployingState()[i]));
            }
            toReturn.setCloudReport(new ClientCloudReport(this.convStatus(cDeploy.getStatus()), singleCloudStatus));
        } else {
            System.out.println("***** GHNonCloudReport Not Selected ******");
            ClientCloudReport cdp = new ClientCloudReport();
            cdp.setStatus(DeployStatus.SKIP);
            toReturn.setCloudReport(cdp);
        }
        toReturn.setResourceManagerReport(new ClientResourceManagerDeployingReport(this.convStatus(toConvert.getResourceDeployingReport().getStatus()), toConvert.getResourceDeployingReport().toString()));
        ClientFunctionalityDeployReport cfDeployReport = new ClientFunctionalityDeployReport();
        Hashtable table = toConvert.getFunctionalityDeployingReport().getFunctionalityTable();
        HashMap newTable = new HashMap();
        for (FunctionalityReport fr : table.keySet()) {
            LinkedList<ClientServiceReport> theList = new LinkedList<ClientServiceReport>();
            for (ServiceReport sr : (List)table.get(fr)) {
                theList.add(new ClientServiceReport(sr.getServiceName(), sr.getServiceClass(), sr.getServiceVersion()));
            }
            newTable.put(new ClientFunctionalityReport(fr.getFunctionalityId(), fr.getFunctionalityName(), this.convStatus(fr.getState())), theList);
        }
        cfDeployReport.setStatus(this.convStatus(toConvert.getFunctionalityDeployingReport().getStatus()));
        cfDeployReport.setReportXML(toConvert.getFunctionalityDeployingReport().getResourceManagerReport());
        cfDeployReport.setFunTable(newTable);
        toReturn.setFunctionalityReport(cfDeployReport);
        LinkedList<ClientResource> newResources = new LinkedList<ClientResource>();
        for (org.gcube.vremanagement.vremodeler.utils.reports.Resource res : toConvert.getResourceDeployingReport().getResources()) {
            newResources.add(new ClientResource(res.getResourceId(), res.getResourceType(), this.convStatus(res.getStatus())));
        }
        toReturn.setResourcesReport(new ClientResourcesDeployReport(this.convStatus(toConvert.getResourceDeployingReport().getStatus()), newResources));
        return toReturn;
    }

    private DeployStatus convStatus(Status status) {
        switch (1.$SwitchMap$org$gcube$vremanagement$vremodeler$utils$reports$Status[status.ordinal()]) {
            case 1: {
                return DeployStatus.FAIL;
            }
            case 2: {
                return DeployStatus.FINISH;
            }
            case 3: {
                return DeployStatus.PENDING;
            }
            case 4: {
                return DeployStatus.RUN;
            }
            case 5: {
                return DeployStatus.SKIP;
            }
            case 6: {
                return DeployStatus.WAIT;
            }
        }
        return DeployStatus.FAIL;
    }

    private boolean vreExists(String vreName) {
        LiferayGroupManager gm = new LiferayGroupManager();
        try {
            return gm.getGroupId(vreName) >= 0L;
        }
        catch (GroupRetrievalFault | UserManagementSystemException e) {
            return false;
        }
    }

    private long createCommunityAndLayoutAndHLFolder(String vreName, String description) {
        if (this.vreExists(vreName)) {
            log.warn("VRE Exists already");
            return -1L;
        }
        ASLSession session = this.getASLSession();
        log.info("TRYING READING CURRENT VO ID");
        LiferayGroupManager gm = new LiferayGroupManager();
        long parentVirtualOrganizationId = -1L;
        try {
            parentVirtualOrganizationId = gm.getGroupIdFromInfrastructureScope(session.getScope());
        }
        catch (IllegalArgumentException | GroupRetrievalFault | UserManagementSystemException e1) {
            e1.printStackTrace();
        }
        log.info("CURRENT VO ID=" + parentVirtualOrganizationId);
        String desc = session.getAttribute("DESCRIPTION") == null ? "No Description found" : session.getAttribute("DESCRIPTION").toString();
        String designer = (String)session.getAttribute("Designer");
        log.info("Designer found Name : " + designer);
        String manager = (String)session.getAttribute("Manager");
        log.info("Manager found Name : " + manager);
        try {
            long roleId;
            long userId;
            String themid = "";
            themid = SiteManagerUtil.getgCubeThemeId((String)"gcubeportaltheme");
            log.info("Assigning theme with id: " + themid + " to VRE in creation");
            GCUBESiteLayout siteLayout = GCubeSiteManagerImpl.getBaseLayout((String)vreName, (boolean)false, (String)session.getUsername());
            GCubeGroup vreCreated = gm.createVRE(vreName, parentVirtualOrganizationId, desc);
            long groupId = vreCreated.getGroupId();
            Group lrGroup = GroupLocalServiceUtil.getGroup((long)groupId);
            GCubeUser userBean = new LiferayUserManager().getUserByUsername(session.getUsername());
            User lrUser = UserLocalServiceUtil.getUser((long)userBean.getUserId());
            SiteManagerUtil.createLayout((Group)lrGroup, (User)lrUser, (GCUBESiteLayout)siteLayout);
            Theme themeToApply = ThemeLocalServiceUtil.getTheme((long)SiteManagerUtil.getCompany().getCompanyId(), (String)themid, (boolean)false);
            LayoutSetLocalServiceUtil.updateLookAndFeel((long)groupId, (String)themeToApply.getThemeId(), (String)"", (String)"", (boolean)false);
            log.debug("LayoutSet Theme with id " + themid + " Applied Correctly");
            log.info("Assigned theme with id: " + themid + " to groupid: " + groupId);
            LiferayUserManager uman = new LiferayUserManager();
            String currUser = session.getUsername();
            log.info("***Username of who triggered the creation is: " + currUser);
            log.info("Trying to create VRE Group Folder through HomeLibrary ...");
            this.createVRESharedGroupFolder(vreCreated, designer, manager, description);
            log.info("--- createVRESharedGroupFolder OK, sending Message to designer.");
            LiferayRoleManager rm = new LiferayRoleManager();
            if (manager.compareTo(currUser) != 0) {
                userId = uman.getUserId(manager);
                uman.assignUserToGroup(groupId, userId);
                log.info("Added manager " + manager + " to group " + vreName + " with Success");
                log.info("Assigning Role:  VRE-Manager");
                roleId = rm.getRoleIdByName("VRE-Manager");
                rm.assignRoleToUser(userId, groupId, roleId);
                log.info("Admin Role VRE-Manager Associated to user " + manager + " .... returning ...");
            }
            if (designer.compareTo(manager) != 0) {
                userId = uman.getUserId(designer);
                uman.assignUserToGroup(groupId, userId);
                log.info("Added designer " + designer + " to group " + vreName + " with Success");
                roleId = rm.getRoleIdByName("VRE-Designer");
                rm.assignRoleToUser(userId, groupId, roleId);
                log.info("Admin Role VRE-Designer Associated to user " + designer + " .... returning ...");
            }
            return groupId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    private String getGlobalDeploymentStatus(String report) {
        String ret = "NOT FINISHED";
        return ret;
    }

    private String transformToHtml(String profile, String xslFile) {
        File stylesheet = new File(xslFile);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        StreamSource stylesource = new StreamSource(stylesheet);
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer(stylesource);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            return "";
        }
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return "";
        }
        StringReader reader = new StringReader(profile);
        InputSource inputSource = new InputSource(reader);
        log.debug("***** --- Reading **** ");
        try {
            document = builder.parse(inputSource);
        }
        catch (SAXException e) {
            log.error("***** --- ERROR PARSING REPORT SAXException--- **** ");
            log.error("CHECK THIS: \n" + profile);
            e.printStackTrace();
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(resultStream);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
            return "";
        }
        return resultStream.toString();
    }

    private DeployReport simulateReport() {
        DeployReport reportToReturn = new DeployReport();
        return reportToReturn;
    }

    private String fileToString(String path) {
        BufferedReader filebuf = null;
        String nextStr = null;
        StringBuilder ret = new StringBuilder();
        try {
            filebuf = new BufferedReader(new FileReader(path));
            nextStr = filebuf.readLine();
            while (nextStr != null) {
                ret.append(nextStr);
                nextStr = filebuf.readLine();
            }
            filebuf.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return ret.toString();
    }
}

