/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.admin.wfdocviewer.server;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PermissionLocalServiceUtil;
import com.liferay.portal.service.ResourceLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntry;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlets.admin.wfdocslibrary.shared.PermissionType;
import org.gcube.portlets.admin.wfdocslibrary.shared.Step;
import org.gcube.portlets.admin.wfdocslibrary.shared.WfRole;
import org.gcube.portlets.admin.wfdocviewer.server.DocLibraryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DocLibraryUtil {
    public static final String WORKFLOWS_FOLDER = "Workflow Documents";
    private static final Logger log = LoggerFactory.getLogger(DocLibraryUtil.class);

    public static boolean writeFileIntoDocLibrary(ASLSession session, List<Role> roles, Step start, String fileName, byte[] buffer) {
        long docfolderid = -1L;
        try {
            docfolderid = DocLibraryUtil.getWfFolder((ASLSession)session);
            long userId = DocLibraryUtil.getUserId((ASLSession)session);
            DLFileEntry fileEntry = DLFileEntryLocalServiceUtil.addFileEntry((long)userId, (long)DocLibraryUtil.getGroupID((ASLSession)session), (long)docfolderid, (String)fileName, (String)fileName, (String)"workflow document", (String)"", (String)"", (byte[])buffer, (ServiceContext)new ServiceContext());
            log.debug("Wrote file into DocumentLibrary");
            long resourceId = ResourceLocalServiceUtil.getResource((long)fileEntry.getCompanyId(), (String)DLFileEntry.class.getName(), (int)4, (String)String.valueOf(fileEntry.getFileEntryId())).getResourceId();
            for (Role role : roles) {
                String[] actionIds = DocLibraryUtil.getPermissionsFromWfStep((Role)role, (Step)start);
                PermissionLocalServiceUtil.setRolePermissions((long)role.getRoleId(), (String[])actionIds, (long)resourceId);
                log.debug("set the permissions for Role: " + role.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        log.debug(" WROTE INTO DOCsLib and addigne permissions for name: " + fileName);
        return true;
    }

    public static boolean deleteFileFromDocLibrary(ASLSession session, String workflowid) {
        DLFileEntry fileEntry = null;
        try {
            fileEntry = DocLibraryUtil.getFileEntry((ASLSession)session, (String)workflowid);
            DLFileEntryLocalServiceUtil.deleteDLFileEntry((DLFileEntry)fileEntry);
            log.debug("Deleted");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static DLFileEntry getFileEntry(ASLSession session, String workflowid) throws PortalException, SystemException, Exception {
        String titleWithExtension = workflowid + ".zip";
        return DLFileEntryLocalServiceUtil.getFileEntryByTitle((long)DocLibraryUtil.getGroupID((ASLSession)session), (long)DocLibraryUtil.getWfFolder((ASLSession)session), (String)titleWithExtension);
    }

    private static String[] getPermissionsFromWfStep(Role role, Step step) {
        ArrayList toConvert = new ArrayList();
        for (WfRole steprole : step.getPermissions().keySet()) {
            System.out.println("Steprole: " + steprole.getRolename());
            String name = role.getName().split("_")[0];
            System.out.println("role Name: " + name);
            if (!steprole.getRolename().equals(name)) continue;
            toConvert = (ArrayList)step.getPermissions().get(steprole);
        }
        String[] toReturn = new String[toConvert.size()];
        int i = 0;
        for (PermissionType p : toConvert) {
            toReturn[i] = DocLibraryUtil.getLRActionIdFromWfPermissionType((PermissionType)p);
            ++i;
        }
        return toReturn;
    }

    public static long getWfFolder(ASLSession session) throws Exception {
        long parentFolderId = 0L;
        DLFolder folder = null;
        if (!DocLibraryUtil.wfFolderExists((ASLSession)session)) {
            folder = DLFolderLocalServiceUtil.addFolder((long)DocLibraryUtil.getUserId((ASLSession)session), (long)DocLibraryUtil.getGroupID((ASLSession)session), (long)parentFolderId, (String)"Workflow Documents", (String)"Folder for Workflow Documents", (ServiceContext)new ServiceContext());
            log.debug("Folder for WorkflowDocs created: /Workflow Documents");
        } else {
            folder = DLFolderLocalServiceUtil.getFolder((long)DocLibraryUtil.getGroupID((ASLSession)session), (long)parentFolderId, (String)"Workflow Documents");
        }
        return folder.getFolderId();
    }

    public static boolean wfFolderExists(ASLSession session) {
        try {
            long groupid = DocLibraryUtil.getGroupID((ASLSession)session);
            long parentfolder = 0L;
            return DLFolderLocalServiceUtil.getFolder((long)groupid, (long)parentfolder, (String)"Workflow Documents") != null;
        }
        catch (NoSuchFolderException ex) {
            log.debug("Folder does not exists");
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long getGroupID(ASLSession session) throws PortalException, SystemException {
        long organizationid = session.getGroupId();
        Organization myOrg = OrganizationLocalServiceUtil.getOrganization((long)organizationid);
        return myOrg.getGroup().getGroupId();
    }

    public static long getCompanyID() throws PortalException, SystemException {
        return OrganizationsUtil.getCompany().getCompanyId();
    }

    public static List<DLFolder> getFolders(ASLSession session) throws SystemException, PortalException {
        long companyid = DocLibraryUtil.getCompanyID();
        List folders = null;
        folders = DLFolderLocalServiceUtil.getFolders((long)companyid);
        for (DLFolder folder : folders) {
            log.debug("Folder name: " + folder.getName() + " ID: " + folder.getFolderId() + " Parent: " + folder.getParentFolderId() + " Groupid: " + folder.getGroupId());
        }
        return folders;
    }

    public static long getUserId(ASLSession session) {
        List users = null;
        long userId = 0L;
        try {
            users = UserLocalServiceUtil.getUsers((int)0, (int)UserLocalServiceUtil.getUsersCount());
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        for (User user : users) {
            if (!user.getScreenName().equalsIgnoreCase(session.getUsername())) continue;
            userId = user.getUserId();
            break;
        }
        return userId;
    }

    private static String getLRActionIdFromWfPermissionType(PermissionType type) {
        switch (1.$SwitchMap$org$gcube$portlets$admin$wfdocslibrary$shared$PermissionType[type.ordinal()]) {
            case 1: {
                return "PERMISSIONS";
            }
            case 2: {
                return "VIEW";
            }
            case 3: {
                return "UPDATE";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "ADD_DISCUSSION";
            }
            case 6: {
                return "DELETE_DISCUSSION";
            }
            case 7: {
                return "UPDATE_DISCUSSION";
            }
        }
        return "";
    }
}

