/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.sdmxsource.sdmx.api.constants.DATA_TYPE;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.engine.SchemaWriterEngine;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.factory.SchemaWriterFactory;
import org.sdmxsource.sdmx.api.model.format.SchemaFormat;
import org.sdmxsource.sdmx.dataparser.engine.impl.CompactSchemaWriterEngine;
import org.sdmxsource.sdmx.dataparser.engine.impl.GenericSchemaWriterEngine;
import org.sdmxsource.sdmx.dataparser.engine.impl.UtilitySchemaWriterEngine;
import org.sdmxsource.sdmx.dataparser.model.SdmxSchemaFormat;
import org.sdmxsource.util.resourceBundle.PropertiesToMap;

public class SdmxSchemaWriterFactory
implements SchemaWriterFactory {
    private Map<SDMX_SCHEMA, String> schemaLocationMap = new HashMap<SDMX_SCHEMA, String>();

    public SchemaWriterEngine getSchemaWriterEngine(SchemaFormat format) {
        if (format instanceof SdmxSchemaFormat) {
            DATA_TYPE dataType = ((SdmxSchemaFormat)format).getDataType();
            return this.getWriterEngine(dataType);
        }
        return null;
    }

    private SchemaWriterEngine getWriterEngine(DATA_TYPE schema) {
        SDMX_SCHEMA schemaVersion = schema.getSchemaVersion();
        switch (schema.getBaseDataFormat()) {
            case GENERIC: {
                return new GenericSchemaWriterEngine(schemaVersion);
            }
            case COMPACT: {
                return new CompactSchemaWriterEngine(this.schemaLocationMap.get(schemaVersion), schemaVersion);
            }
            case UTILITY: {
                if (schemaVersion == SDMX_SCHEMA.VERSION_TWO) {
                    return new UtilitySchemaWriterEngine(schemaVersion);
                }
                throw new IllegalArgumentException("Can not create utility schema in version '" + schemaVersion + "' only version 2.0 supported");
            }
        }
        throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Schema generation for format " + schema.getBaseDataFormat()});
    }

    public void setSchemaLocationProperties(Properties properties) {
        Map propsMap = PropertiesToMap.createMap((Properties)properties);
        for (String schemaVersion : propsMap.keySet()) {
            this.schemaLocationMap.put(SDMX_SCHEMA.valueOf((String)schemaVersion), (String)propsMap.get(schemaVersion));
        }
    }
}

