/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2;

import java.util.Collection;
import org.sdmx.resources.sdmxml.schemas.v20.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceDocument;
import org.sdmx.resources.sdmxml.schemas.v20.message.RegistryInterfaceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.DatasourceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ProvisionAgreementRefType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryRegistrationResponseType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryResultType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.QueryableDatasourceType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.ResultType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusMessageType;
import org.sdmx.resources.sdmxml.schemas.v20.registry.StatusType;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.AbstractResponseBuilder;
import org.sdmxsource.sdmx.structureparser.builder.xmlBeans.registry.response.impl.v2.V2Helper;
import org.sdmxsource.util.ObjectUtil;

public class QueryRegistrationResponseBuilderV2
extends AbstractResponseBuilder {
    public static QueryRegistrationResponseBuilderV2 INSTANCE = new QueryRegistrationResponseBuilderV2();

    private QueryRegistrationResponseBuilderV2() {
    }

    public RegistryInterfaceDocument buildErrorResponse(Throwable th) {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryRegistrationResponseType returnType = regInterface.addNewQueryRegistrationResponse();
        V2Helper.setHeader(regInterface);
        QueryResultType queryResult = returnType.addNewQueryResult();
        queryResult.setTimeSeriesMatch(false);
        StatusMessageType statusMessage = queryResult.addNewStatusMessage();
        this.addStatus(statusMessage, th);
        return responseType;
    }

    public RegistryInterfaceDocument buildSuccessResponse(Collection<RegistrationBean> registrations) {
        RegistryInterfaceDocument responseType = RegistryInterfaceDocument.Factory.newInstance();
        RegistryInterfaceType regInterface = responseType.addNewRegistryInterface();
        QueryRegistrationResponseType returnType = regInterface.addNewQueryRegistrationResponse();
        V2Helper.setHeader(regInterface);
        if (!ObjectUtil.validCollection(registrations)) {
            QueryResultType queryResult = returnType.addNewQueryResult();
            queryResult.setTimeSeriesMatch(false);
            StatusMessageType statusMessage = queryResult.addNewStatusMessage();
            statusMessage.setStatus(StatusType.WARNING);
            TextType tt = statusMessage.addNewMessageText();
            tt.setStringValue("No Registrations Match The Query Parameters");
        } else {
            for (RegistrationBean currentRegistration : registrations) {
                QueryResultType queryResult = returnType.addNewQueryResult();
                StatusMessageType statusMessage = queryResult.addNewStatusMessage();
                this.addStatus(statusMessage, null);
                queryResult.setTimeSeriesMatch(false);
                ResultType resultType = queryResult.addNewDataResult();
                if (currentRegistration.getDataSource() != null) {
                    DataSourceBean datasourceBean = currentRegistration.getDataSource();
                    DatasourceType datasourceType = resultType.addNewDatasource();
                    if (datasourceBean.isSimpleDatasource()) {
                        datasourceType.setSimpleDatasource(datasourceBean.getDataUrl().toString());
                    } else {
                        QueryableDatasourceType queryableDatasource = datasourceType.addNewQueryableDatasource();
                        queryableDatasource.setIsRESTDatasource(datasourceBean.isRESTDatasource());
                        queryableDatasource.setIsWebServiceDatasource(datasourceBean.isWebServiceDatasource());
                        queryableDatasource.setDataUrl(datasourceBean.getDataUrl().toString());
                        if (datasourceBean.getWSDLUrl() != null) {
                            queryableDatasource.setWSDLUrl(datasourceBean.getWSDLUrl().toString());
                        }
                    }
                }
                if (currentRegistration.getProvisionAgreementRef() == null) continue;
                this.writeProvisionAgreementRef(currentRegistration.getProvisionAgreementRef(), resultType);
            }
        }
        return responseType;
    }

    private void writeProvisionAgreementRef(CrossReferenceBean provRefBean, ResultType resultType) {
        ProvisionAgreementRefType provRef = resultType.addNewProvisionAgreementRef();
        if (provRefBean.getTargetUrn() != null) {
            provRef.setURN(provRefBean.getTargetUrn());
        }
    }
}

