/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.leaf;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.MultivaluedExpression;
import org.gcube.data.analysis.tabulardata.expression.leaf.LeafExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDTypeValue;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ConstantList
extends LeafExpression
implements MultivaluedExpression {
    private static final long serialVersionUID = -1479945639810020364L;
    private List<TDTypeValue> arguments = null;

    private ConstantList() {
    }

    public ConstantList(List<TDTypeValue> arguments) {
        this.arguments = arguments;
    }

    @Override
    public DataType getReturnedDataType() {
        return this.arguments.get(0).getReturnedDataType();
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.arguments == null) {
            throw new MalformedExpressionException("ConstantList arguments cannot be null. " + this);
        }
        if (this.arguments.size() < 2) {
            throw new MalformedExpressionException("ConstantList needs at least 2 arguments. " + this);
        }
        DataType type = null;
        for (TDTypeValue val : this.arguments) {
            if (val == null) {
                throw new MalformedExpressionException("ConstantList cannot contain null values. " + this);
            }
            if (type == null) {
                type = val.getReturnedDataType();
            } else {
                DataType current = val.getReturnedDataType();
                if (!type.getClass().equals(current.getClass())) {
                    throw new MalformedExpressionException(String.format("ConstantList cannot contain different data types: found %s expected %s", current, type));
                }
            }
            val.validate();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantList other = (ConstantList)obj;
        return !(this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConstantList [arguments=");
        builder.append(this.arguments);
        builder.append("]");
        return builder.toString();
    }

    public List<TDTypeValue> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<TDTypeValue> arguments) {
        this.arguments = arguments;
    }
}

