/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.SimpleEventBus;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.gcube.portlets.user.tdwx.client.TabularDataXController;
import org.gcube.portlets.user.tdwx.client.TabularDataXGridPanel;
import org.gcube.portlets.user.tdwx.client.event.CloseTableEvent;
import org.gcube.portlets.user.tdwx.client.event.FailureEvent;
import org.gcube.portlets.user.tdwx.client.event.GridReadyEvent;
import org.gcube.portlets.user.tdwx.client.event.OpenTableEvent;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;
import org.gcube.portlets.user.tdwx.shared.model.TableId;

public class TabularDataX {
    private static int seed = 0;
    private int tdSessionId = seed++;
    private String defaultDataSourceFactoryName;
    private EventBus eventBus;
    private TabularDataXController controller;
    private TabularDataXGridPanel gridPanel;

    public TabularDataX(String defaultDataSourceFactoryName) {
        this.defaultDataSourceFactoryName = defaultDataSourceFactoryName;
        this.eventBus = new SimpleEventBus();
        this.controller = new TabularDataXController(this.tdSessionId, this.eventBus);
    }

    public TabularDataX() {
        this(null);
    }

    public String getDefaultDataSourceFactoryName() {
        return this.defaultDataSourceFactoryName;
    }

    public void setDefaultDataSourceFactoryName(String defaultDataSourceFactoryName) {
        this.defaultDataSourceFactoryName = defaultDataSourceFactoryName;
    }

    public TabularDataXGridPanel getGridPanel() {
        if (this.gridPanel == null) {
            this.gridPanel = new TabularDataXGridPanel(this.tdSessionId, this.eventBus);
        }
        return this.gridPanel;
    }

    public void addFailureHandler(FailureEvent.FailureEventHandler handler) {
        this.eventBus.addHandler(FailureEvent.TYPE, (EventHandler)handler);
    }

    public void addGridReadyHandler(GridReadyEvent.GridReadyEventHandler handler) {
        this.eventBus.addHandler(GridReadyEvent.TYPE, (EventHandler)handler);
    }

    public void openTable(TableId id) {
        Log.trace((String)("openTable id: " + id));
        this.eventBus.fireEvent((GwtEvent)new OpenTableEvent(id));
    }

    public void openTable(String tableKey) {
        Log.trace((String)("openTable tableKey: " + tableKey));
        TableId tableId = this.getTableId(tableKey);
        this.eventBus.fireEvent((GwtEvent)new OpenTableEvent(tableId));
    }

    public TableDefinition getCurrentTable() {
        return this.controller.getCurrentTable();
    }

    public void getTableDefinition(TableId tableId, AsyncCallback<TableDefinition> callback) {
        this.controller.getTableDefinition(tableId, callback);
    }

    public void getTableDefinition(String tableKey, AsyncCallback<TableDefinition> callback) {
        TableId tableId = this.getTableId(tableKey);
        this.controller.getTableDefinition(tableId, callback);
    }

    public void closeTable() {
        Log.trace((String)"closeTable");
        this.eventBus.fireEvent((GwtEvent)new CloseTableEvent());
    }

    protected TableId getTableId(String tableKey) {
        if (this.defaultDataSourceFactoryName == null) {
            Log.error((String)"No default DataSourceFactoryName specified");
            throw new IllegalArgumentException("No default DataSourceFactoryName specified");
        }
        return new TableId(this.defaultDataSourceFactoryName, tableKey);
    }

    public String getColumnName(int i) {
        String columnId = null;
        if (this.gridPanel != null) {
            columnId = this.gridPanel.getColumnName(i);
        }
        return columnId;
    }

    public String getColumnLocalId(int i) {
        String columnLocalId = null;
        if (this.gridPanel != null) {
            columnLocalId = this.gridPanel.getColumnLocalId(i);
        }
        return columnLocalId;
    }
}

