/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.tr.groupby.GroupBySession;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4GroupBy
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4GroupBy.class);
    private TabularDataService service;
    private GroupBySession groupBySession;

    public OpExecution4GroupBy(TabularDataService service, GroupBySession groupBySession) {
        this.service = service;
        this.groupBySession = groupBySession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        OperationExecution invocation = null;
        logger.debug(this.groupBySession.toString());
        HashMap<String, Object> map = this.groupBySession.getMap();
        if (map == null) {
            logger.error("In GroupBySession map is null");
            throw new TDGWTServiceException("In GroupBySession map is null");
        }
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.GroupBy.toString(), this.service);
        invocation = new OperationExecution(operationDefinition.getOperationId(), map);
        this.operationExecutionSpec.setOp(invocation);
    }
}

