/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.ediparser.engine.writer.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.sdmxsource.sdmx.api.constants.ATTRIBUTE_ATTACHMENT_LEVEL;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.ComponentBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptBean;
import org.sdmxsource.sdmx.api.model.beans.conceptscheme.ConceptSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.AttributeBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DimensionBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.PrimaryMeasureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.MaintainableRefBean;
import org.sdmxsource.sdmx.api.model.mutable.base.ItemMutableBean;
import org.sdmxsource.sdmx.ediparser.constants.MESSSAGE_FUNCTION;
import org.sdmxsource.sdmx.ediparser.engine.writer.EDIStructureWriterEngine;
import org.sdmxsource.sdmx.ediparser.engine.writer.impl.AbstractEdiOutputEngine;
import org.sdmxsource.sdmx.ediparser.model.impl.InterchangeHeader;
import org.sdmxsource.sdmx.ediparser.model.impl.MessageIdentification;
import org.sdmxsource.sdmx.ediparser.util.EDIStructureWriterUtil;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptMutableBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.mutable.conceptscheme.ConceptSchemeMutableBeanImpl;
import org.sdmxsource.sdmx.util.sort.IdentifiableComparator;
import org.sdmxsource.sdmx.util.sort.MaintainableSortByIdentifiers;
import org.springframework.stereotype.Service;

@Service
public class EDIStructureWriterEngineImpl
extends AbstractEdiOutputEngine
implements EDIStructureWriterEngine {
    private static String TIME_FORMAT = "TIME_FORMAT";

    @Override
    public void writeToEDI(SdmxBeans beans, OutputStream out) {
        InnerEngine engine = new InnerEngine(beans, out);
        try {
            try {
                engine.writeToEDI();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            engine.closeResources();
        }
    }

    private class InnerEngine
    extends AbstractEdiOutputEngine.InnerEngine {
        private List<DataStructureBean> keyFamilies;
        private List<ConceptBean> concepts;
        private List<CodelistBean> codelists;
        private List<String> agencies;
        MaintainableSortByIdentifiers comparator;
        private String processingAgency;

        public InnerEngine(SdmxBeans beans, OutputStream out) {
            super(out);
            this.concepts = new ArrayList<ConceptBean>();
            this.agencies = new ArrayList<String>();
            this.comparator = new MaintainableSortByIdentifiers();
            this.keyFamilies = new ArrayList<DataStructureBean>(beans.getDataStructures());
            Collections.sort(this.keyFamilies, this.comparator);
            this.codelists = new ArrayList<CodelistBean>(beans.getCodelists());
            Collections.sort(this.codelists, this.comparator);
            this.agencies = new ArrayList<String>();
            this.extractMaintenanceAgencies(this.keyFamilies);
            this.extractMaintenanceAgencies(this.codelists);
            this.extractMaintenanceAgencies(beans.getConceptSchemes());
            Collections.sort(this.agencies);
            HashSet<String> agenciesRequiringTimeFormatConcept = new HashSet<String>();
            for (DataStructureBean dsd : this.keyFamilies) {
                boolean found = false;
                for (AttributeBean attributeBean : dsd.getAttributes()) {
                    if (!attributeBean.isTimeFormat()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                agenciesRequiringTimeFormatConcept.add(dsd.getAgencyId());
            }
            for (ConceptSchemeBean conceptScheme : beans.getConceptSchemes()) {
                this.concepts.addAll(conceptScheme.getItems());
            }
            if (agenciesRequiringTimeFormatConcept.size() > 0) {
                for (String processingAgency : agenciesRequiringTimeFormatConcept) {
                    boolean hasTimeFormatConcept = false;
                    for (ConceptBean concept : this.concepts) {
                        if (!concept.getMaintainableParent().getAgencyId().equals(processingAgency) || !concept.getId().equals(TIME_FORMAT)) continue;
                        hasTimeFormatConcept = true;
                        break;
                    }
                    if (hasTimeFormatConcept) continue;
                    ConceptSchemeMutableBeanImpl timeFormatConceptScheme = new ConceptSchemeMutableBeanImpl();
                    timeFormatConceptScheme.setAgencyId(processingAgency);
                    timeFormatConceptScheme.setId(TIME_FORMAT);
                    timeFormatConceptScheme.addName("en", TIME_FORMAT);
                    ConceptMutableBeanImpl concept = new ConceptMutableBeanImpl();
                    concept.setId(TIME_FORMAT);
                    concept.addName("en", "Time Format");
                    timeFormatConceptScheme.addItem((ItemMutableBean)concept);
                    this.concepts.addAll(timeFormatConceptScheme.getImmutableInstance().getItems());
                }
            }
        }

        private void writeToEDI() throws IOException {
            InterchangeHeader header = new InterchangeHeader("MTRegistry", "RegistryClient", new Date(), 1, null);
            this.writeInterchangeAdministration(header);
            int messsageRef = 1;
            Iterator<String> iterator = this.agencies.iterator();
            while (iterator.hasNext()) {
                String agencyId;
                this.processingAgency = agencyId = iterator.next();
                MessageIdentification identification = new MessageIdentification(messsageRef);
                this.writeMessageIdentification(identification);
                this.writeMessageFunction(MESSSAGE_FUNCTION.STATISTICAL_DEFINITIONS);
                this.writeStructureMaintAgency(agencyId);
                this.writeRecievingAgency("RecAgency");
                this.writeSendingAgency("SendingAgency");
                this.writeCodelists();
                this.writeConcepts();
                this.writeDataStructures();
                this.writeEndMessageAdministration();
                ++messsageRef;
            }
            this.writeEndMessage();
        }

        private void writeCodelists() {
            for (CodelistBean currentCodelist : this.codelists) {
                if (!currentCodelist.getAgencyId().equals(this.processingAgency)) continue;
                try {
                    this.writeCodelist(currentCodelist);
                }
                catch (Throwable th) {
                    throw new RuntimeException("Error parsing Codelist to EDI : " + currentCodelist.getUrn(), th);
                }
            }
        }

        private void writeCodelist(CodelistBean codelist) {
            this.writeSegment(EDIStructureWriterUtil.parseCodelistIdentifier(codelist));
            for (CodeBean code : codelist.getItems()) {
                try {
                    this.writeCode(code);
                }
                catch (Throwable th) {
                    throw new RuntimeException("Error parsing Code to EDI : " + code.getUrn(), th);
                }
            }
        }

        private void writeCode(CodeBean code) {
            this.writeSegment(EDIStructureWriterUtil.parseCodeId(code));
            this.writeSegment(EDIStructureWriterUtil.parseCodeName(code));
        }

        private void writeConcepts() {
            ArrayList<String> processedConceptIds = new ArrayList<String>();
            for (ConceptBean currentConcept : this.concepts) {
                if (!currentConcept.getMaintainableParent().getAgencyId().equals(this.processingAgency)) continue;
                if (processedConceptIds.contains(currentConcept.getId())) {
                    throw new IllegalArgumentException("Duplicate concept Id found while processing concept: " + currentConcept.getUrn());
                }
                try {
                    this.writeConcept(currentConcept);
                }
                catch (Throwable th) {
                    throw new RuntimeException("Error parsing Concept to EDI : " + currentConcept.getUrn(), th);
                }
                processedConceptIds.add(currentConcept.getId());
            }
        }

        private void writeConcept(ConceptBean concept) {
            this.writeSegment(EDIStructureWriterUtil.parseConceptIdentifier(concept));
            this.writeSegment(EDIStructureWriterUtil.parseConceptName(concept));
        }

        private void writeDataStructures() {
            for (DataStructureBean currentKf : this.keyFamilies) {
                if (!currentKf.getAgencyId().equals(this.processingAgency)) continue;
                try {
                    this.writeDataStructure(currentKf);
                }
                catch (Throwable th) {
                    throw new SdmxException(th, "Error parsing DSD to EDI : " + currentKf.getUrn());
                }
            }
        }

        private void writeDataStructure(DataStructureBean dsb) {
            this.writeSegment(EDIStructureWriterUtil.parseDataStructureIdentifier(dsb));
            this.writeSegment(EDIStructureWriterUtil.parseDataStructureName(dsb));
            if (dsb.getGroups() != null && dsb.getGroups().size() > 1) {
                throw new IllegalArgumentException("DSD can not have more then one group in EDI");
            }
            this.validateDataStructureComponents(dsb.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION}), true);
            this.validateDataStructureComponents(dsb.getAttributes(), false);
            int i = 1;
            for (DimensionBean dim : dsb.getDimensions(new SDMX_STRUCTURE_TYPE[]{SDMX_STRUCTURE_TYPE.DIMENSION})) {
                this.writeDimension(dim, i);
                ++i;
            }
            this.writeTimeDimension(dsb.getTimeDimension(), i);
            boolean processedTimeFormatattribute = false;
            boolean defaultedTimeFormatattribute = false;
            for (AttributeBean attribute : dsb.getAttributes()) {
                if (!attribute.isTimeFormat()) continue;
                processedTimeFormatattribute = true;
                this.writeTimeFormat(attribute, ++i);
            }
            if (!processedTimeFormatattribute) {
                ComponentBean timeFormatComponent = dsb.getComponent("TIME_FORMAT");
                if (timeFormatComponent != null) {
                    if (!(timeFormatComponent instanceof AttributeBean)) {
                        throw new IllegalArgumentException("Could not output Key Family, no attributes contain isTimeFormat=true, and the default 'TIME_FORMAT' id has been taken");
                    }
                    defaultedTimeFormatattribute = true;
                    this.writeTimeFormat((AttributeBean)timeFormatComponent, ++i);
                } else {
                    this.writeTimeFormat(++i);
                }
            }
            this.writePrimaryMeasure(dsb.getPrimaryMeasure(), ++i);
            this.writeObservationAttributes(dsb, ++i);
            ArrayList sortedAttributes = new ArrayList(dsb.getAttributes());
            Collections.sort(sortedAttributes, new IdentifiableComparator());
            for (AttributeBean attribute : sortedAttributes) {
                if (this.isObservationAttribute(attribute.getId())) {
                    if (attribute.getAttachmentLevel() == ATTRIBUTE_ATTACHMENT_LEVEL.OBSERVATION) continue;
                    throw new SdmxException("Can not output EDI, attribute '" + attribute.getId() + "' expected to be attached to the observation, actual attachment was: " + attribute.getAttachmentLevel());
                }
                if (attribute.isTimeFormat() || defaultedTimeFormatattribute && attribute.getId().equals(TIME_FORMAT)) continue;
                this.writeAttribute(attribute);
            }
        }

        private boolean isObservationAttribute(String id) {
            return id.equals("OBS_STATUS") || id.equals("CONF_STATUS") || id.equals("OBS_CONF") || id.equals("OBS_PRE_BREAK");
        }

        private void validateDataStructureComponents(List<? extends ComponentBean> componentBeans, boolean mandatoryCodelist) {
            for (ComponentBean componentBean : componentBeans) {
                MaintainableRefBean conceptMaintRef;
                CrossReferenceBean codelistRef = null;
                if (componentBean.getRepresentation() != null) {
                    codelistRef = componentBean.getRepresentation().getRepresentation();
                }
                if (codelistRef == null) {
                    if (mandatoryCodelist) {
                        throw new IllegalArgumentException("Codelist Reference is missing");
                    }
                } else {
                    MaintainableRefBean codelistMaintRef = codelistRef.getMaintainableReference();
                    if (!codelistMaintRef.getAgencyId().equals(this.processingAgency)) {
                        throw new IllegalArgumentException("Agency of Codelist Reference `" + codelistMaintRef.getAgencyId() + "` differs from DSD agency `" + this.processingAgency + "`");
                    }
                }
                if ((conceptMaintRef = componentBean.getConceptRef().getMaintainableReference()).getAgencyId().equals(this.processingAgency)) continue;
                throw new IllegalArgumentException("Agency of Concept Reference `" + conceptMaintRef.getAgencyId() + "`  differs from DSD agency `" + this.processingAgency + "`");
            }
        }

        private void writeObservationAttributes(DataStructureBean kf, int position) {
            AttributeBean obsPreBreak;
            AttributeBean obsStatus = kf.getObservationAttribute("OBS_STATUS");
            if (obsStatus == null) {
                throw new IllegalArgumentException("Could not output Data Strucutre, missing observation attribute 'OBS_STATUS'");
            }
            if (!obsStatus.isMandatory()) {
                throw new IllegalArgumentException("Could not output Data Strucutre, 'OBS_STATUS' attribute must be mandatory");
            }
            this.writeObservationAttribute(obsStatus, position);
            AttributeBean obsConf = kf.getObservationAttribute("OBS_CONF");
            if (obsConf == null) {
                obsConf = kf.getObservationAttribute("CONF_STATUS");
            }
            if (obsConf != null) {
                this.writeObservationAttribute(obsConf, ++position);
            }
            if ((obsPreBreak = kf.getObservationAttribute("OBS_PRE_BREAK")) != null) {
                this.writeObservationAttribute(obsPreBreak, ++position);
            }
        }

        private void writeDimension(DimensionBean dim, int position) {
            this.writeSegment(EDIStructureWriterUtil.parseDimensionIdentification((ComponentBean)dim, position));
            this.writeSegment(EDIStructureWriterUtil.parseFieldLength((ComponentBean)dim, true));
            this.writeSegment(EDIStructureWriterUtil.parseCodelistReference((ComponentBean)dim));
        }

        private void writeTimeDimension(DimensionBean dim, int position) {
            this.writeSegment(EDIStructureWriterUtil.parseDimensionIdentification((ComponentBean)dim, position));
            this.writeSegment(EDIStructureWriterUtil.parseFieldLength((ComponentBean)dim, true));
        }

        private void writeTimeFormat(int position) {
            this.writeSegment(EDIStructureWriterUtil.parseTimeFormat(position, TIME_FORMAT));
            this.writeSegment(EDIStructureWriterUtil.parseTimeFormatFieldLength());
        }

        private void writeTimeFormat(AttributeBean attribute, int position) {
            if (attribute.getConceptRef().getTargetReference().isMaintainable()) {
                this.writeSegment(EDIStructureWriterUtil.parseTimeFormat(position, attribute.getConceptRef().getMaintainableReference().getMaintainableId()));
            } else {
                this.writeSegment(EDIStructureWriterUtil.parseTimeFormat(position, attribute.getConceptRef().getChildReference().getId()));
            }
            this.writeSegment(EDIStructureWriterUtil.parseTimeFormatFieldLength());
            if (attribute.getRepresentation() != null && attribute.getRepresentation().getRepresentation() != null) {
                this.writeSegment(EDIStructureWriterUtil.parseCodelistReference((ComponentBean)attribute));
            }
        }

        private void writePrimaryMeasure(PrimaryMeasureBean primaryMeasure, int position) {
            this.writeSegment(EDIStructureWriterUtil.parsePrimaryMeasureIdentification(primaryMeasure, position));
            this.writeSegment(EDIStructureWriterUtil.parseFieldLength((ComponentBean)primaryMeasure, true));
        }

        private void writeObservationAttribute(AttributeBean attribute, int pos) {
            this.writeSegment(EDIStructureWriterUtil.parseObservationAttribute(attribute, pos));
            this.writeSegment(EDIStructureWriterUtil.parseFieldLength((ComponentBean)attribute, false));
            this.writeSegment(EDIStructureWriterUtil.parseUseageStatus(attribute));
            this.writeSegment(EDIStructureWriterUtil.parseDimensionAttributeAttachmentLevel(attribute));
            if (attribute.hasCodedRepresentation()) {
                this.writeSegment(EDIStructureWriterUtil.parseCodelistReference((ComponentBean)attribute));
            }
        }

        private void writeAttribute(AttributeBean attribute) {
            this.writeSegment(EDIStructureWriterUtil.parseDimensionAttribute(attribute));
            this.writeSegment(EDIStructureWriterUtil.parseFieldLength((ComponentBean)attribute, false));
            this.writeSegment(EDIStructureWriterUtil.parseUseageStatus(attribute));
            this.writeSegment(EDIStructureWriterUtil.parseDimensionAttributeAttachmentLevel(attribute));
            if (attribute.hasCodedRepresentation()) {
                this.writeSegment(EDIStructureWriterUtil.parseCodelistReference((ComponentBean)attribute));
            }
        }

        private void extractMaintenanceAgencies(Collection<? extends MaintainableBean> maintColl) {
            if (maintColl == null) {
                return;
            }
            for (MaintainableBean maintainableBean : maintColl) {
                this.agencies.add(maintainableBean.getAgencyId());
            }
        }

        @Override
        public void closeResources() {
            super.closeResources();
        }
    }
}

