/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDLogsServlet
extends HttpServlet {
    private static final long serialVersionUID = -737451890907300011L;
    protected static Logger logger = LoggerFactory.getLogger(TDLogsServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime;
        block13: {
            ByteArrayOutputStream out;
            block14: {
                logger.debug("TDLogsServlet");
                startTime = System.currentTimeMillis();
                HttpSession session = request.getSession();
                if (session == null) {
                    logger.error("Error getting the upload session, no session valid found: " + session);
                    response.sendError(408, "ERROR-Error getting the user session, no session found" + session);
                    return;
                }
                logger.debug("TDLogsServlet import session id: " + session.getId());
                ByteArrayInputStream in = null;
                out = null;
                try {
                    response.setContentType("text/html; charset=utf-8");
                    String relativeWebPath = "/logs/TabularDataManagerLogBack.log";
                    out = new ByteArrayOutputStream();
                    String absoluteDiskPath = this.getServletContext().getRealPath(relativeWebPath);
                    File file = new File(absoluteDiskPath);
                    in = new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    response.getOutputStream().write(out.toByteArray());
                    response.setStatus(200);
                }
                catch (FileNotFoundException e) {
                    logger.error("File not found: " + e.getLocalizedMessage());
                    response.sendError(500, e.getLocalizedMessage());
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                    break block13;
                }
                catch (IOException e) {
                    try {
                        logger.error("IO error: " + e.getLocalizedMessage());
                        response.sendError(500, e.getLocalizedMessage());
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                if (in == null) break block14;
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        logger.debug("Response in " + (System.currentTimeMillis() - startTime));
    }
}

