/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.td.gwtservice.server.opexecution;

import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationDefinition;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.operations.OperationExecution;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.composite.text.Concat;
import org.gcube.data.analysis.tabulardata.expression.dsl.Comparators;
import org.gcube.data.analysis.tabulardata.expression.dsl.Logicals;
import org.gcube.data.analysis.tabulardata.expression.dsl.Types;
import org.gcube.data.analysis.tabulardata.expression.functions.Cast;
import org.gcube.data.analysis.tabulardata.expression.logical.And;
import org.gcube.data.analysis.tabulardata.model.column.ColumnLocalId;
import org.gcube.data.analysis.tabulardata.model.column.ColumnReference;
import org.gcube.data.analysis.tabulardata.model.column.type.AttributeColumnType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;
import org.gcube.data.analysis.tabulardata.model.datatype.GeometryType;
import org.gcube.data.analysis.tabulardata.model.datatype.value.TDText;
import org.gcube.data.analysis.tabulardata.model.metadata.common.ImmutableLocalizedText;
import org.gcube.data.analysis.tabulardata.model.table.TableId;
import org.gcube.data.analysis.tabulardata.service.TabularDataService;
import org.gcube.portlets.user.td.gwtservice.server.opexecution.OpExecutionBuilder;
import org.gcube.portlets.user.td.gwtservice.server.trservice.OperationDefinitionMap;
import org.gcube.portlets.user.td.gwtservice.shared.exception.TDGWTServiceException;
import org.gcube.portlets.user.td.gwtservice.shared.geometry.GeometryCreatePointSession;
import org.gcube.portlets.user.td.gwtservice.shared.tr.ColumnData;
import org.gcube.portlets.user.td.widgetcommonevent.shared.TRId;
import org.gcube.portlets.user.td.widgetcommonevent.shared.operations.OperationsId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecution4GeometryCreatePoint
extends OpExecutionBuilder {
    protected static Logger logger = LoggerFactory.getLogger(OpExecution4GeometryCreatePoint.class);
    private TabularDataService service;
    private GeometryCreatePointSession geometryCreatePointSession;

    public OpExecution4GeometryCreatePoint(TabularDataService service, GeometryCreatePointSession geometryCreatePointSession) {
        this.service = service;
        this.geometryCreatePointSession = geometryCreatePointSession;
    }

    @Override
    public void buildOpEx() throws TDGWTServiceException {
        logger.debug(this.geometryCreatePointSession.toString());
        ArrayList<OperationExecution> invocations = new ArrayList<OperationExecution>();
        TRId trId = this.geometryCreatePointSession.getTrId();
        logger.debug("trID: " + trId);
        if (trId == null) {
            logger.error("Error Creating Geometry: trId is null");
            throw new TDGWTServiceException("No tabular resource set");
        }
        long tabId = trId.isViewTable() ? new Long(trId.getReferenceTargetTableId()).longValue() : new Long(trId.getTableId()).longValue();
        TableId tId = new TableId(tabId);
        ColumnData latitudeColumn = this.geometryCreatePointSession.getLatitude();
        logger.debug("Latitude Column: " + latitudeColumn);
        if (latitudeColumn == null) {
            logger.error("Error creating Geometry: Latitude Column is null");
            throw new TDGWTServiceException("No latitude column set");
        }
        ColumnLocalId latitudeId = new ColumnLocalId(latitudeColumn.getColumnId());
        ColumnReference latitudeColumnReference = new ColumnReference(tId, latitudeId);
        ColumnData longitudeColumn = this.geometryCreatePointSession.getLongitude();
        logger.debug("Longitude Column: " + longitudeColumn);
        if (longitudeColumn == null) {
            logger.error("Error creating Geometry: Longitude Column is null");
            throw new TDGWTServiceException("No longitude column set");
        }
        ColumnLocalId longitudeId = new ColumnLocalId(longitudeColumn.getColumnId());
        ColumnReference longitudeColumnReference = new ColumnReference(tId, longitudeId);
        HashMap<String, String> validationParameters = new HashMap<String, String>();
        OperationDefinition operationValidation = OperationDefinitionMap.map(OperationsId.ExpressionValidation.toString(), this.service);
        validationParameters.put("title", "Coordinates validation");
        String description = new String("Longitude value must be between [-180, 180], Latitude value must be between [-90, 90]");
        And expression = Logicals.and((Expression[])new Expression[]{Comparators.lessEq((Expression)longitudeColumnReference, (Expression)Types.numeric((double)180.0)), Comparators.greaterEq((Expression)longitudeColumnReference, (Expression)Types.numeric((double)-180.0)), Comparators.lessEq((Expression)latitudeColumnReference, (Expression)Types.numeric((double)90.0)), Comparators.greaterEq((Expression)latitudeColumnReference, (Expression)Types.numeric((double)-90.0))});
        validationParameters.put("description", description);
        validationParameters.put("expression", (String)expression);
        invocations.add(new OperationExecution(operationValidation.getOperationId(), validationParameters));
        Cast point = new Cast((Expression)new Concat((Expression)new TDText("POINT("), (Expression)new Concat((Expression)longitudeColumnReference, (Expression)new Concat((Expression)new TDText(" "), (Expression)new Concat((Expression)latitudeColumnReference, (Expression)new TDText(")"))))), (DataType)new GeometryType());
        HashMap<String, Object> map = new HashMap<String, Object>();
        OperationDefinition operationDefinition = OperationDefinitionMap.map(OperationsId.AddColumn.toString(), this.service);
        map.put("columnType", new AttributeColumnType());
        map.put("dataType", new GeometryType());
        map.put("label", new ImmutableLocalizedText(this.geometryCreatePointSession.getColumnLabel()));
        map.put("value", point);
        invocations.add(new OperationExecution(operationDefinition.getOperationId(), map));
        this.operationExecutionSpec.setOps(invocations);
    }
}

