/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.tdwx.client.config;

import com.sencha.gxt.core.client.ValueProvider;
import com.sencha.gxt.widget.core.client.grid.GridViewConfig;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.portlets.user.tdwx.client.config.Row;
import org.gcube.portlets.user.tdwx.client.config.RowStyleProvider;
import org.gcube.portlets.user.tdwx.client.config.TableViewConfig;
import org.gcube.portlets.user.tdwx.shared.model.ColumnDefinition;
import org.gcube.portlets.user.tdwx.shared.model.ColumnKey;
import org.gcube.portlets.user.tdwx.shared.model.ColumnType;
import org.gcube.portlets.user.tdwx.shared.model.DataRow;
import org.gcube.portlets.user.tdwx.shared.model.TableDefinition;

public class TabularDataGridViewConfig
implements GridViewConfig<DataRow> {
    protected RowStyleProvider rowStyleProvider;
    protected Row row;
    protected TableDefinition tableDefinition;
    protected ArrayList<ColumnDefinition> validationColumns;

    public TabularDataGridViewConfig(TableViewConfig config, TableDefinition definition) {
        this.rowStyleProvider = config.getRowStyleProvider();
        this.tableDefinition = definition;
        this.validationColumns = new ArrayList();
        HashMap<String, ColumnKey> keys = new HashMap<String, ColumnKey>();
        for (ColumnDefinition column : definition.getColumnsAsList()) {
            keys.put(column.getColumnLocalId(), column.getKey());
            if (column.getType() != ColumnType.VALIDATION) continue;
            this.validationColumns.add(column);
        }
        this.row = new Row(keys);
    }

    public String getColStyle(DataRow model, ValueProvider<? super DataRow, ?> valueProvider, int rowIndex, int colIndex) {
        this.row.setDataRow(model);
        return this.rowStyleProvider.getColStyle(this.row, this.validationColumns, valueProvider, rowIndex, colIndex);
    }

    public String getRowStyle(DataRow model, int rowIndex) {
        this.row.setDataRow(model);
        return this.rowStyleProvider.getRowStyle(this.row, this.validationColumns);
    }
}

