/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureretrieval.manager;

import java.util.HashSet;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.manager.retrieval.ProvisionBeanRetrievalManager;
import org.sdmxsource.sdmx.api.manager.retrieval.SdmxBeanRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.DataProviderSchemeBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataStructureBean;
import org.sdmxsource.sdmx.api.model.beans.datastructure.DataflowBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataFlowBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.registry.ProvisionAgreementBean;
import org.sdmxsource.sdmx.api.model.beans.registry.RegistrationBean;
import org.sdmxsource.util.ObjectUtil;

public class ProvisionRetrievalManagerFromBeanRetrieval
implements ProvisionBeanRetrievalManager {
    private SdmxBeanRetrievalManager beanRetrievalManager;

    public ProvisionRetrievalManagerFromBeanRetrieval(SdmxBeanRetrievalManager beanRetrievalManager) {
        this.beanRetrievalManager = beanRetrievalManager;
    }

    public Set<ProvisionAgreementBean> getProvisions() {
        return this.beanRetrievalManager.getMaintainableBeans(ProvisionAgreementBean.class);
    }

    public Set<ProvisionAgreementBean> getProvisionsByDataStructure(StructureReferenceBean provisionRef) {
        Set allProvision = this.beanRetrievalManager.getMaintainableBeans(ProvisionAgreementBean.class);
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        Set keyFamilies = this.beanRetrievalManager.getMaintainableBeans(DataStructureBean.class);
        Set dataflows = this.beanRetrievalManager.getMaintainableBeans(DataflowBean.class);
        for (MaintainableBean currentDSD : keyFamilies) {
            if (!provisionRef.isMatch(currentDSD)) continue;
            for (MaintainableBean currentFlow : dataflows) {
                DataflowBean df = (DataflowBean)currentFlow;
                if (!df.getDataStructureRef().isMatch(currentDSD)) continue;
                returnSet.addAll(this.getByReference((MaintainableBean)df, allProvision));
            }
        }
        return returnSet;
    }

    public Set<ProvisionAgreementBean> getProvisionsByDataFlow(StructureReferenceBean provisionRef) {
        Set allProvision = this.beanRetrievalManager.getMaintainableBeans(ProvisionAgreementBean.class);
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        Set dataflows = this.beanRetrievalManager.getMaintainableBeans(DataflowBean.class);
        for (MaintainableBean currentFlow : dataflows) {
            returnSet.addAll(this.getByReference(currentFlow, allProvision));
        }
        return returnSet;
    }

    public Set<ProvisionAgreementBean> getProvisionsByDataProvider(StructureReferenceBean provisionRef) {
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        Set allProvisions = this.beanRetrievalManager.getMaintainableBeans(ProvisionAgreementBean.class);
        Set dataProviderSchemes = this.beanRetrievalManager.getMaintainableBeans(DataProviderSchemeBean.class);
        for (MaintainableBean currentDps : dataProviderSchemes) {
            if (!provisionRef.isMatch(currentDps)) continue;
            for (MaintainableBean currentProvision : allProvisions) {
                ProvisionAgreementBean prov = (ProvisionAgreementBean)currentProvision;
                if (!prov.getDataproviderRef().equals(provisionRef)) continue;
                returnSet.add(prov);
            }
        }
        return returnSet;
    }

    public Set<ProvisionAgreementBean> getProvisionsByProvision(StructureReferenceBean provisionRef) {
        return this.beanRetrievalManager.getMaintainableBeans(ProvisionAgreementBean.class, provisionRef.getMaintainableReference());
    }

    public Set<ProvisionAgreementBean> getProvisions(StructureReferenceBean provisionRef) {
        SDMX_STRUCTURE_TYPE targetReference = provisionRef.getTargetReference();
        switch (targetReference) {
            case DSD: {
                return this.getProvisionsByDataStructure(provisionRef);
            }
            case DATAFLOW: {
                return this.getProvisionsByDataFlow(provisionRef);
            }
            case DATA_PROVIDER: {
                return this.getProvisionsByDataProvider(provisionRef);
            }
            case PROVISION_AGREEMENT: {
                return this.getProvisionsByProvision(provisionRef);
            }
        }
        throw new SdmxNotImplementedException("Can not get Provisons by stucture type:" + targetReference.getType());
    }

    public ProvisionAgreementBean getProvision(RegistrationBean registration) {
        Set<ProvisionAgreementBean> provisions = this.getProvisions((StructureReferenceBean)registration.getProvisionAgreementRef());
        if (ObjectUtil.validCollection(provisions)) {
            if (provisions.size() > 1) {
                throw new RuntimeException("Only one provision agreement expected from reference : " + registration.getProvisionAgreementRef());
            }
            return (ProvisionAgreementBean)provisions.toArray()[0];
        }
        return null;
    }

    public Set<ProvisionAgreementBean> getProvisions(DataflowBean dataflow) {
        Set allProvisions = this.beanRetrievalManager.getMaintainableBeans(ProvisionAgreementBean.class);
        return this.getByReference((MaintainableBean)dataflow, allProvisions);
    }

    public Set<ProvisionAgreementBean> getProvisions(MetadataFlowBean metadataflow) {
        Set allProvisions = this.beanRetrievalManager.getMaintainableBeans(ProvisionAgreementBean.class);
        return this.getByReference((MaintainableBean)metadataflow, allProvisions);
    }

    private Set<ProvisionAgreementBean> getByReference(MaintainableBean bean, Set<ProvisionAgreementBean> allProvisions) {
        HashSet<ProvisionAgreementBean> returnSet = new HashSet<ProvisionAgreementBean>();
        for (MaintainableBean maintainableBean : allProvisions) {
            ProvisionAgreementBean provision = (ProvisionAgreementBean)maintainableBean;
            if (!this.isMatch(provision, bean)) continue;
            returnSet.add(provision);
        }
        return returnSet;
    }

    private boolean isMatch(ProvisionAgreementBean provision, MaintainableBean bean) {
        for (CrossReferenceBean currentRef : provision.getCrossReferences()) {
            if (!currentRef.isMatch(bean)) continue;
            return true;
        }
        return false;
    }
}

