/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.StructureDocument;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.message.StructureType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.CodeListType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.ConceptType;
import org.sdmx.resources.sdmxml.schemas.v10.xmlbeans.structure.KeyFamilyType;
import org.sdmxsource.sdmx.api.builder.Builder;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.MaintainableBeanException;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.model.beans.SdmxBeans;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.header.HeaderBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.codelist.CodelistBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.conceptscheme.ConceptSchemeBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.datastructure.DataStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.header.HeaderBeanImpl;
import org.sdmxsource.sdmx.structureparser.builder.sdmxbeans.impl.AbstractSdmxBeansBuilder;
import org.sdmxsource.sdmx.util.beans.container.SdmxBeansImpl;
import org.springframework.stereotype.Service;

@Service
public class SdmxBeansV1Builder
extends AbstractSdmxBeansBuilder
implements Builder<SdmxBeans, StructureDocument> {
    public SdmxBeans build(StructureDocument structuresDoc) throws SdmxException {
        HashSet<String> urns = new HashSet<String>();
        StructureType structures = structuresDoc.getStructure();
        SdmxBeansImpl beans = new SdmxBeansImpl((HeaderBean)new HeaderBeanImpl(structures.getHeader()));
        if (structures.getCodeLists() != null && structures.getCodeLists().getCodeListList() != null) {
            for (CodeListType currentType : structures.getCodeLists().getCodeListList()) {
                try {
                    this.addIfNotDuplicateURN((SdmxBeans)beans, urns, (IdentifiableBean)new CodelistBeanImpl(currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CODE_LIST, currentType.getAgency(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        HashMap conceptAgencyMap = new HashMap();
        if (structures.getConcepts() != null && structures.getConcepts().getConceptList() != null) {
            for (ConceptType currentType : structures.getConcepts().getConceptList()) {
                List<ConceptType> concepts;
                if (conceptAgencyMap.containsKey(currentType.getAgency())) {
                    concepts = (List)conceptAgencyMap.get(currentType.getAgency());
                } else {
                    concepts = new ArrayList();
                    conceptAgencyMap.put(currentType.getAgency(), concepts);
                }
                concepts.add(currentType);
            }
        }
        for (String currentConceptAgency : conceptAgencyMap.keySet()) {
            try {
                this.addIfNotDuplicateURN((SdmxBeans)beans, urns, (IdentifiableBean)new ConceptSchemeBeanImpl(currentConceptAgency, (List)conceptAgencyMap.get(currentConceptAgency)));
            }
            catch (Throwable th) {
                throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME, currentConceptAgency, "STANDALONE_CONCEPT_SCHEME", "1.0");
            }
        }
        if (structures.getKeyFamilies() != null && structures.getKeyFamilies().getKeyFamilyList() != null) {
            for (ConceptType currentType : structures.getKeyFamilies().getKeyFamilyList()) {
                try {
                    this.addIfNotDuplicateURN((SdmxBeans)beans, urns, (IdentifiableBean)new DataStructureBeanImpl((KeyFamilyType)currentType));
                }
                catch (Throwable th) {
                    throw new MaintainableBeanException(th, SDMX_STRUCTURE_TYPE.DSD, currentType.getAgency(), currentType.getId(), currentType.getVersion());
                }
            }
        }
        return beans;
    }
}

