/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sdmx.resources.sdmxml.schemas.v20.structure.CategorySchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ConceptSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.HierarchicalCodelistRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.KeyFamilyRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.MetadataStructureRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.OrganisationSchemeRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.RelatedStructuresType;
import org.sdmx.resources.sdmxml.schemas.v21.common.StructureOrUsageReferenceType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.RelatedStructuresBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.RelatedStructuresMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RelatedStructuresBeanImpl
extends SdmxStructureBeanImpl
implements RelatedStructuresBean {
    private static final long serialVersionUID = 1L;
    private List<CrossReferenceBean> keyFamilyRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> metadataStructureRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> conceptSchemeRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> categorySchemeRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> orgSchemeRef = new ArrayList<CrossReferenceBean>();
    private List<CrossReferenceBean> hierCodelistRef = new ArrayList<CrossReferenceBean>();

    public RelatedStructuresBeanImpl(RelatedStructuresMutableBean bean, SdmxStructureBean parent) {
        super((MutableBean)bean, parent);
        this.keyFamilyRef = this.createCrossReferenceList(bean.getDataStructureRef());
        this.metadataStructureRef = this.createCrossReferenceList(bean.getMetadataStructureRef());
        this.conceptSchemeRef = this.createCrossReferenceList(bean.getConceptSchemeRef());
        this.categorySchemeRef = this.createCrossReferenceList(bean.getCategorySchemeRef());
        this.orgSchemeRef = this.createCrossReferenceList(bean.getOrgSchemeRef());
        this.hierCodelistRef = this.createCrossReferenceList(bean.getHierCodelistRef());
    }

    private List<CrossReferenceBean> createCrossReferenceList(List<StructureReferenceBean> structureReferences) {
        ArrayList<CrossReferenceBean> retrurnList = new ArrayList<CrossReferenceBean>();
        if (structureReferences != null) {
            for (StructureReferenceBean currentStructureReference : structureReferences) {
                retrurnList.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, currentStructureReference));
            }
        }
        return retrurnList;
    }

    public RelatedStructuresBeanImpl(List<StructureOrUsageReferenceType> relStrucTypeList, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.RELATED_STRUCTURES, parent);
        block8: for (StructureOrUsageReferenceType relStrucType : relStrucTypeList) {
            CrossReferenceBean structureReference = RefUtil.createReference(this, relStrucType);
            switch (structureReference.getTargetReference()) {
                case DSD: {
                    this.keyFamilyRef.add(structureReference);
                    continue block8;
                }
                case MSD: {
                    this.metadataStructureRef.add(structureReference);
                    continue block8;
                }
                case CONCEPT_SCHEME: {
                    this.conceptSchemeRef.add(structureReference);
                    continue block8;
                }
                case CATEGORY_SCHEME: {
                    this.categorySchemeRef.add(structureReference);
                    continue block8;
                }
                case ORGANISATION_UNIT_SCHEME: {
                    this.orgSchemeRef.add(structureReference);
                    continue block8;
                }
                case HIERARCHICAL_CODELIST: {
                    this.hierCodelistRef.add(structureReference);
                    continue block8;
                }
            }
            throw new SdmxSemmanticException("RelatedStructuresBean can not reference : " + structureReference.getTargetReference().getType());
        }
    }

    public RelatedStructuresBeanImpl(RelatedStructuresType relStrucType, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.RELATED_STRUCTURES, parent);
        if (relStrucType.getKeyFamilyRefList() != null) {
            for (KeyFamilyRefType keyFam : relStrucType.getKeyFamilyRefList()) {
                if (ObjectUtil.validString((String[])new String[]{keyFam.getURN()})) {
                    this.keyFamilyRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, keyFam.getURN()));
                    continue;
                }
                this.keyFamilyRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, keyFam.getKeyFamilyAgencyID(), keyFam.getKeyFamilyID(), keyFam.getVersion(), SDMX_STRUCTURE_TYPE.DSD));
            }
        }
        if (relStrucType.getMetadataStructureRefList() != null) {
            for (MetadataStructureRefType metStruc : relStrucType.getMetadataStructureRefList()) {
                if (ObjectUtil.validString((String[])new String[]{metStruc.getURN()})) {
                    this.metadataStructureRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, metStruc.getURN()));
                    continue;
                }
                this.metadataStructureRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, metStruc.getMetadataStructureAgencyID(), metStruc.getMetadataStructureID(), metStruc.getVersion(), SDMX_STRUCTURE_TYPE.MSD));
            }
        }
        if (relStrucType.getConceptSchemeRefList() != null) {
            for (ConceptSchemeRefType conStruc : relStrucType.getConceptSchemeRefList()) {
                if (ObjectUtil.validString((String[])new String[]{conStruc.getURN()})) {
                    this.conceptSchemeRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, conStruc.getURN()));
                    continue;
                }
                this.conceptSchemeRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, conStruc.getAgencyID(), conStruc.getConceptSchemeID(), conStruc.getVersion(), SDMX_STRUCTURE_TYPE.CONCEPT_SCHEME));
            }
        }
        if (relStrucType.getCategorySchemeRefList() != null) {
            for (CategorySchemeRefType catStruc : relStrucType.getCategorySchemeRefList()) {
                if (ObjectUtil.validString((String[])new String[]{catStruc.getURN()})) {
                    this.categorySchemeRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, catStruc.getURN()));
                    continue;
                }
                this.categorySchemeRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, catStruc.getAgencyID(), catStruc.getCategorySchemeID(), catStruc.getVersion(), SDMX_STRUCTURE_TYPE.CATEGORY_SCHEME));
            }
        }
        if (relStrucType.getOrganisationSchemeRefList() != null) {
            for (OrganisationSchemeRefType orgScheme : relStrucType.getOrganisationSchemeRefList()) {
                if (ObjectUtil.validString((String[])new String[]{orgScheme.getURN()})) {
                    this.orgSchemeRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, orgScheme.getURN()));
                    continue;
                }
                this.orgSchemeRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, orgScheme.getAgencyID(), orgScheme.getOrganisationSchemeID(), orgScheme.getVersion(), SDMX_STRUCTURE_TYPE.ORGANISATION_UNIT_SCHEME));
            }
        }
        if (relStrucType.getHierarchicalCodelistRefList() != null) {
            for (HierarchicalCodelistRefType hierCode : relStrucType.getHierarchicalCodelistRefList()) {
                if (ObjectUtil.validString((String[])new String[]{hierCode.getURN()})) {
                    this.hierCodelistRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, hierCode.getURN()));
                    continue;
                }
                this.hierCodelistRef.add((CrossReferenceBean)new CrossReferenceBeanImpl((SDMXBean)this, hierCode.getAgencyID(), hierCode.getHierarchicalCodelistID(), hierCode.getVersion(), SDMX_STRUCTURE_TYPE.HIERARCHICAL_CODELIST));
            }
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            RelatedStructuresBean that = (RelatedStructuresBean)bean;
            if (!ObjectUtil.equivalentCollection(this.keyFamilyRef, (Collection)that.getDataStructureRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.metadataStructureRef, (Collection)that.getMetadataStructureRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.conceptSchemeRef, (Collection)that.getConceptSchemeRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.categorySchemeRef, (Collection)that.getCategorySchemeRef())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.orgSchemeRef, (Collection)that.getOrgSchemeRef())) {
                return false;
            }
            return ObjectUtil.equivalentCollection(this.hierCodelistRef, (Collection)that.getHierCodelistRef());
        }
        return false;
    }

    public List<CrossReferenceBean> getDataStructureRef() {
        return new ArrayList<CrossReferenceBean>(this.keyFamilyRef);
    }

    public List<CrossReferenceBean> getMetadataStructureRef() {
        return new ArrayList<CrossReferenceBean>(this.metadataStructureRef);
    }

    public List<CrossReferenceBean> getConceptSchemeRef() {
        return new ArrayList<CrossReferenceBean>(this.conceptSchemeRef);
    }

    public List<CrossReferenceBean> getCategorySchemeRef() {
        return new ArrayList<CrossReferenceBean>(this.categorySchemeRef);
    }

    public List<CrossReferenceBean> getOrgSchemeRef() {
        return new ArrayList<CrossReferenceBean>(this.orgSchemeRef);
    }

    public List<CrossReferenceBean> getHierCodelistRef() {
        return new ArrayList<CrossReferenceBean>(this.hierCodelistRef);
    }
}

