/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v20.structure.RepresentationMapRefType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.TextFormatType;
import org.sdmx.resources.sdmxml.schemas.v20.structure.ToValueTypeType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.RepresentationMapType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ValueMappingType;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.constants.TO_VALUE;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextFormatBean;
import org.sdmxsource.sdmx.api.model.beans.mapping.RepresentationMapRefBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.mutable.base.MutableBean;
import org.sdmxsource.sdmx.api.model.mutable.mapping.RepresentationMapRefMutableBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextFormatBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.CrossReferenceBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class RepresentationMapRefBeanImpl
extends SdmxStructureBeanImpl
implements RepresentationMapRefBean {
    private static final long serialVersionUID = 1L;
    private CrossReferenceBean codelistMap;
    private TextFormatBean toTextFormat;
    private TO_VALUE toValueType;
    private Map<String, String> valueMappings = new HashMap<String, String>();

    protected RepresentationMapRefBeanImpl(RepresentationMapRefMutableBean ref, SdmxStructureBean parent) {
        super((MutableBean)ref, parent);
        if (ref.getCodelistMap() != null) {
            this.codelistMap = new CrossReferenceBeanImpl((SDMXBean)this, ref.getCodelistMap());
        }
        if (ref.getToTextFormat() != null) {
            this.toTextFormat = new TextFormatBeanImpl(ref.getToTextFormat(), (SDMXBean)this);
        }
        if (ref.getValueMappings() != null) {
            this.valueMappings = new HashMap<String, String>(ref.getValueMappings());
        }
        this.toValueType = ref.getToValueType();
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
    }

    public RepresentationMapRefBeanImpl(RepresentationMapType refBean, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.REPRESENTATION_MAP, parent);
        if (refBean.getCodelistMap() != null) {
            String agencyId = this.getMaintainableParent().getAgencyId();
            String maintainableId = this.getMaintainableParent().getId();
            String version = this.getMaintainableParent().getVersion();
            this.codelistMap = new CrossReferenceBeanImpl((SDMXBean)this, agencyId, maintainableId, version, SDMX_STRUCTURE_TYPE.CODE_LIST_MAP, new String[]{refBean.getCodelistMap().getRef().getId()});
        }
        if (refBean.getToTextFormat() != null) {
            this.toTextFormat = new TextFormatBeanImpl(refBean.getToTextFormat(), (SDMXBean)this);
        }
        if (refBean.getToValueType() != null) {
            switch (refBean.getToValueType().intValue()) {
                case 3: {
                    this.toValueType = TO_VALUE.DESCRIPTION;
                    break;
                }
                case 2: {
                    this.toValueType = TO_VALUE.NAME;
                    break;
                }
                case 1: {
                    this.toValueType = TO_VALUE.VALUE;
                }
            }
        }
        if (refBean.getValueMap() != null) {
            for (ValueMappingType vmt : refBean.getValueMap().getValueMappingList()) {
                this.valueMappings.put(vmt.getSource(), vmt.getTarget());
            }
        }
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
    }

    public RepresentationMapRefBeanImpl(TextFormatType textFormatType, ToValueTypeType.Enum toValueType, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.REPRESENTATION_MAP, parent);
        this.toTextFormat = new TextFormatBeanImpl(textFormatType, (SDMXBean)this);
        if (toValueType != null) {
            switch (toValueType.intValue()) {
                case 3: {
                    this.toValueType = TO_VALUE.DESCRIPTION;
                    break;
                }
                case 2: {
                    this.toValueType = TO_VALUE.NAME;
                    break;
                }
                case 1: {
                    this.toValueType = TO_VALUE.VALUE;
                }
            }
        }
        this.validate();
    }

    public RepresentationMapRefBeanImpl(RepresentationMapRefType refBean, SdmxStructureBean parent) {
        super(SDMX_STRUCTURE_TYPE.REPRESENTATION_MAP, parent);
        this.codelistMap = new CrossReferenceBeanImpl((SDMXBean)this, refBean.getRepresentationMapAgencyID(), refBean.getRepresentationMapID(), "1.0", SDMX_STRUCTURE_TYPE.CODE_LIST);
        try {
            this.validate();
        }
        catch (SdmxSemmanticException ex) {
            throw new SdmxSemmanticException((Throwable)ex, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
        catch (Throwable th) {
            throw new SdmxException(th, ExceptionCode.BEAN_STRUCTURE_CONSTRUCTION_ERROR, new Object[]{this});
        }
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            RepresentationMapRefBean that = (RepresentationMapRefBean)bean;
            if (!super.equivalent(this.codelistMap, that.getCodelistMap())) {
                return false;
            }
            if (!ObjectUtil.equivalent((Object)this.toValueType, (Object)that.getToValueType())) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.valueMappings.keySet(), that.getValueMappings().keySet())) {
                return false;
            }
            return ObjectUtil.equivalentCollection(this.valueMappings.values(), that.getValueMappings().values());
        }
        return false;
    }

    private void validate() throws SdmxSemmanticException {
        if (this.codelistMap == null && this.valueMappings.size() == 0 && this.toTextFormat == null) {
            throw new SdmxSemmanticException("RepresentationMapping requires either a codelistMap, ToTextFormat or ValueMap");
        }
        if (this.toTextFormat != null && this.toValueType == null) {
            throw new SdmxSemmanticException("For RepresentationMapping, if using ToTextFormat ToValueType is also required");
        }
    }

    public CrossReferenceBean getCodelistMap() {
        return this.codelistMap;
    }

    public TextFormatBean getToTextFormat() {
        return this.toTextFormat;
    }

    public TO_VALUE getToValueType() {
        return this.toValueType;
    }

    public Map<String, String> getValueMappings() {
        return new HashMap<String, String>(this.valueMappings);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet((SDMXBean)this.toTextFormat, composites);
        return composites;
    }
}

