/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.beans.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.MaintainableReferenceBaseType;
import org.sdmx.resources.sdmxml.schemas.v21.common.SetReferenceType;
import org.sdmx.resources.sdmxml.schemas.v21.structure.ConstraintAttachmentType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.model.beans.base.DataSourceBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.SdmxStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.CrossReferenceBean;
import org.sdmxsource.sdmx.api.model.beans.reference.DataAndMetadataSetReference;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintAttachmentBean;
import org.sdmxsource.sdmx.api.model.beans.registry.AttachmentConstraintBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.DataSourceBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SdmxStructureBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.reference.DataAndMetadataSetReferenceImpl;
import org.sdmxsource.sdmx.sdmxbeans.util.RefUtil;
import org.sdmxsource.util.ObjectUtil;

public class AttachmentConstraintAttachmentBeanImpl
extends SdmxStructureBeanImpl
implements AttachmentConstraintAttachmentBean {
    private static final long serialVersionUID = 8990636645123835141L;
    private List<DataAndMetadataSetReference> dataOrMetadataSetReference = new ArrayList<DataAndMetadataSetReference>();
    private List<CrossReferenceBean> structureReferences = new ArrayList<CrossReferenceBean>();
    private List<DataSourceBean> dataSources = new ArrayList<DataSourceBean>();
    private SDMX_STRUCTURE_TYPE targetStructure;

    public AttachmentConstraintAttachmentBeanImpl(ConstraintAttachmentType type, AttachmentConstraintBean parent) {
        super(SDMX_STRUCTURE_TYPE.ATTACHMENT_CONSTRAINT_ATTACHMENT, (SdmxStructureBean)parent);
        CrossReferenceBean dataProviderRef;
        if (ObjectUtil.validCollection(type.getDataSetList())) {
            this.targetStructure = SDMX_STRUCTURE_TYPE.DATASET;
            for (SetReferenceType setReferenceType : type.getDataSetList()) {
                dataProviderRef = RefUtil.createReference(this, setReferenceType.getDataProvider());
                this.dataOrMetadataSetReference.add(new DataAndMetadataSetReferenceImpl(dataProviderRef, setReferenceType.getID(), true));
            }
        }
        if (ObjectUtil.validCollection(type.getMetadataSetList())) {
            this.targetStructure = SDMX_STRUCTURE_TYPE.METADATA_SET;
            for (SetReferenceType setReferenceType : type.getMetadataSetList()) {
                dataProviderRef = RefUtil.createReference(this, setReferenceType.getDataProvider());
                this.dataOrMetadataSetReference.add(new DataAndMetadataSetReferenceImpl(dataProviderRef, setReferenceType.getID(), false));
            }
        }
        if (ObjectUtil.validCollection(type.getSimpleDataSourceList())) {
            this.targetStructure = SDMX_STRUCTURE_TYPE.DATASOURCE;
            for (String string : type.getSimpleDataSourceList()) {
                this.dataSources.add(new DataSourceBeanImpl(string, (SdmxStructureBean)this));
            }
        }
        for (MaintainableReferenceBaseType maintainableReferenceBaseType : type.getDataStructureList()) {
            this.addRef(maintainableReferenceBaseType);
        }
        for (MaintainableReferenceBaseType maintainableReferenceBaseType : type.getMetadataStructureList()) {
            this.addRef(maintainableReferenceBaseType);
        }
        for (MaintainableReferenceBaseType maintainableReferenceBaseType : type.getDataflowList()) {
            this.addRef(maintainableReferenceBaseType);
        }
        for (MaintainableReferenceBaseType maintainableReferenceBaseType : type.getMetadataflowList()) {
            this.addRef(maintainableReferenceBaseType);
        }
        for (MaintainableReferenceBaseType maintainableReferenceBaseType : type.getProvisionAgreementList()) {
            this.addRef(maintainableReferenceBaseType);
        }
    }

    private void addRef(MaintainableReferenceBaseType refType) {
        CrossReferenceBean crossRef = RefUtil.createReference(this, refType);
        this.targetStructure = crossRef.getTargetReference();
        this.structureReferences.add(crossRef);
    }

    @Override
    public boolean deepEquals(SDMXBean bean, boolean includeFinalProperties) {
        if (bean == null) {
            return false;
        }
        if (bean.getStructureType() == this.getStructureType()) {
            AttachmentConstraintAttachmentBean that = (AttachmentConstraintAttachmentBean)bean;
            if (!ObjectUtil.equivalentCollection(this.dataOrMetadataSetReference, (Collection)that.getDataOrMetadataSetReference())) {
                return false;
            }
            if (!super.equivalent(this.dataSources, that.getDatasources(), includeFinalProperties)) {
                return false;
            }
            if (!ObjectUtil.equivalentCollection(this.structureReferences, (Collection)that.getStructureReferences())) {
                return false;
            }
            return this.targetStructure == that.getTargetStructureType();
        }
        return false;
    }

    public List<CrossReferenceBean> getStructureReferences() {
        return new ArrayList<CrossReferenceBean>(this.structureReferences);
    }

    public List<DataAndMetadataSetReference> getDataOrMetadataSetReference() {
        return new ArrayList<DataAndMetadataSetReference>(this.dataOrMetadataSetReference);
    }

    public SDMX_STRUCTURE_TYPE getTargetStructureType() {
        return this.targetStructure;
    }

    public ArrayList<DataSourceBean> getDatasources() {
        return new ArrayList<DataSourceBean>(this.dataSources);
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        Set<SDMXBean> composites = super.getCompositesInternal();
        super.addToCompositeSet(this.dataSources, composites);
        return composites;
    }
}

