/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.metadata;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sdmx.resources.sdmxml.schemas.v21.common.TextType;
import org.sdmx.resources.sdmxml.schemas.v21.common.XHTMLType;
import org.sdmx.resources.sdmxml.schemas.v21.metadata.generic.ReportedAttributeType;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxSemmanticException;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.base.TextTypeWrapper;
import org.sdmxsource.sdmx.api.model.metadata.ReportedAttributeBean;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.SDMXBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.beans.base.TextTypeWrapperImpl;
import org.sdmxsource.util.ObjectUtil;

public class ReportedAttributeBeanImpl
extends SDMXBeanImpl
implements ReportedAttributeBean {
    private static final long serialVersionUID = -7555198249383281384L;
    private String id;
    private String simpleValue;
    private List<TextTypeWrapper> metadataText = new ArrayList<TextTypeWrapper>();
    private List<ReportedAttributeBean> reportedAttribute = new ArrayList<ReportedAttributeBean>();

    public ReportedAttributeBeanImpl(SDMXBean parent, ReportedAttributeType type) {
        super(SDMX_STRUCTURE_TYPE.METADATA_REPORT_ATTRIBUTE, parent);
        this.id = type.getId();
        if (ObjectUtil.validCollection(type.getStructuredTextList())) {
            for (XHTMLType xHTMLType : type.getStructuredTextList()) {
                this.metadataText.add(new TextTypeWrapperImpl(xHTMLType, (SDMXBean)this));
            }
        }
        if (ObjectUtil.validCollection(type.getTextList())) {
            for (TextType textType : type.getTextList()) {
                this.metadataText.add(new TextTypeWrapperImpl(textType, (SDMXBean)this));
            }
        }
        if (type.getAttributeSet() != null) {
            for (ReportedAttributeType reportedAttributeType : type.getAttributeSet().getReportedAttributeList()) {
                this.reportedAttribute.add(new ReportedAttributeBeanImpl(this, reportedAttributeType));
            }
        }
        this.simpleValue = type.getValue();
        this.validate();
    }

    private void validate() {
        if (!ObjectUtil.validString((String[])new String[]{this.id})) {
            throw new SdmxSemmanticException("Metadata Reported Attribute must have an Id");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getSimpleValue() {
        return this.simpleValue;
    }

    public boolean hasSimpleValue() {
        return this.simpleValue != null;
    }

    public List<TextTypeWrapper> getMetadataText() {
        return new ArrayList<TextTypeWrapper>(this.metadataText);
    }

    public List<ReportedAttributeBean> getReportedAttributes() {
        return new ArrayList<ReportedAttributeBean>(this.reportedAttribute);
    }

    public boolean isPresentational() {
        return this.metadataText.size() == 0;
    }

    @Override
    protected Set<SDMXBean> getCompositesInternal() {
        HashSet<SDMXBean> composites = new HashSet<SDMXBean>();
        super.addToCompositeSet(this.metadataText, composites);
        super.addToCompositeSet(this.reportedAttribute, composites);
        return composites;
    }
}

