/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.codelist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodeBean;
import org.sdmxsource.sdmx.api.model.beans.codelist.CodelistBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.codelist.CodelistSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.MaintainableSuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.codelist.CodeSuperBeanImpl;
import org.sdmxsource.util.ObjectUtil;

public class CodelistSuperBeanImpl
extends MaintainableSuperBeanImpl
implements CodelistSuperBean {
    private static final transient Logger LOG = Logger.getLogger(CodelistSuperBeanImpl.class);
    private static final long serialVersionUID = 1L;
    private List<CodeSuperBean> codes = new ArrayList<CodeSuperBean>();
    private Map<String, CodeSuperBean> codeValueMap = new HashMap<String, CodeSuperBean>();
    private CodelistBean codelistBean;

    public CodelistSuperBeanImpl(CodelistBean codelist) {
        super((MaintainableBean)codelist);
        LOG.debug((Object)"Create Codelist Super Bean");
        this.codelistBean = codelist;
        List allCodes = codelist.getItems();
        if (allCodes != null) {
            HashMap<CodeBean, List<CodeBean>> codeChildMap = new HashMap<CodeBean, List<CodeBean>>();
            LOG.debug((Object)"Create code Child Map");
            for (CodeBean currentCode : allCodes) {
                if (!ObjectUtil.validString((String[])new String[]{currentCode.getParentCode()})) continue;
                CodeBean parent = codelist.getCodeById(currentCode.getParentCode());
                ArrayList<CodeBean> children = (ArrayList<CodeBean>)codeChildMap.get(parent);
                if (children == null) {
                    children = new ArrayList<CodeBean>();
                    codeChildMap.put(parent, children);
                }
                children.add(currentCode);
            }
            LOG.debug((Object)"Map Created");
            for (CodeBean currentCode : allCodes) {
                if (ObjectUtil.validString((String[])new String[]{currentCode.getParentCode()})) continue;
                LOG.debug((Object)("Create Top Level Code Super Bean: " + currentCode.getId()));
                CodeSuperBeanImpl code = new CodeSuperBeanImpl(this, currentCode, codeChildMap, null);
                LOG.debug((Object)("Create Top Level Code Super Bean Created: " + currentCode.getId()));
                this.codes.add(code);
            }
        }
        this.buildCodeValueMap(this.codes);
    }

    public List<CodeSuperBean> getCodes() {
        return new ArrayList<CodeSuperBean>(this.codes);
    }

    public CodeSuperBean getCodeByValue(String value) {
        return this.codeValueMap.get(value);
    }

    public CodelistBean getBuiltFrom() {
        return this.codelistBean;
    }

    @Override
    public Set<MaintainableBean> getCompositeBeans() {
        Set<MaintainableBean> returnSet = super.getCompositeBeans();
        returnSet.add((MaintainableBean)this.codelistBean);
        return returnSet;
    }

    private void buildCodeValueMap(List<CodeSuperBean> codes) {
        for (CodeSuperBean currentCode : codes) {
            if (currentCode.hasChildren()) {
                this.buildCodeValueMap(currentCode.getChildren());
            }
            this.codeValueMap.put(currentCode.getId(), currentCode);
        }
    }
}

