/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.SDMX_STRUCTURE_TYPE;
import org.sdmxsource.sdmx.api.exception.SdmxReferenceException;
import org.sdmxsource.sdmx.api.manager.retrieval.IdentifiableRetrievalManager;
import org.sdmxsource.sdmx.api.model.beans.base.IdentifiableBean;
import org.sdmxsource.sdmx.api.model.beans.base.MaintainableBean;
import org.sdmxsource.sdmx.api.model.beans.base.SDMXBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.MetadataAttributeBean;
import org.sdmxsource.sdmx.api.model.beans.metadatastructure.ReportStructureBean;
import org.sdmxsource.sdmx.api.model.beans.reference.StructureReferenceBean;
import org.sdmxsource.sdmx.api.model.metadata.MetadataReportBean;
import org.sdmxsource.sdmx.api.model.metadata.ReportedAttributeBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.MetadataReportSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.ReportedAttributeSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.metadata.TargetSuperBean;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.base.SuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata.ReportedAttributeSuperBeanImpl;
import org.sdmxsource.sdmx.sdmxbeans.model.superbeans.metadata.TargetSuperBeanImpl;
import org.sdmxsource.sdmx.util.beans.reference.StructureReferenceBeanImpl;

public class MetadataReportSuperBeanImpl
extends SuperBeanImpl
implements MetadataReportSuperBean {
    private static final long serialVersionUID = 212629478840566281L;
    private TargetSuperBean target;
    private List<ReportedAttributeSuperBean> reportedAttributes = new ArrayList<ReportedAttributeSuperBean>();
    private MetadataReportBean builtFrom;

    public MetadataReportSuperBeanImpl(ReportStructureBean rs, MetadataReportBean builtFrom, IdentifiableRetrievalManager retrievalManager) {
        super((SDMXBean)builtFrom);
        this.builtFrom = builtFrom;
        this.target = new TargetSuperBeanImpl(builtFrom.getTarget(), retrievalManager);
        for (ReportedAttributeBean currentRA : builtFrom.getReportedAttributes()) {
            MetadataAttributeBean maBean = this.getMetadataAttributeForRepotedAttribute(currentRA, rs.getMetadataAttributes());
            this.reportedAttributes.add(new ReportedAttributeSuperBeanImpl(maBean, currentRA, retrievalManager));
        }
    }

    private MetadataAttributeBean getMetadataAttributeForRepotedAttribute(ReportedAttributeBean reportedAttribute, List<MetadataAttributeBean> mAttributeBeans) {
        for (MetadataAttributeBean currentMAttribute : mAttributeBeans) {
            if (!currentMAttribute.getId().equals(reportedAttribute.getId())) continue;
            return currentMAttribute;
        }
        MaintainableBean maint = (MaintainableBean)reportedAttribute.getParent(MaintainableBean.class, false);
        StructureReferenceBeanImpl sRef = new StructureReferenceBeanImpl(maint, SDMX_STRUCTURE_TYPE.METADATA_ATTRIBUTE, new String[]{reportedAttribute.getId()});
        throw new SdmxReferenceException((IdentifiableBean)maint, (StructureReferenceBean)sRef);
    }

    public String getId() {
        return this.builtFrom.getId();
    }

    public TargetSuperBean getTarget() {
        return this.target;
    }

    public List<ReportedAttributeSuperBean> getReportedAttributes() {
        return new ArrayList<ReportedAttributeSuperBean>(this.reportedAttributes);
    }

    @Override
    public Set<MaintainableBean> getCompositeBeans() {
        Set<MaintainableBean> returnSet = super.getCompositeBeans();
        if (this.target != null) {
            returnSet.addAll(this.target.getCompositeBeans());
        }
        if (this.reportedAttributes != null) {
            for (ReportedAttributeSuperBean reportedAttributeSuperBean : this.reportedAttributes) {
                returnSet.addAll(reportedAttributeSuperBean.getCompositeBeans());
            }
        }
        return returnSet;
    }

    public MetadataReportBean getBuiltFrom() {
        return this.builtFrom;
    }
}

