/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.expression.composite.condtional;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.analysis.tabulardata.expression.Expression;
import org.gcube.data.analysis.tabulardata.expression.MalformedExpressionException;
import org.gcube.data.analysis.tabulardata.expression.NotEvaluableDataTypeException;
import org.gcube.data.analysis.tabulardata.expression.Operator;
import org.gcube.data.analysis.tabulardata.expression.composite.CompositeExpression;
import org.gcube.data.analysis.tabulardata.expression.composite.condtional.ConditionalExpression;
import org.gcube.data.analysis.tabulardata.model.datatype.BooleanType;
import org.gcube.data.analysis.tabulardata.model.datatype.DataType;

@XmlRootElement(name="Case")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Case
extends CompositeExpression
implements ConditionalExpression {
    private static final long serialVersionUID = 7186075527181316821L;
    private List<WhenConstruct> whens;

    protected Case() {
    }

    public Case(WhenConstruct ... whens) {
        this.whens = Arrays.asList(whens);
    }

    @Override
    public Operator getOperator() {
        return Operator.CASE;
    }

    @Override
    public void validate() throws MalformedExpressionException {
        if (this.whens == null || this.whens.isEmpty()) {
            throw new MalformedExpressionException("empty case");
        }
        Class<?> dataTypeClass = null;
        try {
            for (WhenConstruct when : this.whens) {
                when.getWhen().validate();
                when.getThen().validate();
                if (!when.getWhen().getReturnedDataType().getClass().equals(BooleanType.class)) {
                    throw new MalformedExpressionException("the when part must return Boolean");
                }
                if (dataTypeClass == null) {
                    dataTypeClass = when.getThen().getReturnedDataType().getClass();
                    continue;
                }
                if (dataTypeClass.equals(when.getThen().getReturnedDataType().getClass())) continue;
                throw new MalformedExpressionException("all then parts must return the same type");
            }
        }
        catch (NotEvaluableDataTypeException nedt) {
            throw new MalformedExpressionException("expression types are not evaluable");
        }
    }

    public List<WhenConstruct> getWhenConstructs() {
        return this.whens;
    }

    @Override
    public DataType getReturnedDataType() throws NotEvaluableDataTypeException {
        return null;
    }

    public String toString() {
        return "Case [whens=" + this.whens + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.whens == null ? 0 : this.whens.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Case other = (Case)obj;
        return !(this.whens == null ? other.whens != null : !this.whens.equals(other.whens));
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class WhenConstruct
    implements Serializable {
        private static final long serialVersionUID = 7429597146623986788L;
        private Expression when;
        private Expression then;

        protected WhenConstruct() {
        }

        public WhenConstruct(Expression when, Expression then) {
            this.when = when;
            this.then = then;
        }

        public Expression getWhen() {
            return this.when;
        }

        public Expression getThen() {
            return this.then;
        }

        public void setWhen(Expression when) {
            this.when = when;
        }

        public void setThen(Expression then) {
            this.then = then;
        }

        public String toString() {
            return "WhenConstruct [when=" + this.when + ", then=" + this.then + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.then == null ? 0 : this.then.hashCode());
            result = 31 * result + (this.when == null ? 0 : this.when.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WhenConstruct other = (WhenConstruct)obj;
            if (this.then == null ? other.then != null : !this.then.equals(other.then)) {
                return false;
            }
            return !(this.when == null ? other.when != null : !this.when.equals(other.when));
        }
    }
}

