/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.analysis.tabulardata.commons.templates.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.TemplateCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.GroupAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.actions.finals.AddToFlowAction;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnCategory;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.ColumnDescription;
import org.gcube.data.analysis.tabulardata.commons.templates.model.columns.TemplateColumn;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.OnRowErrorAction;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Template
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotEmpty
    private List<TemplateColumn<?>> columns;
    @NotNull
    private OnRowErrorAction onRowErrorAction = OnRowErrorAction.ASK;
    @NotNull
    private List<TemplateAction<Long>> actions = new ArrayList<TemplateAction<Long>>();
    private AddToFlowAction addToFlowAction;
    private TemplateCategory category;

    public static Template create(TemplateCategory templateType, TemplateColumn<?> ... columns) {
        return new Template(templateType, columns);
    }

    private Template() {
    }

    private Template(TemplateCategory templateType, TemplateColumn<?>[] columns) {
        for (TemplateColumn<?> column : columns) {
            if (Template.containsColumnCategory(templateType.getAllowedColumn(), column.getColumnType())) continue;
            throw new IllegalArgumentException(String.format("column type %s not allowed for template type %s ", column.getColumnType().name(), templateType.name()));
        }
        this.columns = Arrays.asList(columns);
        this.category = templateType;
    }

    private static boolean containsColumnCategory(List<ColumnDescription> allowedColumns, ColumnCategory columnType) {
        for (ColumnDescription desc : allowedColumns) {
            if (desc.getColumnCategory() != columnType) continue;
            return true;
        }
        return false;
    }

    public List<TemplateColumn<?>> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public void setColumns(List<TemplateColumn<?>> columns) {
        this.columns = columns;
    }

    public List<TemplateColumn<?>> getActualStructure() {
        if (this.actions.isEmpty()) {
            return this.getColumns();
        }
        List<TemplateColumn<?>> actualStructure = this.getColumns();
        for (TemplateAction<Long> action : this.actions) {
            actualStructure = action.getPostOperationStructure(actualStructure);
        }
        return actualStructure;
    }

    public OnRowErrorAction getOnRowErrorAction() {
        return this.onRowErrorAction;
    }

    public void setOnErrorAction(OnRowErrorAction onErrorAction) {
        this.onRowErrorAction = onErrorAction;
    }

    public List<TemplateAction<Long>> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public void addAction(TemplateAction<Long> action) {
        this.actions.add(action);
    }

    public void addAction(GroupAction groupAction) {
        this.actions.addAll(groupAction.getActions());
    }

    public void removeLastAction() {
        TemplateAction<Long> lastAction = this.actions.remove(this.actions.size() - 1);
        String groupId = lastAction.getBelongsToGroup();
        while (groupId != null && groupId.equals(this.actions.get(this.actions.size() - 1).getBelongsToGroup())) {
            this.actions.remove(this.actions.size() - 1);
        }
    }

    public AddToFlowAction getAddToFlow() {
        return this.addToFlowAction;
    }

    public void setAddToFlow(AddToFlowAction addToFlow) {
        this.addToFlowAction = addToFlow;
    }

    public TemplateCategory getCategory() {
        return this.category;
    }

    public String toString() {
        return "Template [columns=" + this.columns + ", onErrorAction=" + (Object)((Object)this.onRowErrorAction) + ", actions=" + this.actions + ", addToFlowAction=" + this.addToFlowAction + "]";
    }
}

