/*
 * Decompiled with CFR 0.152.
 */
package org.sdmxsource.sdmx.dataparser.manager.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.sdmxsource.sdmx.api.constants.DATA_TYPE;
import org.sdmxsource.sdmx.api.constants.ExceptionCode;
import org.sdmxsource.sdmx.api.constants.SDMX_SCHEMA;
import org.sdmxsource.sdmx.api.exception.SdmxException;
import org.sdmxsource.sdmx.api.exception.SdmxNotImplementedException;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DataStructureSuperBean;
import org.sdmxsource.sdmx.api.model.superbeans.datastructure.DimensionSuperBean;
import org.sdmxsource.sdmx.dataparser.manager.SchemaGenerationManager;
import org.sdmxsource.sdmx.dataparser.transform.impl.SchemaGeneratorCompact;
import org.sdmxsource.sdmx.dataparser.transform.impl.SchemaGeneratorUtility;
import org.sdmxsource.util.io.StreamUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SchemaGenerationManagerImpl
implements SchemaGenerationManager,
InitializingBean {
    @Autowired(required=false)
    private SchemaGeneratorCompact schemaGeneratorCompact;
    @Autowired(required=false)
    private SchemaGeneratorUtility schemaGeneratorUtility;

    @Override
    public void generateSchema(OutputStream out, DataStructureSuperBean dsd, String targetNamespace, DATA_TYPE schema, Map<String, Set<String>> constraintsMap) {
        SDMX_SCHEMA schemaVersion = schema.getSchemaVersion();
        switch (schema.getBaseDataFormat()) {
            case GENERIC: {
                FileInputStream is;
                try {
                    switch (schemaVersion) {
                        case VERSION_ONE: {
                            is = new FileInputStream("resources/xsd/v1_0/SDMXMessage.xsd");
                            break;
                        }
                        case VERSION_TWO: {
                            is = new FileInputStream("resources/xsd/v2_0/SDMXMessage.xsd");
                            break;
                        }
                        case VERSION_TWO_POINT_ONE: {
                            is = new FileInputStream("resources/xsd/v2_1/SDMXMessage.xsd");
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Generic format not supported in version : " + schemaVersion);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                StreamUtil.copyStream((InputStream)is, (OutputStream)out);
                break;
            }
            case COMPACT: {
                if (dsd == null) {
                    throw new SdmxException("Can not generate Schema. Data Structure was not provided");
                }
                this.schemaGeneratorCompact.transform(out, targetNamespace, schemaVersion, dsd, constraintsMap);
                break;
            }
            case UTILITY: {
                if (dsd == null) {
                    throw new SdmxException("Can not generate Schema. Data Structure was not provided");
                }
                if (schemaVersion == SDMX_SCHEMA.VERSION_TWO) {
                    this.schemaGeneratorUtility.transform(out, targetNamespace, schemaVersion, dsd, constraintsMap);
                    break;
                }
                throw new IllegalArgumentException("Can not create utility schema in version '" + schemaVersion + "' only version 2.0 supported");
            }
            default: {
                throw new SdmxNotImplementedException(ExceptionCode.UNSUPPORTED, new Object[]{"Schema generation for format " + schema.getBaseDataFormat()});
            }
        }
    }

    @Override
    public void generateCrossSectionalSchema(OutputStream out, DataStructureSuperBean dsd, String targetNamespace, DATA_TYPE schema, String crossSectionalDimensionId, Map<String, Set<String>> constraintsMap) {
        this.validateDimensionAtObservation(dsd, crossSectionalDimensionId);
        SDMX_SCHEMA schemaVersion = schema.getSchemaVersion();
        if (!(schemaVersion.equals((Object)SDMX_SCHEMA.VERSION_ONE) || schemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO) || schemaVersion.equals((Object)SDMX_SCHEMA.VERSION_TWO_POINT_ONE))) {
            throw new IllegalArgumentException("Invalid DATA_TYPE supplied. Invalid value of: " + schema);
        }
        this.schemaGeneratorCompact.transformCrossSectional(out, targetNamespace, schema.getSchemaVersion(), dsd, crossSectionalDimensionId, constraintsMap);
    }

    private void validateDimensionAtObservation(DataStructureSuperBean dsd, String dimAtObs) {
        if (dsd.getDimensionById(dimAtObs) == null) {
            StringBuilder sb = new StringBuilder();
            String concat = "";
            for (DimensionSuperBean dim : dsd.getDimensions()) {
                sb.append(concat + dim.getId());
                concat = ", ";
            }
            throw new SdmxException("Illegal dimension id '" + dimAtObs + "' for data structure: " + dsd + " allowable values are: " + sb.toString());
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.schemaGeneratorCompact == null) {
            this.schemaGeneratorCompact = new SchemaGeneratorCompact();
        }
    }
}

